/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;

class Token
implements Serializable {
    static final int ANCHOR = 8;
    static final int BACKREFERENCE = 12;
    static final int CHAR = 0;
    static final int CHAR_FINAL_QUOTE = 30;
    static final int CHAR_INIT_QUOTE = 29;
    static final int CHAR_LETTER = 31;
    static final int CHAR_MARK = 32;
    static final int CHAR_NUMBER = 33;
    static final int CHAR_OTHER = 35;
    static final int CHAR_PUNCTUATION = 36;
    static final int CHAR_SEPARATOR = 34;
    static final int CHAR_SYMBOL = 37;
    static final int CLOSURE = 3;
    static final int CONCAT = 1;
    static final int CONDITION = 26;
    static final boolean COUNTTOKENS = true;
    static final int DOT = 11;
    static final int EMPTY = 7;
    static final int FC_ANY = 2;
    static final int FC_CONTINUE = 0;
    static final int FC_TERMINAL = 1;
    static final int INDEPENDENT = 24;
    static final int LOOKAHEAD = 20;
    static final int LOOKBEHIND = 22;
    static final int MODIFIERGROUP = 25;
    static final int NEGATIVELOOKAHEAD = 21;
    static final int NEGATIVELOOKBEHIND = 23;
    private static final int NONBMP_BLOCK_START = 84;
    static final int NONGREEDYCLOSURE = 9;
    static final int NRANGE = 5;
    static final int PAREN = 6;
    static final int RANGE = 4;
    static final int STRING = 10;
    static final int UNION = 2;
    static final int UTF16_MAX = 0x10FFFF;
    private static final String[] blockNames;
    static final String blockRanges = "\u0000\u007f\u0080\u00ff\u0100\u017f\u0180\u024f\u0250\u02af\u02b0\u02ff\u0300\u036f\u0370\u03ff\u0400\u04ff\u0530\u058f\u0590\u05ff\u0600\u06ff\u0700\u074f\u0780\u07bf\u0900\u097f\u0980\u09ff\u0a00\u0a7f\u0a80\u0aff\u0b00\u0b7f\u0b80\u0bff\u0c00\u0c7f\u0c80\u0cff\u0d00\u0d7f\u0d80\u0dff\u0e00\u0e7f\u0e80\u0eff\u0f00\u0fff\u1000\u109f\u10a0\u10ff\u1100\u11ff\u1200\u137f\u13a0\u13ff\u1400\u167f\u1680\u169f\u16a0\u16ff\u1780\u17ff\u1800\u18af\u1e00\u1eff\u1f00\u1fff\u2000\u206f\u2070\u209f\u20a0\u20cf\u20d0\u20ff\u2100\u214f\u2150\u218f\u2190\u21ff\u2200\u22ff\u2300\u23ff\u2400\u243f\u2440\u245f\u2460\u24ff\u2500\u257f\u2580\u259f\u25a0\u25ff\u2600\u26ff\u2700\u27bf\u2800\u28ff\u2e80\u2eff\u2f00\u2fdf\u2ff0\u2fff\u3000\u303f\u3040\u309f\u30a0\u30ff\u3100\u312f\u3130\u318f\u3190\u319f\u31a0\u31bf\u3200\u32ff\u3300\u33ff\u3400\u4db5\u4e00\u9fff\ua000\ua48f\ua490\ua4cf\uac00\ud7a3\ue000\uf8ff\uf900\ufaff\ufb00\ufb4f\ufb50\ufdff\ufe20\ufe2f\ufe30\ufe4f\ufe50\ufe6f\ufe70\ufefe\ufeff\ufeff\uff00\uffef";
    private static final Hashtable categories;
    private static final Hashtable categories2;
    private static final String[] categoryNames;
    static final int[] nonBMPBlockRanges;
    static Hashtable nonxs;
    static Token token_0to9;
    private static Token token_ccs;
    static Token token_dot;
    static Token token_empty;
    private static Token token_grapheme;
    static Token token_linebeginning;
    static Token token_linebeginning2;
    static Token token_lineend;
    static Token token_not_0to9;
    static Token token_not_spaces;
    static Token token_not_wordchars;
    static Token token_not_wordedge;
    static Token token_spaces;
    static Token token_stringbeginning;
    static Token token_stringend;
    static Token token_stringend2;
    static Token token_wordbeginning;
    static Token token_wordchars;
    static Token token_wordedge;
    static Token token_wordend;
    static int tokens = 0;
    static final String viramaString = "\u094d\u09cd\u0a4d\u0acd\u0b4d\u0bcd\u0c4d\u0ccd\u0d4d\u0e3a\u0f84";
    int type;

    static {
        token_empty = new Token(7);
        token_linebeginning = Token.createAnchor(94);
        token_linebeginning2 = Token.createAnchor(64);
        token_lineend = Token.createAnchor(36);
        token_stringbeginning = Token.createAnchor(65);
        token_stringend = Token.createAnchor(122);
        token_stringend2 = Token.createAnchor(90);
        token_wordedge = Token.createAnchor(98);
        token_not_wordedge = Token.createAnchor(66);
        token_wordbeginning = Token.createAnchor(60);
        token_wordend = Token.createAnchor(62);
        token_dot = new Token(11);
        RangeToken rangeToken = Token.createRange();
        token_0to9 = rangeToken;
        ((Token)rangeToken).addRange(48, 57);
        rangeToken = Token.createRange();
        token_wordchars = rangeToken;
        ((Token)rangeToken).addRange(48, 57);
        token_wordchars.addRange(65, 90);
        token_wordchars.addRange(95, 95);
        token_wordchars.addRange(97, 122);
        rangeToken = Token.createRange();
        token_spaces = rangeToken;
        ((Token)rangeToken).addRange(9, 9);
        token_spaces.addRange(10, 10);
        token_spaces.addRange(12, 12);
        token_spaces.addRange(13, 13);
        token_spaces.addRange(32, 32);
        token_not_0to9 = Token.complementRanges(token_0to9);
        token_not_wordchars = Token.complementRanges(token_wordchars);
        token_not_spaces = Token.complementRanges(token_spaces);
        categories = new Hashtable();
        categories2 = new Hashtable();
        categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", null, "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "Pi", "Pf", "L", "M", "N", "Z", "C", "P", "S"};
        blockNames = new String[]{"Basic Latin", "Latin-1 Supplement", "Latin Extended-A", "Latin Extended-B", "IPA Extensions", "Spacing Modifier Letters", "Combining Diacritical Marks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "Hangul Jamo", "Ethiopic", "Cherokee", "Unified Canadian Aboriginal Syllabics", "Ogham", "Runic", "Khmer", "Mongolian", "Latin Extended Additional", "Greek Extended", "General Punctuation", "Superscripts and Subscripts", "Currency Symbols", "Combining Marks for Symbols", "Letterlike Symbols", "Number Forms", "Arrows", "Mathematical Operators", "Miscellaneous Technical", "Control Pictures", "Optical Character Recognition", "Enclosed Alphanumerics", "Box Drawing", "Block Elements", "Geometric Shapes", "Miscellaneous Symbols", "Dingbats", "Braille Patterns", "CJK Radicals Supplement", "Kangxi Radicals", "Ideographic Description Characters", "CJK Symbols and Punctuation", "Hiragana", "Katakana", "Bopomofo", "Hangul Compatibility Jamo", "Kanbun", "Bopomofo Extended", "Enclosed CJK Letters and Months", "CJK Compatibility", "CJK Unified Ideographs Extension A", "CJK Unified Ideographs", "Yi Syllables", "Yi Radicals", "Hangul Syllables", "Private Use", "CJK Compatibility Ideographs", "Alphabetic Presentation Forms", "Arabic Presentation Forms-A", "Combining Half Marks", "CJK Compatibility Forms", "Small Form Variants", "Arabic Presentation Forms-B", "Specials", "Halfwidth and Fullwidth Forms", "Old Italic", "Gothic", "Deseret", "Byzantine Musical Symbols", "Musical Symbols", "Mathematical Alphanumeric Symbols", "CJK Unified Ideographs Extension B", "CJK Compatibility Ideographs Supplement", "Tags"};
        nonBMPBlockRanges = new int[]{66304, 66351, 66352, 66383, 66560, 66639, 118784, 119039, 119040, 119295, 119808, 120831, 131072, 173782, 194560, 195103, 917504, 917631};
        nonxs = null;
        token_grapheme = null;
        token_ccs = null;
    }

    protected Token(int n) {
        this.type = n;
    }

    static Token complementRanges(Token token) {
        return RangeToken.complementRanges(token);
    }

    private static CharToken createAnchor(int n) {
        ++tokens;
        return new CharToken(8, n);
    }

    static StringToken createBackReference(int n) {
        ++tokens;
        return new StringToken(12, null, n);
    }

    static CharToken createChar(int n) {
        ++tokens;
        return new CharToken(0, n);
    }

    static ClosureToken createClosure(Token token) {
        ++tokens;
        return new ClosureToken(3, token);
    }

    static ConcatToken createConcat(Token token, Token token2) {
        ++tokens;
        return new ConcatToken(token, token2);
    }

    static UnionToken createConcat() {
        ++tokens;
        return new UnionToken(1);
    }

    static ConditionToken createCondition(int n, Token token, Token token2, Token token3) {
        ++tokens;
        return new ConditionToken(n, token, token2, token3);
    }

    static Token createEmpty() {
        return token_empty;
    }

    static ParenToken createLook(int n, Token token) {
        ++tokens;
        return new ParenToken(n, token, 0);
    }

    static ModifierToken createModifierGroup(Token token, int n, int n2) {
        ++tokens;
        return new ModifierToken(token, n, n2);
    }

    static ClosureToken createNGClosure(Token token) {
        ++tokens;
        return new ClosureToken(9, token);
    }

    static RangeToken createNRange() {
        ++tokens;
        return new RangeToken(5);
    }

    static ParenToken createParen(Token token, int n) {
        ++tokens;
        return new ParenToken(6, token, n);
    }

    static RangeToken createRange() {
        ++tokens;
        return new RangeToken(4);
    }

    static StringToken createString(String string2) {
        ++tokens;
        return new StringToken(10, string2, 0);
    }

    static UnionToken createUnion() {
        ++tokens;
        return new UnionToken(2);
    }

    static Token getCombiningCharacterSequence() {
        synchronized (Token.class) {
            Token token;
            block5: {
                token = token_ccs;
                if (token == null) break block5;
                return token;
            }
            token = Token.createClosure(Token.getRange("M", true));
            token_ccs = token = Token.createConcat(Token.getRange("M", false), token);
            return token;
        }
    }

    static Token getGraphemePattern() {
        synchronized (Token.class) {
            int n;
            Token token;
            Token token2;
            block9: {
                token2 = token_grapheme;
                if (token2 == null) break block9;
                return token2;
            }
            try {
                token = Token.createRange();
                token.mergeRanges(Token.getRange("ASSIGNED", true));
                token.subtractRanges(Token.getRange("M", true));
                token.subtractRanges(Token.getRange("C", true));
                token2 = Token.createRange();
                n = 0;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
            while (true) {
                if (n >= 11) {
                    RangeToken rangeToken = Token.createRange();
                    ((Token)rangeToken).mergeRanges(Token.getRange("M", true));
                    ((Token)rangeToken).addRange(4448, 4607);
                    ((Token)rangeToken).addRange(65438, 65439);
                    UnionToken unionToken = Token.createUnion();
                    ((Token)unionToken).addChild(token);
                    ((Token)unionToken).addChild(token_empty);
                    token = Token.createUnion();
                    token.addChild(Token.createConcat(token2, Token.getRange("L", true)));
                    token.addChild(rangeToken);
                    token_grapheme = token2 = Token.createConcat(unionToken, Token.createClosure(token));
                    return token2;
                }
                viramaString.charAt(n);
                token2.addRange(n, n);
                ++n;
                continue;
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static RangeToken getRange(String var0, boolean var1_2) {
        block43: {
            var2_3 = Token.categories;
            if (var2_3.size() != 0) break block43;
            synchronized (var2_3) {
                var3_4 = Token.categoryNames.length;
                var4_5 = new Token[var3_4];
                var5_6 = 0;
                while (true) {
                    if (var5_6 < var3_4) ** GOTO lbl244
                    var6_7 = 0;
                    block28: while (true) {
                        block46: {
                            block51: {
                                block50: {
                                    block47: {
                                        var7_8 = 34;
                                        if (var6_7 < 65536) break block47;
                                        var4_5[0].addRange(65536, 0x10FFFF);
                                        var5_6 = 0;
                                        while (true) {
                                            block49: {
                                                block48: {
                                                    if (var5_6 < var3_4) break block48;
                                                    var8_10 = new StringBuffer(50);
                                                    var5_6 = 0;
                                                    while (true) {
                                                        block45: {
                                                            block44: {
                                                                var9_11 = Token.blockNames;
                                                                if (var5_6 >= ((String[])var9_11).length) {
                                                                    Token.setAlias("ASSIGNED", "Cn", false);
                                                                    Token.setAlias("UNASSIGNED", "Cn", true);
                                                                    var9_11 = Token.createRange();
                                                                    var9_11.addRange(0, 0x10FFFF);
                                                                    var10_12 = Token.categories;
                                                                    var10_12.put("ALL", var9_11);
                                                                    var8_10 = Token.categories2;
                                                                    var8_10.put("ALL", Token.complementRanges((Token)var9_11));
                                                                    Token.registerNonXS("ASSIGNED");
                                                                    Token.registerNonXS("UNASSIGNED");
                                                                    Token.registerNonXS("ALL");
                                                                    var11_13 = Token.createRange();
                                                                    var11_13.mergeRanges(var4_5[1]);
                                                                    var11_13.mergeRanges(var4_5[2]);
                                                                    var11_13.mergeRanges(var4_5[5]);
                                                                    var10_12.put("IsAlpha", var11_13);
                                                                    var8_10.put("IsAlpha", Token.complementRanges((Token)var11_13));
                                                                    Token.registerNonXS("IsAlpha");
                                                                    var9_11 = Token.createRange();
                                                                    var9_11.mergeRanges((Token)var11_13);
                                                                    var9_11.mergeRanges(var4_5[9]);
                                                                    var10_12.put("IsAlnum", var9_11);
                                                                    var8_10.put("IsAlnum", Token.complementRanges((Token)var9_11));
                                                                    Token.registerNonXS("IsAlnum");
                                                                    var11_13 = Token.createRange();
                                                                    var11_13.mergeRanges(Token.token_spaces);
                                                                    var11_13.mergeRanges(var4_5[34]);
                                                                    var10_12.put("IsSpace", var11_13);
                                                                    var8_10.put("IsSpace", Token.complementRanges((Token)var11_13));
                                                                    Token.registerNonXS("IsSpace");
                                                                    var11_13 = Token.createRange();
                                                                    var11_13.mergeRanges((Token)var9_11);
                                                                    var11_13.addRange(95, 95);
                                                                    var10_12.put("IsWord", var11_13);
                                                                    var8_10.put("IsWord", Token.complementRanges((Token)var11_13));
                                                                    Token.registerNonXS("IsWord");
                                                                    var9_11 = Token.createRange();
                                                                    var9_11.addRange(0, 127);
                                                                    var10_12.put("IsASCII", var9_11);
                                                                    var8_10.put("IsASCII", Token.complementRanges((Token)var9_11));
                                                                    Token.registerNonXS("IsASCII");
                                                                    var9_11 = Token.createRange();
                                                                    var9_11.mergeRanges(var4_5[35]);
                                                                    var9_11.addRange(32, 32);
                                                                    var10_12.put("IsGraph", Token.complementRanges((Token)var9_11));
                                                                    var8_10.put("IsGraph", var9_11);
                                                                    Token.registerNonXS("IsGraph");
                                                                    var4_5 = Token.createRange();
                                                                    var4_5.addRange(48, 57);
                                                                    var4_5.addRange(65, 70);
                                                                    var4_5.addRange(97, 102);
                                                                    var10_12.put("IsXDigit", Token.complementRanges((Token)var4_5));
                                                                    var8_10.put("IsXDigit", var4_5);
                                                                    Token.registerNonXS("IsXDigit");
                                                                    Token.setAlias("IsDigit", "Nd", true);
                                                                    Token.setAlias("IsUpper", "Lu", true);
                                                                    Token.setAlias("IsLower", "Ll", true);
                                                                    Token.setAlias("IsCntrl", "C", true);
                                                                    Token.setAlias("IsPrint", "C", false);
                                                                    Token.setAlias("IsPunct", "P", true);
                                                                    Token.registerNonXS("IsDigit");
                                                                    Token.registerNonXS("IsUpper");
                                                                    Token.registerNonXS("IsLower");
                                                                    Token.registerNonXS("IsCntrl");
                                                                    Token.registerNonXS("IsPrint");
                                                                    Token.registerNonXS("IsPunct");
                                                                    Token.setAlias("alpha", "IsAlpha", true);
                                                                    Token.setAlias("alnum", "IsAlnum", true);
                                                                    Token.setAlias("ascii", "IsASCII", true);
                                                                    Token.setAlias("cntrl", "IsCntrl", true);
                                                                    Token.setAlias("digit", "IsDigit", true);
                                                                    Token.setAlias("graph", "IsGraph", true);
                                                                    Token.setAlias("lower", "IsLower", true);
                                                                    Token.setAlias("print", "IsPrint", true);
                                                                    Token.setAlias("punct", "IsPunct", true);
                                                                    Token.setAlias("space", "IsSpace", true);
                                                                    Token.setAlias("upper", "IsUpper", true);
                                                                    Token.setAlias("word", "IsWord", true);
                                                                    Token.setAlias("xdigit", "IsXDigit", true);
                                                                    Token.registerNonXS("alpha");
                                                                    Token.registerNonXS("alnum");
                                                                    Token.registerNonXS("ascii");
                                                                    Token.registerNonXS("cntrl");
                                                                    Token.registerNonXS("digit");
                                                                    Token.registerNonXS("graph");
                                                                    Token.registerNonXS("lower");
                                                                    Token.registerNonXS("print");
                                                                    Token.registerNonXS("punct");
                                                                    Token.registerNonXS("space");
                                                                    Token.registerNonXS("upper");
                                                                    Token.registerNonXS("word");
                                                                    Token.registerNonXS("xdigit");
                                                                    break block43;
                                                                }
                                                                var10_12 = Token.createRange();
                                                                if (var5_6 >= 84) break block44;
                                                                var12_9 = var5_6 * 2;
                                                                var10_12.addRange("\u0000\u007f\u0080\u00ff\u0100\u017f\u0180\u024f\u0250\u02af\u02b0\u02ff\u0300\u036f\u0370\u03ff\u0400\u04ff\u0530\u058f\u0590\u05ff\u0600\u06ff\u0700\u074f\u0780\u07bf\u0900\u097f\u0980\u09ff\u0a00\u0a7f\u0a80\u0aff\u0b00\u0b7f\u0b80\u0bff\u0c00\u0c7f\u0c80\u0cff\u0d00\u0d7f\u0d80\u0dff\u0e00\u0e7f\u0e80\u0eff\u0f00\u0fff\u1000\u109f\u10a0\u10ff\u1100\u11ff\u1200\u137f\u13a0\u13ff\u1400\u167f\u1680\u169f\u16a0\u16ff\u1780\u17ff\u1800\u18af\u1e00\u1eff\u1f00\u1fff\u2000\u206f\u2070\u209f\u20a0\u20cf\u20d0\u20ff\u2100\u214f\u2150\u218f\u2190\u21ff\u2200\u22ff\u2300\u23ff\u2400\u243f\u2440\u245f\u2460\u24ff\u2500\u257f\u2580\u259f\u25a0\u25ff\u2600\u26ff\u2700\u27bf\u2800\u28ff\u2e80\u2eff\u2f00\u2fdf\u2ff0\u2fff\u3000\u303f\u3040\u309f\u30a0\u30ff\u3100\u312f\u3130\u318f\u3190\u319f\u31a0\u31bf\u3200\u32ff\u3300\u33ff\u3400\u4db5\u4e00\u9fff\ua000\ua48f\ua490\ua4cf\uac00\ud7a3\ue000\uf8ff\uf900\ufaff\ufb00\ufb4f\ufb50\ufdff\ufe20\ufe2f\ufe30\ufe4f\ufe50\ufe6f\ufe70\ufefe\ufeff\ufeff\uff00\uffef".charAt(var12_9), "\u0000\u007f\u0080\u00ff\u0100\u017f\u0180\u024f\u0250\u02af\u02b0\u02ff\u0300\u036f\u0370\u03ff\u0400\u04ff\u0530\u058f\u0590\u05ff\u0600\u06ff\u0700\u074f\u0780\u07bf\u0900\u097f\u0980\u09ff\u0a00\u0a7f\u0a80\u0aff\u0b00\u0b7f\u0b80\u0bff\u0c00\u0c7f\u0c80\u0cff\u0d00\u0d7f\u0d80\u0dff\u0e00\u0e7f\u0e80\u0eff\u0f00\u0fff\u1000\u109f\u10a0\u10ff\u1100\u11ff\u1200\u137f\u13a0\u13ff\u1400\u167f\u1680\u169f\u16a0\u16ff\u1780\u17ff\u1800\u18af\u1e00\u1eff\u1f00\u1fff\u2000\u206f\u2070\u209f\u20a0\u20cf\u20d0\u20ff\u2100\u214f\u2150\u218f\u2190\u21ff\u2200\u22ff\u2300\u23ff\u2400\u243f\u2440\u245f\u2460\u24ff\u2500\u257f\u2580\u259f\u25a0\u25ff\u2600\u26ff\u2700\u27bf\u2800\u28ff\u2e80\u2eff\u2f00\u2fdf\u2ff0\u2fff\u3000\u303f\u3040\u309f\u30a0\u30ff\u3100\u312f\u3130\u318f\u3190\u319f\u31a0\u31bf\u3200\u32ff\u3300\u33ff\u3400\u4db5\u4e00\u9fff\ua000\ua48f\ua490\ua4cf\uac00\ud7a3\ue000\uf8ff\uf900\ufaff\ufb00\ufb4f\ufb50\ufdff\ufe20\ufe2f\ufe30\ufe4f\ufe50\ufe6f\ufe70\ufefe\ufeff\ufeff\uff00\uffef".charAt(var12_9 + 1));
                                                            }
                                                            var12_9 = (var5_6 - 84) * 2;
                                                            var11_13 = Token.nonBMPBlockRanges;
                                                            var10_12.addRange(var11_13[var12_9], var11_13[var12_9 + 1]);
                                                            var9_11 = var9_11[var5_6];
                                                            if (var9_11.equals("Specials")) {
                                                                var10_12.addRange(65520, 65533);
                                                            }
                                                            if (var9_11.equals("Private Use")) {
                                                                var10_12.addRange(983040, 1048573);
                                                                var10_12.addRange(0x100000, 1114109);
                                                            }
                                                            Token.categories.put(var9_11, var10_12);
                                                            Token.categories2.put(var9_11, Token.complementRanges((Token)var10_12));
                                                            var8_10.setLength(0);
                                                            var8_10.append("Is");
                                                            if (var9_11.indexOf(32) < 0) break block45;
                                                            var12_9 = 0;
                                                            while (true) {
                                                                if (var12_9 < var9_11.length()) {
                                                                    if (var9_11.charAt(var12_9) != ' ') {
                                                                        var8_10.append(var9_11.charAt(var12_9));
                                                                    }
                                                                    ++var12_9;
                                                                    continue;
                                                                }
                                                                ** GOTO lbl175
                                                                break;
                                                            }
                                                        }
                                                        var8_10.append((String)var9_11);
lbl175:
                                                        // 2 sources

                                                        Token.setAlias(var8_10.toString(), (String)var9_11, true);
                                                        ++var5_6;
                                                        continue;
                                                        break;
                                                    }
                                                }
                                                var8_10 = Token.categoryNames;
                                                if (var8_10[var5_6] == null) break block49;
                                                if (var5_6 != 0) ** GOTO lbl185
                                                var4_5[var5_6].addRange(65536, 0x10FFFF);
lbl185:
                                                // 2 sources

                                                Token.categories.put(var8_10[var5_6], var4_5[var5_6]);
                                                Token.categories2.put(var8_10[var5_6], Token.complementRanges(var4_5[var5_6]));
                                            }
                                            ++var5_6;
                                        }
                                    }
                                    var5_6 = Character.getType((char)var6_7);
                                    if (var5_6 != 21) {
                                        var12_9 = var5_6;
                                        if (var5_6 != 22) break block46;
                                    }
                                    if (var6_7 == 171 || var6_7 == 8216 || var6_7 == 8219 || var6_7 == 8220 || var6_7 == 8223) break block50;
                                    var12_9 = var5_6;
                                    if (var6_7 != 8249) break block51;
                                }
                                var12_9 = 29;
                            }
                            if (var6_7 != 187 && var6_7 != 8217 && var6_7 != 8221 && var6_7 != 8250) break block46;
                            var12_9 = 30;
                        }
                        var4_5[var12_9].addRange(var6_7, var6_7);
                        var5_6 = var7_8;
                        switch (var12_9) {
                            default: {
                                break block28;
                            }
                            case 25: 
                            case 26: 
                            case 27: 
                            case 28: {
                                var5_6 = 37;
                                ** GOTO lbl231
                            }
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 29: 
                            case 30: {
                                var5_6 = 36;
                                ** GOTO lbl231
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                var5_6 = 33;
                                ** GOTO lbl231
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                var5_6 = 32;
                                ** GOTO lbl231
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                var5_6 = 31;
                                ** GOTO lbl231
                            }
                            case 0: 
                            case 15: 
                            case 16: 
                            case 18: 
                            case 19: {
                                var5_6 = 35;
                            }
lbl231:
                            // 7 sources

                            case 12: 
                            case 13: 
                            case 14: {
                                var4_5[var5_6].addRange(var6_7, var6_7);
                                ++var6_7;
                                continue block28;
                            }
                        }
                        break;
                    }
                    var0 = new StringBuffer();
                    var0.append("org.apache.xerces.utils.regex.Token#getRange(): Unknown Unicode category: ");
                    var0.append(var12_9);
                    var4_5 = new RuntimeException(var0.toString());
                    throw var4_5;
lbl244:
                    // 1 sources

                    var4_5[var5_6] = Token.createRange();
                    ++var5_6;
                    continue;
                    break;
                }
            }
        }
        var2_3 = var1_2 != false ? Token.categories : Token.categories2;
        return (RangeToken)var2_3.get(var0);
    }

    protected static RangeToken getRange(String string2, boolean bl, boolean bl2) {
        RangeToken rangeToken;
        RangeToken rangeToken2 = rangeToken = Token.getRange(string2, bl);
        if (bl2) {
            rangeToken2 = rangeToken;
            if (rangeToken != null) {
                rangeToken2 = rangeToken;
                if (Token.isRegisterNonXS(string2)) {
                    rangeToken2 = null;
                }
            }
        }
        return rangeToken2;
    }

    protected static boolean isRegisterNonXS(String string2) {
        Hashtable hashtable = nonxs;
        if (hashtable == null) {
            return false;
        }
        return hashtable.containsKey(string2);
    }

    private static final boolean isSet(int n, int n2) {
        boolean bl = (n & n2) == n2;
        return bl;
    }

    private final boolean isShorterThan(Token serializable) {
        boolean bl = false;
        if (serializable == null) {
            return false;
        }
        if (this.type == 10) {
            int n = this.getString().length();
            if (((Token)serializable).type == 10) {
                if (n < ((Token)serializable).getString().length()) {
                    bl = true;
                }
                return bl;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Internal Error: Illegal type: ");
            stringBuffer.append(((Token)serializable).type);
            throw new RuntimeException(stringBuffer.toString());
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("Internal Error: Illegal type: ");
        ((StringBuffer)serializable).append(this.type);
        throw new RuntimeException(((StringBuffer)serializable).toString());
    }

    protected static void registerNonXS(String string2) {
        if (nonxs == null) {
            nonxs = new Hashtable();
        }
        nonxs.put(string2, string2);
    }

    private static void setAlias(String string2, String object, boolean bl) {
        Hashtable hashtable = categories;
        Token token = (Token)hashtable.get(object);
        Hashtable hashtable2 = categories2;
        object = (Token)hashtable2.get(object);
        if (bl) {
            hashtable.put(string2, token);
            hashtable2.put(string2, object);
        } else {
            hashtable2.put(string2, token);
            hashtable.put(string2, object);
        }
    }

    void addChild(Token token) {
        throw new RuntimeException("Not supported.");
    }

    protected void addRange(int n, int n2) {
        throw new RuntimeException("Not supported.");
    }

    /*
     * Exception decompiling
     */
    final int analyzeFirstCharacter(RangeToken var1_1, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 14[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void compactRanges() {
        throw new RuntimeException("Not supported.");
    }

    /*
     * Exception decompiling
     */
    final void findFixedString(FixedStringContainer var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getChar() {
        return -1;
    }

    Token getChild(int n) {
        return null;
    }

    int getMax() {
        return -1;
    }

    /*
     * Exception decompiling
     */
    final int getMaxLength() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getMin() {
        return -1;
    }

    /*
     * Exception decompiling
     */
    final int getMinLength() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getParenNumber() {
        return 0;
    }

    int getReferenceNumber() {
        return 0;
    }

    String getString() {
        return null;
    }

    protected void intersectRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    boolean match(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NFAArrow#match(): Internal error: ");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    protected void mergeRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    void setMax(int n) {
    }

    void setMin(int n) {
    }

    int size() {
        return 0;
    }

    protected void sortRanges() {
        throw new RuntimeException("Not supported.");
    }

    protected void subtractRanges(Token token) {
        throw new RuntimeException("Not supported.");
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        String string2 = this.type == 11 ? "." : "";
        return string2;
    }

    static class CharToken
    extends Token
    implements Serializable {
        int chardata;

        CharToken(int n, int n2) {
            super(n);
            this.chardata = n2;
        }

        @Override
        int getChar() {
            return this.chardata;
        }

        @Override
        boolean match(int n) {
            if (this.type == 0) {
                boolean bl = n == this.chardata;
                return bl;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NFAArrow#match(): Internal error: ");
            stringBuffer.append(this.type);
            throw new RuntimeException(stringBuffer.toString());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String toString(int var1_1) {
            block7: {
                block10: {
                    block11: {
                        block12: {
                            block13: {
                                block14: {
                                    block4: {
                                        block9: {
                                            block5: {
                                                block8: {
                                                    block6: {
                                                        var1_1 = this.type;
                                                        if (var1_1 == 0) break block5;
                                                        if (var1_1 == 8) break block6;
                                                        var2_2 = null;
                                                        break block7;
                                                    }
                                                    if (this == Token.token_linebeginning || this == Token.token_lineend) break block8;
                                                    var2_2 = new StringBuffer();
                                                    break block9;
                                                }
                                                var2_2 = new StringBuffer();
lbl12:
                                                // 2 sources

                                                while (true) {
                                                    var2_2.append("");
                                                    break block4;
                                                    break;
                                                }
                                            }
                                            var1_1 = this.chardata;
                                            if (var1_1 == 9) break block10;
                                            if (var1_1 == 10) break block11;
                                            if (var1_1 == 12) break block12;
                                            if (var1_1 == 13) break block13;
                                            if (var1_1 == 27) break block14;
                                            if (var1_1 == 46 || var1_1 == 63 || var1_1 == 91 || var1_1 == 92 || var1_1 == 123 || var1_1 == 124) ** GOTO lbl-1000
                                            switch (var1_1) {
                                                default: {
                                                    if (var1_1 < 65536) ** GOTO lbl40
                                                    var2_2 = new StringBuffer();
                                                    var2_2.append("0");
                                                    var2_2.append(Integer.toHexString(this.chardata));
                                                    var3_3 = var2_2.toString();
                                                    var2_2 = new StringBuffer();
                                                    var2_2.append("\\v");
                                                    var2_2.append(var3_3.substring(var3_3.length() - 6, var3_3.length()));
                                                    var2_2 = var2_2.toString();
                                                    break block7;
lbl40:
                                                    // 1 sources

                                                    var2_2 = new StringBuffer();
                                                    ** continue;
                                                }
                                                case 40: 
                                                case 41: 
                                                case 42: 
                                                case 43: lbl-1000:
                                                // 2 sources

                                                {
                                                    var2_2 = new StringBuffer();
                                                }
                                            }
                                        }
                                        var2_2.append("\\");
                                    }
                                    var2_2.append((char)this.chardata);
                                    var2_2 = var2_2.toString();
                                    break block7;
                                }
                                var2_2 = "\\e";
                                break block7;
                            }
                            var2_2 = "\\r";
                            break block7;
                        }
                        var2_2 = "\\f";
                        break block7;
                    }
                    var2_2 = "\\n";
                    break block7;
                }
                var2_2 = "\\t";
            }
            return var2_2;
        }
    }

    static class ClosureToken
    extends Token
    implements Serializable {
        Token child;
        int max;
        int min;

        ClosureToken(int n, Token token) {
            super(n);
            this.child = token;
            this.setMin(-1);
            this.setMax(-1);
        }

        @Override
        Token getChild(int n) {
            return this.child;
        }

        @Override
        final int getMax() {
            return this.max;
        }

        @Override
        final int getMin() {
            return this.min;
        }

        @Override
        final void setMax(int n) {
            this.max = n;
        }

        @Override
        final void setMin(int n) {
            this.min = n;
        }

        @Override
        int size() {
            return 1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public String toString(int n) {
            CharSequence charSequence;
            block20: {
                String string2;
                block10: {
                    block19: {
                        void var6_14;
                        CharSequence charSequence2;
                        block18: {
                            block15: {
                                block17: {
                                    block14: {
                                        block16: {
                                            block11: {
                                                String string3;
                                                block13: {
                                                    block12: {
                                                        if (this.type != 3) break block11;
                                                        if (this.getMin() >= 0 || this.getMax() >= 0) break block12;
                                                        charSequence = new StringBuffer();
                                                        ((StringBuffer)charSequence).append(this.child.toString(n));
                                                        string2 = "*";
                                                        break block10;
                                                    }
                                                    int n2 = this.getMin();
                                                    int n3 = this.getMax();
                                                    string3 = "}";
                                                    if (n2 != n3) break block13;
                                                    charSequence = new StringBuffer();
                                                    charSequence2 = string3;
                                                    break block14;
                                                }
                                                if (this.getMin() >= 0 && this.getMax() >= 0) {
                                                    charSequence2 = new StringBuffer();
                                                    charSequence = string3;
                                                    break block15;
                                                } else if (this.getMin() >= 0 && this.getMax() < 0) {
                                                    charSequence = new StringBuffer();
                                                    ((StringBuffer)charSequence).append(this.child.toString(n));
                                                    ((StringBuffer)charSequence).append("{");
                                                    ((StringBuffer)charSequence).append(this.getMin());
                                                    string2 = ",}";
                                                    break block10;
                                                } else {
                                                    StringBuffer stringBuffer = new StringBuffer();
                                                    stringBuffer.append("Token#toString(): CLOSURE ");
                                                    stringBuffer.append(this.getMin());
                                                    stringBuffer.append(", ");
                                                    stringBuffer.append(this.getMax());
                                                    throw new RuntimeException(stringBuffer.toString());
                                                }
                                            }
                                            if (this.getMin() >= 0 || this.getMax() >= 0) break block16;
                                            charSequence = new StringBuffer();
                                            ((StringBuffer)charSequence).append(this.child.toString(n));
                                            string2 = "*?";
                                            break block10;
                                        }
                                        int n4 = this.getMin();
                                        int n5 = this.getMax();
                                        charSequence = "}?";
                                        if (n4 != n5) break block17;
                                        StringBuffer stringBuffer = new StringBuffer();
                                        charSequence2 = charSequence;
                                        charSequence = stringBuffer;
                                    }
                                    ((StringBuffer)charSequence).append(this.child.toString(n));
                                    ((StringBuffer)charSequence).append("{");
                                    n = this.getMin();
                                    CharSequence charSequence3 = charSequence2;
                                    charSequence2 = charSequence;
                                    break block18;
                                }
                                if (this.getMin() < 0 || this.getMax() < 0) break block19;
                                charSequence2 = new StringBuffer();
                            }
                            ((StringBuffer)charSequence2).append(this.child.toString(n));
                            ((StringBuffer)charSequence2).append("{");
                            ((StringBuffer)charSequence2).append(this.getMin());
                            ((StringBuffer)charSequence2).append(",");
                            n = this.getMax();
                            CharSequence charSequence4 = charSequence;
                        }
                        ((StringBuffer)charSequence2).append(n);
                        ((StringBuffer)charSequence2).append((String)var6_14);
                        charSequence = charSequence2;
                        return ((StringBuffer)charSequence).toString();
                    }
                    if (this.getMin() < 0 || this.getMax() >= 0) break block20;
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append(this.child.toString(n));
                    ((StringBuffer)charSequence).append("{");
                    ((StringBuffer)charSequence).append(this.getMin());
                    string2 = ",}?";
                }
                ((StringBuffer)charSequence).append(string2);
                return ((StringBuffer)charSequence).toString();
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("Token#toString(): NONGREEDYCLOSURE ");
            ((StringBuffer)charSequence).append(this.getMin());
            ((StringBuffer)charSequence).append(", ");
            ((StringBuffer)charSequence).append(this.getMax());
            throw new RuntimeException(((StringBuffer)charSequence).toString());
        }
    }

    static class ConcatToken
    extends Token
    implements Serializable {
        Token child;
        Token child2;

        ConcatToken(Token token, Token token2) {
            super(1);
            this.child = token;
            this.child2 = token2;
        }

        @Override
        Token getChild(int n) {
            Token token = n == 0 ? this.child : this.child2;
            return token;
        }

        @Override
        int size() {
            return 2;
        }

        @Override
        public String toString(int n) {
            String string2;
            StringBuffer stringBuffer;
            if (this.child2.type == 3 && this.child2.getChild(0) == this.child) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.child.toString(n));
                string2 = "+";
            } else if (this.child2.type == 9 && this.child2.getChild(0) == this.child) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.child.toString(n));
                string2 = "+?";
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.child.toString(n));
                string2 = this.child2.toString(n);
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }

    static class ConditionToken
    extends Token
    implements Serializable {
        Token condition;
        Token no;
        int refNumber;
        Token yes;

        ConditionToken(int n, Token token, Token token2, Token token3) {
            super(26);
            this.refNumber = n;
            this.condition = token;
            this.yes = token2;
            this.no = token3;
        }

        @Override
        Token getChild(int n) {
            if (n == 0) {
                return this.yes;
            }
            if (n == 1) {
                return this.no;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Internal Error: ");
            stringBuffer.append(n);
            throw new RuntimeException(stringBuffer.toString());
        }

        @Override
        int size() {
            int n = this.no == null ? 1 : 2;
            return n;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String toString(int var1_1) {
            if (this.refNumber > 0) {
                var2_2 = new StringBuffer();
                var2_2.append("(?(");
                var2_2.append(this.refNumber);
lbl7:
                // 2 sources

                while (true) {
                    var2_2.append(")");
lbl10:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                    break;
                }
            }
            if (this.condition.type == 8) {
                var2_2 = new StringBuffer();
                var2_2.append("(?(");
                var2_2.append(this.condition);
                ** continue;
            }
            var2_2 = new StringBuffer();
            var2_2.append("(?");
            var2_2.append(this.condition);
            ** while (true)
            var2_2 = var2_2.toString();
            if (this.no == null) {
                var3_3 = new StringBuffer();
                var3_3.append((String)var2_2);
                var2_2 = this.yes;
            } else {
                var3_3 = new StringBuffer();
                var3_3.append((String)var2_2);
                var3_3.append(this.yes);
                var3_3.append("|");
                var2_2 = this.no;
            }
            var3_3.append(var2_2);
            var3_3.append(")");
            return var3_3.toString();
        }
    }

    static class FixedStringContainer {
        int options = 0;
        Token token = null;

        FixedStringContainer() {
        }
    }

    static class ModifierToken
    extends Token
    implements Serializable {
        int add;
        Token child;
        int mask;

        ModifierToken(Token token, int n, int n2) {
            super(25);
            this.child = token;
            this.add = n;
            this.mask = n2;
        }

        @Override
        Token getChild(int n) {
            return this.child;
        }

        int getOptions() {
            return this.add;
        }

        int getOptionsMask() {
            return this.mask;
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        public String toString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(?");
            int n2 = this.add;
            String string2 = "";
            String string3 = n2 == 0 ? "" : REUtil.createOptionString(n2);
            stringBuffer.append(string3);
            n2 = this.mask;
            string3 = n2 == 0 ? string2 : REUtil.createOptionString(n2);
            stringBuffer.append(string3);
            stringBuffer.append(":");
            stringBuffer.append(this.child.toString(n));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    static class ParenToken
    extends Token
    implements Serializable {
        Token child;
        int parennumber;

        ParenToken(int n, Token token, int n2) {
            super(n);
            this.child = token;
            this.parennumber = n2;
        }

        @Override
        Token getChild(int n) {
            return this.child;
        }

        @Override
        int getParenNumber() {
            return this.parennumber;
        }

        @Override
        int size() {
            return 1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public String toString(int var1_1) {
            block8: {
                block10: {
                    block9: {
                        var2_2 = this.type;
                        if (var2_2 == 6) break block9;
                        switch (var2_2) {
                            default: {
                                var3_3 /* !! */  = null;
                                break block8;
                            }
                            case 24: {
                                var3_3 /* !! */  = new StringBuffer();
                                var4_4 = "(?>";
                                break;
                            }
                            case 23: {
                                var3_3 /* !! */  = new StringBuffer();
                                var4_4 = "(?<!";
                                break;
                            }
                            case 22: {
                                var3_3 /* !! */  = new StringBuffer();
                                var4_4 = "(?<=";
                                break;
                            }
                            case 21: {
                                var3_3 /* !! */  = new StringBuffer();
                                var4_4 = "(?!";
                                break;
                            }
                            case 20: {
                                var3_3 /* !! */  = new StringBuffer();
                                var4_4 = "(?=";
                            }
                        }
lbl26:
                        // 7 sources

                        while (true) {
                            var3_3 /* !! */ .append(var4_4);
                            var3_3 /* !! */ .append(this.child.toString(var1_1));
                            var3_3 /* !! */ .append(")");
                            var3_3 /* !! */  = var3_3 /* !! */ .toString();
                            break block8;
                            break;
                        }
                    }
                    if (this.parennumber != 0) break block10;
                    var3_3 /* !! */  = new StringBuffer();
                    var4_4 = "(?:";
                    ** GOTO lbl26
                }
                var3_3 /* !! */  = new StringBuffer();
                var4_4 = "(";
                ** while (true)
            }
            return var3_3 /* !! */ ;
        }
    }

    static class StringToken
    extends Token
    implements Serializable {
        int refNumber;
        String string;

        StringToken(int n, String string2, int n2) {
            super(n);
            this.string = string2;
            this.refNumber = n2;
        }

        @Override
        int getReferenceNumber() {
            return this.refNumber;
        }

        @Override
        String getString() {
            return this.string;
        }

        @Override
        public String toString(int n) {
            if (this.type == 12) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\\");
                stringBuffer.append(this.refNumber);
                return stringBuffer.toString();
            }
            return REUtil.quoteMeta(this.string);
        }
    }

    static class UnionToken
    extends Token
    implements Serializable {
        Vector children;

        UnionToken(int n) {
            super(n);
        }

        @Override
        void addChild(Token object) {
            Serializable serializable;
            block15: {
                block14: {
                    block12: {
                        int n;
                        block13: {
                            if (object == null) {
                                return;
                            }
                            if (this.children == null) {
                                this.children = new Vector();
                            }
                            if (this.type == 2) {
                                this.children.addElement(object);
                                return;
                            }
                            if (((Token)object).type == 1) {
                                int n2 = 0;
                                while (true) {
                                    if (n2 >= ((Token)object).size()) {
                                        return;
                                    }
                                    this.addChild(((Token)object).getChild(n2));
                                    ++n2;
                                }
                            }
                            n = this.children.size();
                            if (n == 0) {
                                this.children.addElement(object);
                                return;
                            }
                            serializable = this.children;
                            int n3 = n - 1;
                            Token token = (Token)((Vector)serializable).elementAt(n3);
                            if (token.type != 0 && token.type != 10 || ((Token)object).type != 0 && ((Token)object).type != 10) {
                                this.children.addElement(object);
                                return;
                            }
                            n = ((Token)object).type == 0 ? 2 : ((Token)object).getString().length();
                            if (token.type == 0) {
                                serializable = new StringBuffer(n + 2);
                                n = token.getChar();
                                if (n >= 65536) {
                                    ((StringBuffer)serializable).append(REUtil.decomposeToSurrogates(n));
                                } else {
                                    ((StringBuffer)serializable).append((char)n);
                                }
                                token = Token.createString(null);
                                this.children.setElementAt(token, n3);
                            } else {
                                serializable = new StringBuffer(token.getString().length() + n);
                                ((StringBuffer)serializable).append(token.getString());
                            }
                            if (((Token)object).type != 0) break block12;
                            n = ((Token)object).getChar();
                            if (n < 65536) break block13;
                            object = REUtil.decomposeToSurrogates(n);
                            break block14;
                        }
                        ((StringBuffer)serializable).append((char)n);
                        break block15;
                    }
                    object = ((Token)object).getString();
                }
                ((StringBuffer)serializable).append((String)object);
            }
            ((StringToken)token).string = new String((StringBuffer)serializable);
        }

        @Override
        Token getChild(int n) {
            return (Token)this.children.elementAt(n);
        }

        @Override
        int size() {
            Vector vector = this.children;
            int n = vector == null ? 0 : vector.size();
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString(int n) {
            CharSequence charSequence;
            int n2;
            block17: {
                Object object;
                int n3;
                block11: {
                    String string2;
                    block16: {
                        block15: {
                            block10: {
                                Object object2;
                                block14: {
                                    block13: {
                                        block12: {
                                            int n4 = this.type;
                                            n3 = 0;
                                            n2 = 1;
                                            if (n4 != 1) break block10;
                                            if (this.children.size() != 2) break block11;
                                            object2 = this.getChild(0);
                                            object = this.getChild(1);
                                            if (((Token)object).type != 3 || ((Token)object).getChild(0) != object2) break block12;
                                            object = new StringBuffer();
                                            ((StringBuffer)object).append(((Token)object2).toString(n));
                                            object2 = "+";
                                            break block13;
                                        }
                                        if (((Token)object).type != 9 || ((Token)object).getChild(0) != object2) break block14;
                                        object = new StringBuffer();
                                        ((StringBuffer)object).append(((Token)object2).toString(n));
                                        object2 = "+?";
                                    }
                                    ((StringBuffer)object).append((String)object2);
                                    return ((StringBuffer)object).toString();
                                }
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(((Token)object2).toString(n));
                                stringBuffer.append(((Token)object).toString(n));
                                return stringBuffer.toString();
                            }
                            if (this.children.size() != 2 || this.getChild((int)1).type != 7) break block15;
                            charSequence = new StringBuffer();
                            ((StringBuffer)charSequence).append(this.getChild(0).toString(n));
                            string2 = "?";
                            break block16;
                        }
                        if (this.children.size() != 2 || this.getChild((int)0).type != 7) break block17;
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append(this.getChild(1).toString(n));
                        string2 = "??";
                    }
                    ((StringBuffer)charSequence).append(string2);
                    return ((StringBuffer)charSequence).toString();
                }
                object = new StringBuffer();
                n2 = n3;
                while (true) {
                    if (n2 >= this.children.size()) {
                        return new String((StringBuffer)object);
                    }
                    ((StringBuffer)object).append(((Token)this.children.elementAt(n2)).toString(n));
                    ++n2;
                }
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(((Token)this.children.elementAt(0)).toString(n));
            while (n2 < this.children.size()) {
                ((StringBuffer)charSequence).append('|');
                ((StringBuffer)charSequence).append(((Token)this.children.elementAt(n2)).toString(n));
                ++n2;
            }
            return new String((StringBuffer)charSequence);
        }
    }
}

