/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.InputSource;

public class XMLSchemaLoader
implements XMLGrammarLoader {
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/standard-uri-conformant"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource"};
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$InputSource;
    private boolean fAllowJavaEncodings = false;
    private CMBuilder fCMBuilder;
    private XSDeclarationPool fDeclPool = null;
    private XMLEntityResolver fEntityResolver = null;
    private XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    private String fExternalNoNSSchema = null;
    private String fExternalSchemas = null;
    private XSGrammarBucket fGrammarBucket;
    private XMLGrammarPool fGrammarPool = null;
    private boolean fIsCheckedFully = false;
    private Hashtable fJAXPCache;
    private boolean fJAXPProcessed = false;
    private Object fJAXPSource = null;
    private Locale fLocale = Locale.getDefault();
    private XSDHandler fSchemaHandler;
    private boolean fStrictURI = false;
    private SubstitutionGroupHandler fSubGroupHandler;
    private SymbolTable fSymbolTable = null;
    private XSDDescription fXSDDescription = new XSDDescription();
    private boolean useDeclPool = false;

    public XMLSchemaLoader() {
        this(new SymbolTable(), null, new XMLEntityManager(), null, null, null);
    }

    XMLSchemaLoader(XMLErrorReporter xMLErrorReporter, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder) {
        this(null, xMLErrorReporter, null, xSGrammarBucket, substitutionGroupHandler, cMBuilder);
    }

    public XMLSchemaLoader(SymbolTable symbolTable) {
        this(symbolTable, null, new XMLEntityManager(), null, null, null);
    }

    XMLSchemaLoader(SymbolTable object, XMLErrorReporter object2, XMLEntityResolver xMLEntityResolver, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder) {
        this.fSymbolTable = object;
        object = object2;
        if (object2 == null) {
            object = new XMLErrorReporter();
            ((XMLErrorReporter)object).setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = object;
        this.fEntityResolver = xMLEntityResolver;
        object = xSGrammarBucket;
        if (xSGrammarBucket == null) {
            object = new XSGrammarBucket();
        }
        this.fGrammarBucket = object;
        object = substitutionGroupHandler;
        if (substitutionGroupHandler == null) {
            object = new SubstitutionGroupHandler(this.fGrammarBucket);
        }
        this.fSubGroupHandler = object;
        object2 = new CMNodeFactory();
        object = cMBuilder;
        if (cMBuilder == null) {
            object = new CMBuilder((CMNodeFactory)object2);
        }
        this.fCMBuilder = object;
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
        this.fDeclPool = new XSDeclarationPool();
        this.fJAXPCache = new Hashtable();
    }

    static /* synthetic */ Class class$(String object) {
        try {
            object = Class.forName((String)object);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processExternalHints(String object, String string2, Hashtable hashtable, XMLErrorReporter xMLErrorReporter) {
        if (object != null) {
            try {
                SchemaGrammar.SG_XSI.getGlobalAttributeDecl((String)SchemaSymbols.XSI_SCHEMALOCATION).fType.validate((String)object, null, null);
                if (!XMLSchemaLoader.tokenizeSchemaLocationStr((String)object, hashtable)) {
                    xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{object}, (short)0);
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), (short)0);
            }
        }
        if (string2 == null) return;
        try {
            SchemaGrammar.SG_XSI.getGlobalAttributeDecl((String)SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION).fType.validate(string2, null, null);
            LocationArray locationArray = (LocationArray)hashtable.get(XMLSymbols.EMPTY_STRING);
            object = locationArray;
            if (locationArray == null) {
                object = new LocationArray();
                hashtable.put(XMLSymbols.EMPTY_STRING, object);
            }
            ((LocationArray)object).addLocation(string2);
            return;
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), (short)0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processJAXPSchemaSource(Hashtable object) throws IOException {
        Object object2;
        this.fJAXPProcessed = true;
        Object object3 = this.fJAXPSource;
        if (object3 == null) {
            return;
        }
        Object[] objectArray = object3.getClass().getComponentType();
        if (objectArray == null) {
            object3 = this.fJAXPSource;
            if ((object3 instanceof InputStream || object3 instanceof InputSource) && (object3 = (SchemaGrammar)this.fJAXPCache.get(object3)) != null) {
                this.fGrammarBucket.putGrammar((SchemaGrammar)object3);
                return;
            }
            this.fXSDDescription.reset();
            XMLInputSource xMLInputSource = this.xsdToXMLInputSource(this.fJAXPSource);
            object3 = xMLInputSource.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (object3 != null) {
                this.fXSDDescription.setLiteralSystemId((String)object3);
                this.fXSDDescription.setExpandedSystemId((String)object3);
                this.fXSDDescription.fLocationHints = new String[]{object3};
            }
            object = this.loadSchema(this.fXSDDescription, xMLInputSource, (Hashtable)object);
            object3 = this.fJAXPSource;
            if (object3 instanceof InputStream || object3 instanceof InputSource) {
                this.fJAXPCache.put(object3, object);
            }
            this.fGrammarBucket.putGrammar((SchemaGrammar)object);
            return;
        }
        object3 = object2 = class$java$lang$Object;
        if (object2 == null) {
            class$java$lang$Object = object3 = XMLSchemaLoader.class$("java.lang.Object");
        }
        if (objectArray != object3) {
            object3 = object2 = class$java$lang$String;
            if (object2 == null) {
                class$java$lang$String = object3 = XMLSchemaLoader.class$("java.lang.String");
            }
            if (objectArray != object3) {
                object3 = object2 = class$java$io$File;
                if (object2 == null) {
                    class$java$io$File = object3 = XMLSchemaLoader.class$("java.io.File");
                }
                if (objectArray != object3) {
                    object3 = object2 = class$java$io$InputStream;
                    if (object2 == null) {
                        class$java$io$InputStream = object3 = XMLSchemaLoader.class$("java.io.InputStream");
                    }
                    if (objectArray != object3) {
                        object3 = object2 = class$org$xml$sax$InputSource;
                        if (object2 == null) {
                            class$org$xml$sax$InputSource = object3 = XMLSchemaLoader.class$("org.xml.sax.InputSource");
                        }
                        if (objectArray != object3) {
                            object = new StringBuffer();
                            ((StringBuffer)object).append("\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have an array of type {");
                            ((StringBuffer)object).append(objectArray.getName());
                            ((StringBuffer)object).append("}. Possible types of the array supported are Object, String, File, ");
                            ((StringBuffer)object).append("InputStream, InputSource.");
                            throw new XMLConfigurationException(1, ((StringBuffer)object).toString());
                        }
                    }
                }
            }
        }
        objectArray = (Object[])this.fJAXPSource;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (true) {
            block23: {
                block22: {
                    block24: {
                        if (n >= objectArray.length) {
                            return;
                        }
                        if ((objectArray[n] instanceof InputStream || objectArray[n] instanceof InputSource) && (object3 = (SchemaGrammar)this.fJAXPCache.get(objectArray[n])) != null) break block22;
                        this.fXSDDescription.reset();
                        object2 = this.xsdToXMLInputSource(objectArray[n]);
                        object3 = ((XMLInputSource)object2).getSystemId();
                        this.fXSDDescription.fContextType = (short)3;
                        if (object3 != null) {
                            this.fXSDDescription.setLiteralSystemId((String)object3);
                            this.fXSDDescription.setExpandedSystemId((String)object3);
                            this.fXSDDescription.fLocationHints = new String[]{object3};
                        }
                        if ((object2 = this.loadSchema(this.fXSDDescription, (XMLInputSource)object2, (Hashtable)object)) == null) break block23;
                        object3 = ((SchemaGrammar)object2).getTargetNamespace();
                        if (vector.contains(object3)) {
                            throw new IllegalArgumentException(" When using array of Objects as the value of SCHEMA_SOURCE property , no two Schemas should share the same targetNamespace. ");
                        }
                        vector.add(object3);
                        if (objectArray[n] instanceof InputStream) break block24;
                        object3 = object2;
                        if (!(objectArray[n] instanceof InputSource)) break block22;
                    }
                    this.fJAXPCache.put(objectArray[n], object2);
                    object3 = object2;
                }
                this.fGrammarBucket.putGrammar((SchemaGrammar)object3);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static XMLInputSource resolveDocument(XSDDescription var0, Hashtable var1_1, XMLEntityResolver var2_2) throws IOException {
        if (var0.getContextType() != 2 && !var0.fromInstance()) ** GOTO lbl-1000
        var3_3 = var0.getTargetNamespace();
        var4_4 = var3_3;
        if (var3_3 == null) {
            var4_4 = XMLSymbols.EMPTY_STRING;
        }
        if ((var1_1 = (LocationArray)var1_1.get(var4_4)) != null) {
            var1_1 = var1_1.getFirstLocation();
        } else lbl-1000:
        // 2 sources

        {
            var1_1 = null;
        }
        var4_4 = var1_1;
        if (var1_1 == null) {
            var3_3 = var0.getLocationHints();
            var4_4 = var1_1;
            if (var3_3 != null) {
                var4_4 = var1_1;
                if (var3_3.length > 0) {
                    var4_4 = var3_3[0];
                }
            }
        }
        var1_1 = XMLEntityManager.expandSystemId((String)var4_4, var0.getBaseSystemId(), false);
        var0.setLiteralSystemId((String)var4_4);
        var0.setExpandedSystemId((String)var1_1);
        return var2_2.resolveEntity(var0);
    }

    private static XMLInputSource saxToXMLInputSource(InputSource inputSource) {
        String string2 = inputSource.getPublicId();
        String string3 = inputSource.getSystemId();
        Closeable closeable = inputSource.getCharacterStream();
        if (closeable != null) {
            return new XMLInputSource(string2, string3, null, (Reader)closeable, null);
        }
        closeable = inputSource.getByteStream();
        if (closeable != null) {
            return new XMLInputSource(string2, string3, null, (InputStream)closeable, inputSource.getEncoding());
        }
        return new XMLInputSource(string2, string3, null);
    }

    public static boolean tokenizeSchemaLocationStr(String object, Hashtable hashtable) {
        if (object != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \n\t\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    return false;
                }
                String string3 = stringTokenizer.nextToken();
                LocationArray locationArray = (LocationArray)hashtable.get(string2);
                object = locationArray;
                if (locationArray == null) {
                    object = new LocationArray();
                    hashtable.put(string2, object);
                }
                ((LocationArray)object).addLocation(string3);
            }
        }
        return true;
    }

    private XMLInputSource xsdToXMLInputSource(Object object) {
        if (object instanceof String) {
            String string2 = (String)object;
            if (this.fEntityResolver != null) {
                this.fXSDDescription.reset();
                this.fXSDDescription.setValues(null, string2, null, null);
                try {
                    object = this.fEntityResolver.resolveEntity(this.fXSDDescription);
                }
                catch (IOException iOException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{string2}, (short)1);
                    object = null;
                }
                Object object2 = object;
                if (object == null) {
                    object2 = new XMLInputSource(null, string2, null);
                }
                return object2;
            }
        } else {
            if (object instanceof InputSource) {
                return XMLSchemaLoader.saxToXMLInputSource((InputSource)object);
            }
            if (object instanceof InputStream) {
                return new XMLInputSource(null, null, null, (InputStream)object, null);
            }
            if (object instanceof File) {
                File file = (File)object;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    object = new BufferedInputStream(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{file.toString()}, (short)1);
                    object = null;
                }
                return new XMLInputSource(null, null, null, (InputStream)object, null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have a value of type {");
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append("}. Possible types of the value supported are String, File, InputStream, ");
        stringBuffer.append("InputSource OR an array of these types.");
        throw new XMLConfigurationException(1, stringBuffer.toString());
    }

    @Override
    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    @Override
    public boolean getFeature(String string2) throws XMLConfigurationException {
        if (string2.equals(SCHEMA_FULL_CHECKING)) {
            return this.fIsCheckedFully;
        }
        if (string2.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            return this.fErrorReporter.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public Object getProperty(String string2) throws XMLConfigurationException {
        if (string2.equals(SYMBOL_TABLE)) {
            return this.fSymbolTable;
        }
        if (string2.equals(ERROR_REPORTER)) {
            return this.fErrorReporter;
        }
        if (string2.equals(ERROR_HANDLER)) {
            return this.fErrorReporter.getErrorHandler();
        }
        if (string2.equals(ENTITY_RESOLVER)) {
            return this.fEntityResolver;
        }
        if (string2.equals(XMLGRAMMAR_POOL)) {
            return this.fGrammarPool;
        }
        if (string2.equals(SCHEMA_LOCATION)) {
            return this.fExternalSchemas;
        }
        if (string2.equals(SCHEMA_NONS_LOCATION)) {
            return this.fExternalNoNSSchema;
        }
        if (string2.equals(JAXP_SCHEMA_SOURCE)) {
            return this.fJAXPSource;
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    @Override
    public Grammar loadGrammar(XMLInputSource object) throws IOException, XNIException {
        this.reset();
        Object object2 = new XSDDescription();
        ((XSDDescription)object2).fContextType = (short)3;
        ((XMLResourceIdentifierImpl)object2).setBaseSystemId(((XMLInputSource)object).getBaseSystemId());
        ((XMLResourceIdentifierImpl)object2).setLiteralSystemId(((XMLInputSource)object).getSystemId());
        Hashtable hashtable = new Hashtable();
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNSSchema, hashtable, this.fErrorReporter);
        object2 = this.loadSchema((XSDDescription)object2, (XMLInputSource)object, hashtable);
        if (object2 != null && (object = this.fGrammarPool) != null) {
            object.cacheGrammars("http://www.w3.org/2001/XMLSchema", this.fGrammarBucket.getGrammars());
        }
        return object2;
    }

    SchemaGrammar loadSchema(XSDDescription object, XMLInputSource xMLInputSource, Hashtable hashtable) throws IOException, XNIException {
        if (!this.fJAXPProcessed) {
            this.processJAXPSchemaSource(hashtable);
        }
        object = this.fSchemaHandler.parseSchema(xMLInputSource, (XSDDescription)object, hashtable);
        if (this.fIsCheckedFully) {
            XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        return object;
    }

    public void reset() {
        Grammar[] grammarArray;
        this.fGrammarBucket.reset();
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        if ((grammarArray = this.fGrammarPool) != null) {
            grammarArray = grammarArray.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            for (int i = 0; i < grammarArray.length; ++i) {
                if (this.fGrammarBucket.putGrammar((SchemaGrammar)grammarArray[i], true)) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
            }
        }
        if (this.useDeclPool) {
            this.fDeclPool.reset();
            this.fCMBuilder.setDeclPool(this.fDeclPool);
            this.fSchemaHandler.setDeclPool(this.fDeclPool);
        } else {
            this.fCMBuilder.setDeclPool(null);
            this.fSchemaHandler.setDeclPool(null);
        }
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fGrammarPool, this.fAllowJavaEncodings, this.fStrictURI);
        this.fSubGroupHandler.reset();
        this.fJAXPProcessed = false;
    }

    @Override
    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    @Override
    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!string2.equals(SCHEMA_FULL_CHECKING)) break block2;
                            this.fIsCheckedFully = bl;
                            break block3;
                        }
                        if (!string2.equals(CONTINUE_AFTER_FATAL_ERROR)) break block4;
                        this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
                        break block3;
                    }
                    if (!string2.equals(ALLOW_JAVA_ENCODINGS)) break block5;
                    this.fAllowJavaEncodings = bl;
                    break block3;
                }
                if (!string2.equals(STANDARD_URI_CONFORMANT_FEATURE)) break block6;
                this.fStrictURI = bl;
            }
            return;
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException, ClassCastException {
        block10: {
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (!string2.equals(SYMBOL_TABLE)) break block2;
                                            this.fSymbolTable = (SymbolTable)object;
                                            break block3;
                                        }
                                        if (!string2.equals(ERROR_REPORTER)) break block4;
                                        this.fErrorReporter = (XMLErrorReporter)object;
                                        break block3;
                                    }
                                    if (!string2.equals(ERROR_HANDLER)) break block5;
                                    this.fErrorReporter.setProperty(string2, object);
                                    break block3;
                                }
                                if (!string2.equals(ENTITY_RESOLVER)) break block6;
                                this.fEntityResolver = (XMLEntityResolver)object;
                                break block3;
                            }
                            if (!string2.equals(XMLGRAMMAR_POOL)) break block7;
                            this.fGrammarPool = (XMLGrammarPool)object;
                            break block3;
                        }
                        if (!string2.equals(SCHEMA_LOCATION)) break block8;
                        this.fExternalSchemas = (String)object;
                        break block3;
                    }
                    if (!string2.equals(SCHEMA_NONS_LOCATION)) break block9;
                    this.fExternalNoNSSchema = (String)object;
                    break block3;
                }
                if (!string2.equals(JAXP_SCHEMA_SOURCE)) break block10;
                this.fJAXPSource = object;
                this.fJAXPProcessed = false;
            }
            return;
        }
        throw new XMLConfigurationException(0, string2);
    }

    public void setUseDeclPool(boolean bl) {
        this.useDeclPool = bl;
    }

    static class LocationArray {
        int length;
        String[] locations = new String[2];

        LocationArray() {
        }

        public void addLocation(String string2) {
            int n = this.length;
            if (n >= this.locations.length) {
                this.resize(n, Math.max(1, n * 2));
            }
            String[] stringArray = this.locations;
            n = this.length;
            this.length = n + 1;
            stringArray[n] = string2;
        }

        public String getFirstLocation() {
            String string2 = this.length > 0 ? this.locations[0] : null;
            return string2;
        }

        public int getLength() {
            return this.length;
        }

        public String[] getLocationArray() {
            int n = this.length;
            String[] stringArray = this.locations;
            if (n < stringArray.length) {
                this.resize(stringArray.length, n);
            }
            return this.locations;
        }

        public void resize(int n, int n2) {
            String[] stringArray = new String[n2];
            System.arraycopy(this.locations, 0, stringArray, 0, Math.min(n, n2));
            this.locations = stringArray;
            this.length = Math.min(n, n2);
        }
    }
}

