/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.SymbolHash;

public class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object ElementDefaultValidImmediate(XSTypeDefinition object, String string2, ValidationContext validationContext, ValidatedInfo validatedInfo) {
        if (object.getTypeCategory() == 14) {
            object = (XSSimpleType)object;
        } else {
            object = (XSComplexTypeDecl)object;
            if (((XSComplexTypeDecl)object).fContentType == 1) {
                object = ((XSComplexTypeDecl)object).fXSSimpleType;
            } else {
                if (((XSComplexTypeDecl)object).fContentType != 3) return null;
                if (!((XSParticleDecl)((XSComplexTypeDecl)object).getParticle()).emptiable()) {
                    return null;
                }
                object = null;
            }
        }
        Object object2 = object;
        if (object == null) {
            object2 = STRING_TYPE;
        }
        try {
            object = object2.validate(string2, validationContext, validatedInfo);
            if (validatedInfo == null) return object;
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
        return object2.validate(validatedInfo.stringValue(), validationContext, validatedInfo);
    }

    private static void addElementToParticleVector(Vector vector, XSElementDecl xSElementDecl) {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fValue = xSElementDecl;
        xSParticleDecl.fType = (short)1;
        vector.addElement(xSParticleDecl);
    }

    private static boolean checkComplexDerivation(XSComplexTypeDecl xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s) {
        if (xSTypeDefinition == xSTypeDefinition2) {
            return true;
        }
        if ((xSTypeDefinition.fDerivedBy & s) != 0) {
            return false;
        }
        XSTypeDefinition xSTypeDefinition3 = xSTypeDefinition.fBaseType;
        if (xSTypeDefinition3 == xSTypeDefinition2) {
            return true;
        }
        if (xSTypeDefinition3 != SchemaGrammar.fAnyType && xSTypeDefinition3 != SchemaGrammar.fAnySimpleType) {
            if (xSTypeDefinition3.getTypeCategory() == 13) {
                return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition3, xSTypeDefinition2, s);
            }
            if (xSTypeDefinition3.getTypeCategory() == 14) {
                xSTypeDefinition = xSTypeDefinition2;
                if (xSTypeDefinition2.getTypeCategory() == 13) {
                    if (xSTypeDefinition2 == SchemaGrammar.fAnyType) {
                        xSTypeDefinition = SchemaGrammar.fAnySimpleType;
                    } else {
                        return false;
                    }
                }
                return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDefinition3, (XSSimpleType)xSTypeDefinition, s);
            }
        }
        return false;
    }

    public static boolean checkComplexDerivationOk(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDefinition xSTypeDefinition, short s) {
        if (xSComplexTypeDecl == SchemaGrammar.fAnyType) {
            boolean bl = xSComplexTypeDecl == xSTypeDefinition;
            return bl;
        }
        return XSConstraints.checkComplexDerivation(xSComplexTypeDecl, xSTypeDefinition, s);
    }

    public static void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSElementDeclArray, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        short s = xSElementDeclArray.fType;
        if (s != 0 && s != 2) {
            int n;
            int n2 = 0;
            xSElementDeclArray = xSElementDeclArray.fValue;
            if (s == 1) {
                xSElementDeclArray = (XSElementDecl)xSElementDeclArray;
                XSConstraints.findElemInTable(xSComplexTypeDecl, (XSElementDecl)xSElementDeclArray, symbolHash);
                if (xSElementDeclArray.fScope == 1) {
                    xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSElementDeclArray);
                    for (n = 0; n < xSElementDeclArray.length; ++n) {
                        XSConstraints.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[n], symbolHash);
                    }
                }
                return;
            }
            xSElementDeclArray = (XSModelGroupImpl)xSElementDeclArray;
            n = n2;
            while (true) {
                if (n >= xSElementDeclArray.fParticleCount) {
                    return;
                }
                XSConstraints.checkElementDeclsConsistent(xSComplexTypeDecl, xSElementDeclArray.fParticles[n], symbolHash, substitutionGroupHandler);
                ++n;
            }
        }
    }

    private static void checkIDConstraintRestriction(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) throws XMLSchemaException {
    }

    private static void checkMapAndSum(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            n4 = vector.size();
            n3 = vector2.size();
            n = 0;
            block2: while (true) {
                if (n >= n4) {
                    return;
                }
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n);
                for (n2 = 0; n2 < n3; ++n2) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n2);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        ++n;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        continue;
                    }
                    continue block2;
                }
                break;
            }
            throw new XMLSchemaException("rcase-MapAndSum.1", null);
        }
        throw new XMLSchemaException("rcase-MapAndSum.2", null);
    }

    private static void checkNSCompat(XSElementDecl xSElementDecl, int n, int n2, XSWildcardDecl xSWildcardDecl, int n3, int n4, boolean bl) throws XMLSchemaException {
        if (bl && !XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{xSElementDecl.fName});
        }
        if (xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            return;
        }
        throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace});
    }

    private static void checkNSRecurseCheckCardinality(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl, int n3, int n4, boolean bl) throws XMLSchemaException {
        if (bl && !XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", null);
        }
        n2 = vector.size();
        n = 0;
        while (n < n2) {
            try {
                XSConstraints.particleValidRestriction((XSParticleDecl)vector.elementAt(n), substitutionGroupHandler, xSParticleDecl, null, false);
                ++n;
            }
            catch (XMLSchemaException xMLSchemaException) {
                throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
            }
        }
        return;
    }

    private static void checkNSSubset(XSWildcardDecl xSWildcardDecl, int n, int n2, XSWildcardDecl xSWildcardDecl2, int n3, int n4) throws XMLSchemaException {
        if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            if (xSWildcardDecl.isSubsetOf(xSWildcardDecl2)) {
                if (!xSWildcardDecl.weakerProcessContents(xSWildcardDecl2)) {
                    return;
                }
                throw new XMLSchemaException("rcase-NSSubset.3", null);
            }
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
        throw new XMLSchemaException("rcase-NSSubset.2", null);
    }

    private static void checkNameAndTypeOK(XSElementDecl xSElementDecl, int n, int n2, XSElementDecl xSElementDecl2, int n3, int n4) throws XMLSchemaException {
        if (xSElementDecl.fName == xSElementDecl2.fName && xSElementDecl.fTargetNamespace == xSElementDecl2.fTargetNamespace) {
            if (!xSElementDecl2.getNillable() && xSElementDecl.getNillable()) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{xSElementDecl.fName});
            }
            if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
                if (xSElementDecl2.getConstraintType() == 2) {
                    if (xSElementDecl.getConstraintType() == 2) {
                        n = xSElementDecl.fType.getTypeCategory() != 14 && ((XSComplexTypeDecl)xSElementDecl.fType).fContentType != 1 ? 0 : 1;
                        if (n == 0 && !xSElementDecl2.fDefault.normalizedValue.equals(xSElementDecl.fDefault.normalizedValue) || n != 0 && !xSElementDecl2.fDefault.actualValue.equals(xSElementDecl.fDefault.actualValue)) {
                            throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
                        }
                    } else {
                        throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{xSElementDecl.fName});
                    }
                }
                XSConstraints.checkIDConstraintRestriction(xSElementDecl, xSElementDecl2);
                n2 = xSElementDecl.fBlock;
                n = xSElementDecl2.fBlock;
                if ((n2 & n) == n && (n2 != 0 || n == 0)) {
                    if (XSConstraints.checkTypeDerivationOk(xSElementDecl.fType, xSElementDecl2.fType, (short)25)) {
                        return;
                    }
                    throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{xSElementDecl.fName});
                }
                throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{xSElementDecl.fName});
            }
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{xSElementDecl.fName});
        }
        throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace, xSElementDecl2.fName, xSElementDecl2.fTargetNamespace});
    }

    private static boolean checkOccurrenceRange(int n, int n2, int n3, int n4) {
        return n >= n3 && (n4 == -1 || n2 != -1 && n2 <= n4);
    }

    private static void checkRecurse(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            int n5 = vector.size();
            int n6 = vector2.size();
            n2 = 0;
            n = 0;
            block2: while (true) {
                if (n2 >= n5) {
                    while (true) {
                        if (n >= n6) {
                            return;
                        }
                        if (!((XSParticleDecl)vector2.elementAt(n)).emptiable()) break;
                        ++n;
                    }
                    throw new XMLSchemaException("rcase-Recurse.2", null);
                }
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n2);
                n3 = n;
                for (n4 = n; n4 < n6; ++n4) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n4);
                    n = n3 + 1;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        ++n2;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        if (xSParticleDecl2.emptiable()) {
                            n3 = n;
                            continue;
                        }
                        throw new XMLSchemaException("rcase-Recurse.2", null);
                    }
                    continue block2;
                }
                break;
            }
            throw new XMLSchemaException("rcase-Recurse.2", null);
        }
        throw new XMLSchemaException("rcase-Recurse.1", null);
    }

    private static void checkRecurseLax(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            int n5 = vector.size();
            int n6 = vector2.size();
            n2 = 0;
            n = 0;
            block2: while (true) {
                if (n2 >= n5) {
                    return;
                }
                XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(n2);
                n3 = n;
                for (n4 = n; n4 < n6; ++n4) {
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(n4);
                    n = n3 + 1;
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                        ++n2;
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        n3 = n;
                        continue;
                    }
                    continue block2;
                }
                break;
            }
            throw new XMLSchemaException("rcase-RecurseLax.2", null);
        }
        throw new XMLSchemaException("rcase-RecurseLax.1", null);
    }

    private static void checkRecurseUnordered(Vector object, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (XSConstraints.checkOccurrenceRange(n, n2, n3, n4)) {
            int n5 = ((Vector)object).size();
            n4 = vector.size();
            boolean[] blArray = new boolean[n4];
            n3 = 0;
            n = 0;
            block3: while (true) {
                if (n >= n5) {
                    n = n3;
                    while (true) {
                        if (n >= n4) {
                            return;
                        }
                        object = (XSParticleDecl)vector.elementAt(n);
                        if (!blArray[n] && !((XSParticleDecl)object).emptiable()) {
                            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                        }
                        ++n;
                    }
                }
                XSParticleDecl xSParticleDecl = (XSParticleDecl)((Vector)object).elementAt(n);
                for (n2 = 0; n2 < n4; ++n2) {
                    Object object2 = (XSParticleDecl)vector.elementAt(n2);
                    try {
                        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, (XSParticleDecl)object2, substitutionGroupHandler2);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        continue;
                    }
                    if (!blArray[n2]) {
                        blArray[n2] = true;
                        ++n;
                        continue block3;
                    }
                    object2 = new XMLSchemaException("rcase-RecurseUnordered.2", null);
                    throw object2;
                }
                break;
            }
            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
        }
        throw new XMLSchemaException("rcase-RecurseUnordered.1", null);
    }

    private static boolean checkSimpleDerivation(XSSimpleType xSSimpleType, XSSimpleType object, short s) {
        if (xSSimpleType == object) {
            return true;
        }
        if ((s & 2) == 0 && (xSSimpleType.getBaseType().getFinal() & 2) == 0) {
            XSSimpleType xSSimpleType2 = (XSSimpleType)xSSimpleType.getBaseType();
            if (xSSimpleType2 == object) {
                return true;
            }
            if (xSSimpleType2 != SchemaGrammar.fAnySimpleType && XSConstraints.checkSimpleDerivation(xSSimpleType2, (XSSimpleType)object, s)) {
                return true;
            }
            if ((xSSimpleType.getVariety() == 2 || xSSimpleType.getVariety() == 3) && object == SchemaGrammar.fAnySimpleType) {
                return true;
            }
            if (object.getVariety() == 3) {
                object = object.getMemberTypes();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    if (!XSConstraints.checkSimpleDerivation(xSSimpleType, (XSSimpleType)object.item(i), s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkSimpleDerivationOk(XSSimpleType xSSimpleType, XSTypeDefinition xSTypeDefinition, short s) {
        XSTypeDefinition xSTypeDefinition2 = SchemaGrammar.fAnySimpleType;
        boolean bl = false;
        if (xSSimpleType == xSTypeDefinition2) {
            if (xSTypeDefinition == SchemaGrammar.fAnyType || xSTypeDefinition == SchemaGrammar.fAnySimpleType) {
                bl = true;
            }
            return bl;
        }
        xSTypeDefinition2 = xSTypeDefinition;
        if (xSTypeDefinition.getTypeCategory() == 13) {
            if (xSTypeDefinition == SchemaGrammar.fAnyType) {
                xSTypeDefinition2 = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return XSConstraints.checkSimpleDerivation(xSSimpleType, xSTypeDefinition2, s);
    }

    public static boolean checkTypeDerivationOk(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s) {
        XSTypeDefinition xSTypeDefinition3 = SchemaGrammar.fAnyType;
        boolean bl = true;
        boolean bl2 = true;
        if (xSTypeDefinition == xSTypeDefinition3) {
            if (xSTypeDefinition != xSTypeDefinition2) {
                bl2 = false;
            }
            return bl2;
        }
        if (xSTypeDefinition == SchemaGrammar.fAnySimpleType) {
            bl2 = bl;
            if (xSTypeDefinition2 != SchemaGrammar.fAnyType) {
                bl2 = xSTypeDefinition2 == SchemaGrammar.fAnySimpleType ? bl : false;
            }
            return bl2;
        }
        if (xSTypeDefinition.getTypeCategory() == 14) {
            xSTypeDefinition3 = xSTypeDefinition2;
            if (xSTypeDefinition2.getTypeCategory() == 13) {
                if (xSTypeDefinition2 == SchemaGrammar.fAnyType) {
                    xSTypeDefinition3 = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)xSTypeDefinition, (XSSimpleType)xSTypeDefinition3, s);
        }
        return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition, xSTypeDefinition2, s);
    }

    public static void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        String string2;
        block6: {
            block5: {
                Object object;
                block4: {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(xSElementDecl.fName);
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(xSElementDecl.fTargetNamespace);
                    string2 = ((StringBuffer)object).toString();
                    object = (XSElementDecl)symbolHash.get(string2);
                    if (object != null) break block4;
                    symbolHash.put(string2, xSElementDecl);
                    break block5;
                }
                if (xSElementDecl == object) {
                    return;
                }
                if (xSElementDecl.fType != ((XSElementDecl)object).fType) break block6;
            }
            return;
        }
        throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, string2});
    }

    public static void fullSchemaChecking(XSGrammarBucket schemaGrammarArray, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter) {
        schemaGrammarArray = schemaGrammarArray.getGrammars();
        int n = schemaGrammarArray.length - 1;
        while (true) {
            int n2 = 1;
            if (n < 0) {
                Object[] objectArray = new XSParticleDecl();
                Object[] objectArray2 = new XSParticleDecl();
                objectArray.fType = (short)3;
                objectArray2.fType = (short)3;
                int n3 = schemaGrammarArray.length - 1;
                n = n2;
                block9: while (true) {
                    int n4;
                    SimpleLocator[] simpleLocatorArray;
                    Object[] objectArray3;
                    XSGroupDecl[] xSGroupDeclArray;
                    int n5 = 0;
                    if (n3 < 0) {
                        xSGroupDeclArray = new SymbolHash();
                        n3 = schemaGrammarArray.length - n;
                        block10: while (true) {
                            if (n3 < 0) {
                                return;
                            }
                            boolean bl = schemaGrammarArray[n3].fFullChecked;
                            objectArray3 = schemaGrammarArray[n3].getUncheckedComplexTypeDecls();
                            simpleLocatorArray = schemaGrammarArray[n3].getUncheckedCTLocators();
                            n4 = objectArray3.length - n;
                            n2 = 0;
                            while (true) {
                                boolean bl2;
                                block30: {
                                    if (n4 < 0) {
                                        if (!bl) {
                                            schemaGrammarArray[n3].setUncheckedTypeNum(n2);
                                            schemaGrammarArray[n3].fFullChecked = n;
                                        }
                                        --n3;
                                        continue block10;
                                    }
                                    if (!bl && ((XSComplexTypeDecl)objectArray3[n4]).fParticle != null) {
                                        xSGroupDeclArray.clear();
                                        try {
                                            XSConstraints.checkElementDeclsConsistent((XSComplexTypeDecl)objectArray3[n4], ((XSComplexTypeDecl)objectArray3[n4]).fParticle, (SymbolHash)xSGroupDeclArray, substitutionGroupHandler);
                                        }
                                        catch (XMLSchemaException xMLSchemaException) {
                                            XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n4], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                                        }
                                    }
                                    if (((XSComplexTypeDecl)objectArray3[n4]).fBaseType != null && ((XSComplexTypeDecl)objectArray3[n4]).fBaseType != SchemaGrammar.fAnyType && ((XSComplexTypeDecl)objectArray3[n4]).fDerivedBy == 2 && ((XSComplexTypeDecl)objectArray3[n4]).fBaseType instanceof XSComplexTypeDecl) {
                                        objectArray = ((XSComplexTypeDecl)objectArray3[n4]).fParticle;
                                        objectArray2 = ((XSComplexTypeDecl)((XSComplexTypeDecl)objectArray3[n4]).fBaseType).fParticle;
                                        if (objectArray == null && objectArray2 != null && !objectArray2.emptiable()) {
                                            objectArray = simpleLocatorArray[n4];
                                            objectArray2 = new Object[n];
                                            objectArray2[n5] = ((XSComplexTypeDecl)objectArray3[n4]).fName;
                                            XSConstraints.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray, "derivation-ok-restriction.5.2.2", objectArray2);
                                        } else if (objectArray != null && objectArray2 != null) {
                                            try {
                                                XSConstraints.particleValidRestriction(((XSComplexTypeDecl)objectArray3[n4]).fParticle, substitutionGroupHandler, ((XSComplexTypeDecl)((XSComplexTypeDecl)objectArray3[n4]).fBaseType).fParticle, substitutionGroupHandler);
                                            }
                                            catch (XMLSchemaException xMLSchemaException) {
                                                XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n4], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                                                objectArray2 = simpleLocatorArray[n4];
                                                objectArray = new Object[n];
                                                objectArray[n5] = ((XSComplexTypeDecl)objectArray3[n4]).fName;
                                                XSConstraints.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray2, "derivation-ok-restriction.5.3.2", objectArray);
                                            }
                                        }
                                    }
                                    if ((objectArray2 = ((XSComplexTypeDecl)objectArray3[n4]).getContentModel(cMBuilder)) != null) {
                                        try {
                                            bl2 = objectArray2.checkUniqueParticleAttribution(substitutionGroupHandler);
                                            break block30;
                                        }
                                        catch (XMLSchemaException xMLSchemaException) {
                                            XSConstraints.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n4], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                                        }
                                    }
                                    bl2 = false;
                                }
                                n5 = n2;
                                if (!bl) {
                                    n5 = n2;
                                    if (bl2) {
                                        objectArray3[n2] = objectArray3[n4];
                                        n5 = n2 + 1;
                                    }
                                }
                                --n4;
                                int n6 = 0;
                                n2 = n5;
                                n5 = n6;
                            }
                            break;
                        }
                    }
                    xSGroupDeclArray = schemaGrammarArray[n3].getRedefinedGroupDecls();
                    objectArray3 = schemaGrammarArray[n3].getRGLocators();
                    n2 = 0;
                    while (true) {
                        if (n2 >= xSGroupDeclArray.length) {
                            --n3;
                            continue block9;
                        }
                        n4 = n2 + 1;
                        simpleLocatorArray = xSGroupDeclArray[n2];
                        Object object = simpleLocatorArray.fModelGroup;
                        n2 = n4 + 1;
                        Object object2 = xSGroupDeclArray[n4].fModelGroup;
                        if (object2 == null) {
                            if (object != null) {
                                object = objectArray3[n2 / 2 - n];
                                object2 = new Object[2];
                                object2[0] = simpleLocatorArray.fName;
                                object2[n] = "rcase-Recurse.2";
                                XSConstraints.reportSchemaError(xMLErrorReporter, (SimpleLocator)object, "src-redefine.6.2.2", object2);
                            }
                        } else {
                            objectArray.fValue = object;
                            objectArray2.fValue = object2;
                            try {
                                XSConstraints.particleValidRestriction((XSParticleDecl)objectArray, substitutionGroupHandler, (XSParticleDecl)objectArray2, substitutionGroupHandler);
                            }
                            catch (XMLSchemaException xMLSchemaException) {
                                object2 = xMLSchemaException.getKey();
                                n = n2 / 2 - 1;
                                XSConstraints.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray3[n], (String)object2, xMLSchemaException.getArgs());
                                XSConstraints.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray3[n], "src-redefine.6.2.2", new Object[]{simpleLocatorArray.fName, object2});
                            }
                        }
                        n = 1;
                    }
                    break;
                }
            }
            substitutionGroupHandler.addSubstitutionGroup(schemaGrammarArray[n].getSubstitutionGroups());
            --n;
        }
    }

    private static void gatherChildren(int n, XSParticleDecl xSObject, Vector vector) {
        block6: {
            block9: {
                block7: {
                    block8: {
                        short s;
                        int n2 = xSObject.fMinOccurs;
                        int n3 = xSObject.fMaxOccurs;
                        short s2 = s = xSObject.fType;
                        if (s == 3) {
                            s2 = ((XSModelGroupImpl)xSObject.fValue).fCompositor;
                        }
                        if (s2 == 0) {
                            return;
                        }
                        if (s2 == 1 || s2 == 2) break block6;
                        if (n2 != 1 || n3 != 1) break block7;
                        if (n != s2) break block8;
                        xSObject = (XSModelGroupImpl)xSObject.fValue;
                        for (n = 0; n < ((XSModelGroupImpl)xSObject).fParticleCount; ++n) {
                            XSConstraints.gatherChildren(s2, ((XSModelGroupImpl)xSObject).fParticles[n], vector);
                        }
                        break block9;
                    }
                    if (xSObject.isEmpty()) break block9;
                }
                vector.addElement(xSObject);
            }
            return;
        }
        vector.addElement(xSObject);
    }

    private static XSParticleDecl getNonUnaryGroup(XSParticleDecl xSParticleDecl) {
        XSParticleDecl xSParticleDecl2 = xSParticleDecl;
        if (xSParticleDecl.fType != 1) {
            if (xSParticleDecl.fType == 2) {
                xSParticleDecl2 = xSParticleDecl;
            } else {
                xSParticleDecl2 = xSParticleDecl;
                if (xSParticleDecl.fMinOccurs == 1) {
                    xSParticleDecl2 = xSParticleDecl;
                    if (xSParticleDecl.fMaxOccurs == 1) {
                        xSParticleDecl2 = xSParticleDecl;
                        if (xSParticleDecl.fValue != null) {
                            xSParticleDecl2 = xSParticleDecl;
                            if (((XSModelGroupImpl)xSParticleDecl.fValue).fParticleCount == 1) {
                                xSParticleDecl2 = XSConstraints.getNonUnaryGroup(((XSModelGroupImpl)xSParticleDecl.fValue).fParticles[0]);
                            }
                        }
                    }
                }
            }
        }
        return xSParticleDecl2;
    }

    public static boolean overlapUPA(Object object, Object object2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (object instanceof XSElementDecl) {
            boolean bl = object2 instanceof XSElementDecl;
            object = (XSElementDecl)object;
            if (bl) {
                return XSConstraints.overlapUPA((XSElementDecl)object, (XSElementDecl)object2, substitutionGroupHandler);
            }
            return XSConstraints.overlapUPA((XSElementDecl)object, (XSWildcardDecl)object2, substitutionGroupHandler);
        }
        if (object2 instanceof XSElementDecl) {
            return XSConstraints.overlapUPA((XSElementDecl)object2, (XSWildcardDecl)object, substitutionGroupHandler);
        }
        return XSConstraints.overlapUPA((XSWildcardDecl)object, (XSWildcardDecl)object2);
    }

    public static boolean overlapUPA(XSElementDecl xSElementDecl, XSElementDecl xSElementDeclArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSElementDecl.fName == xSElementDeclArray.fName && xSElementDecl.fTargetNamespace == xSElementDeclArray.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray2 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
        int n = xSElementDeclArray2.length - 1;
        while (true) {
            if (n < 0) {
                xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSElementDeclArray);
                n = xSElementDeclArray.length - 1;
                while (true) {
                    if (n < 0) {
                        return false;
                    }
                    if (xSElementDeclArray[n].fName == xSElementDecl.fName && xSElementDeclArray[n].fTargetNamespace == xSElementDecl.fTargetNamespace) {
                        return true;
                    }
                    --n;
                }
            }
            if (xSElementDeclArray2[n].fName == xSElementDeclArray.fName && xSElementDeclArray2[n].fTargetNamespace == xSElementDeclArray.fTargetNamespace) {
                return true;
            }
            --n;
        }
    }

    public static boolean overlapUPA(XSElementDecl xSElementDeclArray, XSWildcardDecl xSWildcardDecl, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSWildcardDecl.allowNamespace(xSElementDeclArray.fTargetNamespace)) {
            return true;
        }
        xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSElementDeclArray);
        int n = xSElementDeclArray.length - 1;
        while (n >= 0) {
            if (xSWildcardDecl.allowNamespace(xSElementDeclArray[n].fTargetNamespace)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static boolean overlapUPA(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        return (xSWildcardDecl = xSWildcardDecl.performIntersectionWith(xSWildcardDecl2, xSWildcardDecl.fProcessContents)) == null || xSWildcardDecl.fType != 3 || xSWildcardDecl.fNamespaceList.length != 0;
        {
        }
    }

    private static void particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl2, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        XSConstraints.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2, true);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private static void particleValidRestriction(XSParticleDecl var0, SubstitutionGroupHandler var1_1, XSParticleDecl var2_2, SubstitutionGroupHandler var3_3, boolean var4_4) throws XMLSchemaException {
        block57: {
            block58: {
                block59: {
                    var5_5 = var0;
                    if (var0.isEmpty() != var2_2.isEmpty()) {
                        throw new XMLSchemaException("cos-particle-restrict", null);
                    }
                    var6_6 = var5_5.fType;
                    if (var6_6 == 3) {
                        var6_6 = ((XSModelGroupImpl)var5_5.fValue).fCompositor;
                        if ((var0 = XSConstraints.getNonUnaryGroup((XSParticleDecl)var0)) != var5_5) {
                            var6_6 = var7_7 = (int)var0.fType;
                            if (var7_7 == 3) {
                                var6_6 = ((XSModelGroupImpl)var0.fValue).fCompositor;
                            }
                        } else {
                            var0 = var5_5;
                        }
                        var8_8 = XSConstraints.removePointlessChildren((XSParticleDecl)var0);
                        var5_5 = var0;
                        var0 = var8_8;
                    } else {
                        var0 = null;
                    }
                    var9_9 = var5_5.fMinOccurs;
                    var10_10 = var5_5.fMaxOccurs;
                    if (var1_1 == null || var6_6 != 1) ** GOTO lbl-1000
                    var11_11 = (XSElementDecl[])var5_5.fValue;
                    if (var11_11.fScope != 1 || (var12_12 /* !! */  = var1_1.getSubstitutionGroup((XSElementDecl)var11_11)).length <= 0) lbl-1000:
                    // 2 sources

                    {
                        var7_7 = -2;
                        var14_14 = -2;
                        var8_8 = var0;
                        var13_13 = var6_6;
                        var6_6 = var14_14;
                    } else {
                        var8_8 = new Vector<E>(var12_12 /* !! */ .length + 1);
                        var6_6 = 0;
                        while (true) {
                            if (var6_6 >= var12_12 /* !! */ .length) {
                                XSConstraints.addElementToParticleVector(var8_8, (XSElementDecl)var11_11);
                                var7_7 = var9_9;
                                var6_6 = var10_10;
                                var13_13 = 101;
                                var1_1 = null;
                                break;
                            }
                            XSConstraints.addElementToParticleVector(var8_8, var12_12 /* !! */ [var6_6]);
                            ++var6_6;
                        }
                    }
                    var14_14 = var2_2.fType;
                    if (var14_14 == 3) {
                        var14_14 = ((XSModelGroupImpl)var2_2.fValue).fCompositor;
                        var0 = XSConstraints.getNonUnaryGroup(var2_2);
                        if (var0 != var2_2) {
                            var14_14 = var15_15 = (int)var0.fType;
                            if (var15_15 == 3) {
                                var14_14 = ((XSModelGroupImpl)var0.fValue).fCompositor;
                            }
                        } else {
                            var0 = var2_2;
                        }
                        var12_12 /* !! */  = XSConstraints.removePointlessChildren((XSParticleDecl)var0);
                        var2_2 = var0;
                        var0 = var12_12 /* !! */ ;
                    } else {
                        var0 = null;
                    }
                    var15_15 = var2_2.fMinOccurs;
                    var16_16 = var2_2.fMaxOccurs;
                    if (var3_3 != null && var14_14 == 1) {
                        var12_12 /* !! */  = (XSElementDecl)var2_2.fValue;
                        if (var12_12 /* !! */ .fScope == 1 && (var11_11 = var3_3.getSubstitutionGroup((XSElementDecl)var12_12 /* !! */ )).length > 0) {
                            var0 = new Vector<E>(var11_11.length + 1);
                            var14_14 = 0;
                            while (true) {
                                if (var14_14 >= var11_11.length) {
                                    XSConstraints.addElementToParticleVector((Vector)var0, (XSElementDecl)var12_12 /* !! */ );
                                    var14_14 = 101;
                                    var3_3 = null;
                                    break;
                                }
                                XSConstraints.addElementToParticleVector((Vector)var0, var11_11[var14_14]);
                                ++var14_14;
                            }
                        }
                    }
                    if (var13_13 == 1) break block57;
                    if (var13_13 == 2) break block58;
                    switch (var13_13) {
                        default: {
                            return;
                        }
                        case 103: {
                            if (var14_14 == 1) ** GOTO lbl95
                            if (var14_14 == 2) ** GOTO lbl87
                            switch (var14_14) {
                                default: {
                                    throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
                                }
                                case 103: {
                                    XSConstraints.checkRecurse(var8_8, var9_9, var10_10, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                                    return;
                                }
lbl87:
                                // 1 sources

                                var14_14 = var7_7;
                                if (var7_7 == -2) {
                                    var14_14 = var5_5.minEffectiveTotalRange();
                                }
                                if (var6_6 == -2) {
                                    var6_6 = var5_5.maxEffectiveTotalRange();
                                }
                                XSConstraints.checkNSRecurseCheckCardinality(var8_8, var14_14, var6_6, var1_1, var2_2, var15_15, var16_16, var4_4);
                                return;
                                case 101: 
                                case 102: 
                            }
lbl95:
                            // 2 sources

                            throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                        }
                        case 102: {
                            if (var14_14 == 1) {
                                throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                            }
                            if (var14_14 != 2) {
                                switch (var14_14) {
                                    default: {
                                        throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
                                    }
                                    case 103: {
                                        XSConstraints.checkRecurseUnordered(var8_8, var9_9, var10_10, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                                        return;
                                    }
                                    case 102: {
                                        XSConstraints.checkRecurse(var8_8, var9_9, var10_10, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                                        return;
                                    }
                                    case 101: 
                                }
                                var6_6 = var8_8.size();
                                if (var10_10 != -1) {
                                    var10_10 *= var8_8.size();
                                }
                                XSConstraints.checkMapAndSum(var8_8, var9_9 * var6_6, var10_10, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                                return;
                            }
                            var14_14 = var7_7;
                            if (var7_7 == -2) {
                                var14_14 = var5_5.minEffectiveTotalRange();
                            }
                            if (var6_6 == -2) {
                                var6_6 = var5_5.maxEffectiveTotalRange();
                            }
                            XSConstraints.checkNSRecurseCheckCardinality(var8_8, var14_14, var6_6, var1_1, var2_2, var15_15, var16_16, var4_4);
                            return;
                        }
                        case 101: 
                    }
                    if (var14_14 == 1) break block59;
                    if (var14_14 == 2) ** GOTO lbl131
                    switch (var14_14) {
                        default: {
                            throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
                        }
                        case 101: {
                            XSConstraints.checkRecurseLax(var8_8, var9_9, var10_10, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                            return;
                        }
lbl131:
                        // 1 sources

                        var14_14 = var7_7;
                        if (var7_7 == -2) {
                            var14_14 = var5_5.minEffectiveTotalRange();
                        }
                        if (var6_6 == -2) {
                            var6_6 = var5_5.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(var8_8, var14_14, var6_6, var1_1, var2_2, var15_15, var16_16, var4_4);
                        return;
                        case 102: 
                        case 103: 
                    }
                }
                throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
            }
            if (var14_14 != 1) {
                if (var14_14 == 2) {
                    XSConstraints.checkNSSubset((XSWildcardDecl)var5_5.fValue, var9_9, var10_10, (XSWildcardDecl)var2_2.fValue, var15_15, var16_16);
                    return;
                }
                switch (var14_14) {
                    default: {
                        throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                }
            }
            throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
        }
        if (var14_14 == 1) {
            XSConstraints.checkNameAndTypeOK((XSElementDecl)var5_5.fValue, var9_9, var10_10, (XSElementDecl)var2_2.fValue, var15_15, var16_16);
            return;
        }
        if (var14_14 == 2) {
            XSConstraints.checkNSCompat((XSElementDecl)var5_5.fValue, var9_9, var10_10, (XSWildcardDecl)var2_2.fValue, var15_15, var16_16, var4_4);
            return;
        }
        switch (var14_14) {
            default: {
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 102: 
            case 103: {
                var2_2 = new Vector<Object>();
                var2_2.addElement(var5_5);
                XSConstraints.checkRecurse(var2_2, 1, 1, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
                return;
            }
            case 101: 
        }
        var2_2 = new Vector<E>();
        var2_2.addElement(var5_5);
        XSConstraints.checkRecurseLax(var2_2, 1, 1, var1_1, (Vector)var0, var15_15, var16_16, var3_3);
    }

    private static Vector removePointlessChildren(XSParticleDecl xSObject) {
        if (xSObject.fType != 1 && xSObject.fType != 2 && xSObject.fType != 0) {
            Vector vector = new Vector();
            xSObject = (XSModelGroupImpl)xSObject.fValue;
            int n = 0;
            while (true) {
                if (n >= ((XSModelGroupImpl)xSObject).fParticleCount) {
                    return vector;
                }
                XSConstraints.gatherChildren(((XSModelGroupImpl)xSObject).fCompositor, ((XSModelGroupImpl)xSObject).fParticles[n], vector);
                ++n;
            }
        }
        return null;
    }

    static void reportSchemaError(XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator, String string2, Object[] objectArray) {
        if (simpleLocator != null) {
            xMLErrorReporter.reportError(simpleLocator, "http://www.w3.org/TR/xml-schema-1", string2, objectArray, (short)1);
        } else {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string2, objectArray, (short)1);
        }
    }
}

