/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;

public final class XSDeclarationPool {
    private static final int CHUNK_MASK = 255;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XSAttributeDecl[][] fAttrDecl;
    private int fAttrDeclIndex = 0;
    private XSAttributeUseImpl[][] fAttributeUse;
    private int fAttributeUseIndex = 0;
    private XSComplexTypeDecl[][] fCTDecl;
    private int fCTDeclIndex = 0;
    private XSElementDecl[][] fElementDecl = new XSElementDecl[4][];
    private int fElementDeclIndex = 0;
    private XSModelGroupImpl[][] fModelGroup;
    private int fModelGroupIndex = 0;
    private XSParticleDecl[][] fParticleDecl = new XSParticleDecl[4][];
    private int fParticleDeclIndex = 0;
    private XSSimpleTypeDecl[][] fSTDecl;
    private int fSTDeclIndex = 0;

    public XSDeclarationPool() {
        this.fModelGroup = new XSModelGroupImpl[4][];
        this.fAttrDecl = new XSAttributeDecl[4][];
        this.fCTDecl = new XSComplexTypeDecl[4][];
        this.fSTDecl = new XSSimpleTypeDecl[4][];
        this.fAttributeUse = new XSAttributeUseImpl[4][];
    }

    private boolean ensureAttrDeclCapacity(int n) {
        XSAttributeDecl[][] xSAttributeDeclArray = this.fAttrDecl;
        if (n >= xSAttributeDeclArray.length) {
            this.fAttrDecl = XSDeclarationPool.resize(xSAttributeDeclArray, xSAttributeDeclArray.length * 2);
        } else if (xSAttributeDeclArray[n] != null) {
            return false;
        }
        this.fAttrDecl[n] = new XSAttributeDecl[256];
        return true;
    }

    private boolean ensureAttributeUseCapacity(int n) {
        XSAttributeUseImpl[][] xSAttributeUseImplArray = this.fAttributeUse;
        if (n >= xSAttributeUseImplArray.length) {
            this.fAttributeUse = XSDeclarationPool.resize(xSAttributeUseImplArray, xSAttributeUseImplArray.length * 2);
        } else if (xSAttributeUseImplArray[n] != null) {
            return false;
        }
        this.fAttributeUse[n] = new XSAttributeUseImpl[256];
        return true;
    }

    private boolean ensureCTDeclCapacity(int n) {
        XSComplexTypeDecl[][] xSComplexTypeDeclArray = this.fCTDecl;
        if (n >= xSComplexTypeDeclArray.length) {
            this.fCTDecl = XSDeclarationPool.resize(xSComplexTypeDeclArray, xSComplexTypeDeclArray.length * 2);
        } else if (xSComplexTypeDeclArray[n] != null) {
            return false;
        }
        this.fCTDecl[n] = new XSComplexTypeDecl[256];
        return true;
    }

    private boolean ensureElementDeclCapacity(int n) {
        XSElementDecl[][] xSElementDeclArray = this.fElementDecl;
        if (n >= xSElementDeclArray.length) {
            this.fElementDecl = XSDeclarationPool.resize(xSElementDeclArray, xSElementDeclArray.length * 2);
        } else if (xSElementDeclArray[n] != null) {
            return false;
        }
        this.fElementDecl[n] = new XSElementDecl[256];
        return true;
    }

    private boolean ensureModelGroupCapacity(int n) {
        XSModelGroupImpl[][] xSModelGroupImplArray = this.fModelGroup;
        if (n >= xSModelGroupImplArray.length) {
            this.fModelGroup = XSDeclarationPool.resize(xSModelGroupImplArray, xSModelGroupImplArray.length * 2);
        } else if (xSModelGroupImplArray[n] != null) {
            return false;
        }
        this.fModelGroup[n] = new XSModelGroupImpl[256];
        return true;
    }

    private boolean ensureParticleDeclCapacity(int n) {
        XSParticleDecl[][] xSParticleDeclArray = this.fParticleDecl;
        if (n >= xSParticleDeclArray.length) {
            this.fParticleDecl = XSDeclarationPool.resize(xSParticleDeclArray, xSParticleDeclArray.length * 2);
        } else if (xSParticleDeclArray[n] != null) {
            return false;
        }
        this.fParticleDecl[n] = new XSParticleDecl[256];
        return true;
    }

    private boolean ensureSTDeclCapacity(int n) {
        XSSimpleTypeDecl[][] xSSimpleTypeDeclArray = this.fSTDecl;
        if (n >= xSSimpleTypeDeclArray.length) {
            this.fSTDecl = XSDeclarationPool.resize(xSSimpleTypeDeclArray, xSSimpleTypeDeclArray.length * 2);
        } else if (xSSimpleTypeDeclArray[n] != null) {
            return false;
        }
        this.fSTDecl[n] = new XSSimpleTypeDecl[256];
        return true;
    }

    private static XSSimpleTypeDecl[][] resize(XSSimpleTypeDecl[][] xSSimpleTypeDeclArray, int n) {
        XSSimpleTypeDecl[][] xSSimpleTypeDeclArray2 = new XSSimpleTypeDecl[n][];
        System.arraycopy(xSSimpleTypeDeclArray, 0, xSSimpleTypeDeclArray2, 0, xSSimpleTypeDeclArray.length);
        return xSSimpleTypeDeclArray2;
    }

    private static XSAttributeDecl[][] resize(XSAttributeDecl[][] xSAttributeDeclArray, int n) {
        XSAttributeDecl[][] xSAttributeDeclArray2 = new XSAttributeDecl[n][];
        System.arraycopy(xSAttributeDeclArray, 0, xSAttributeDeclArray2, 0, xSAttributeDeclArray.length);
        return xSAttributeDeclArray2;
    }

    private static XSAttributeUseImpl[][] resize(XSAttributeUseImpl[][] xSAttributeUseImplArray, int n) {
        XSAttributeUseImpl[][] xSAttributeUseImplArray2 = new XSAttributeUseImpl[n][];
        System.arraycopy(xSAttributeUseImplArray, 0, xSAttributeUseImplArray2, 0, xSAttributeUseImplArray.length);
        return xSAttributeUseImplArray2;
    }

    private static XSComplexTypeDecl[][] resize(XSComplexTypeDecl[][] xSComplexTypeDeclArray, int n) {
        XSComplexTypeDecl[][] xSComplexTypeDeclArray2 = new XSComplexTypeDecl[n][];
        System.arraycopy(xSComplexTypeDeclArray, 0, xSComplexTypeDeclArray2, 0, xSComplexTypeDeclArray.length);
        return xSComplexTypeDeclArray2;
    }

    private static XSElementDecl[][] resize(XSElementDecl[][] xSElementDeclArray, int n) {
        XSElementDecl[][] xSElementDeclArray2 = new XSElementDecl[n][];
        System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, xSElementDeclArray.length);
        return xSElementDeclArray2;
    }

    private static XSModelGroupImpl[][] resize(XSModelGroupImpl[][] xSModelGroupImplArray, int n) {
        XSModelGroupImpl[][] xSModelGroupImplArray2 = new XSModelGroupImpl[n][];
        System.arraycopy(xSModelGroupImplArray, 0, xSModelGroupImplArray2, 0, xSModelGroupImplArray.length);
        return xSModelGroupImplArray2;
    }

    private static XSParticleDecl[][] resize(XSParticleDecl[][] xSParticleDeclArray, int n) {
        XSParticleDecl[][] xSParticleDeclArray2 = new XSParticleDecl[n][];
        System.arraycopy(xSParticleDeclArray, 0, xSParticleDeclArray2, 0, xSParticleDeclArray.length);
        return xSParticleDeclArray2;
    }

    public final XSAttributeDecl getAttributeDecl() {
        int n = this.fAttrDeclIndex;
        int n2 = n >> 8;
        this.ensureAttrDeclCapacity(n2);
        XSAttributeDecl[][] xSAttributeDeclArray = this.fAttrDecl;
        if (xSAttributeDeclArray[n2][n &= 0xFF] == null) {
            xSAttributeDeclArray[n2][n] = new XSAttributeDecl();
        } else {
            xSAttributeDeclArray[n2][n].reset();
        }
        ++this.fAttrDeclIndex;
        return this.fAttrDecl[n2][n];
    }

    public final XSAttributeUseImpl getAttributeUse() {
        int n = this.fAttributeUseIndex;
        int n2 = n >> 8;
        this.ensureAttributeUseCapacity(n2);
        XSAttributeUseImpl[][] xSAttributeUseImplArray = this.fAttributeUse;
        if (xSAttributeUseImplArray[n2][n &= 0xFF] == null) {
            xSAttributeUseImplArray[n2][n] = new XSAttributeUseImpl();
        } else {
            xSAttributeUseImplArray[n2][n].reset();
        }
        ++this.fAttributeUseIndex;
        return this.fAttributeUse[n2][n];
    }

    public final XSComplexTypeDecl getComplexTypeDecl() {
        int n = this.fCTDeclIndex;
        int n2 = n >> 8;
        this.ensureCTDeclCapacity(n2);
        XSComplexTypeDecl[][] xSComplexTypeDeclArray = this.fCTDecl;
        if (xSComplexTypeDeclArray[n2][n &= 0xFF] == null) {
            xSComplexTypeDeclArray[n2][n] = new XSComplexTypeDecl();
        } else {
            xSComplexTypeDeclArray[n2][n].reset();
        }
        ++this.fCTDeclIndex;
        return this.fCTDecl[n2][n];
    }

    public final XSElementDecl getElementDecl() {
        int n = this.fElementDeclIndex;
        int n2 = n >> 8;
        this.ensureElementDeclCapacity(n2);
        XSElementDecl[][] xSElementDeclArray = this.fElementDecl;
        if (xSElementDeclArray[n2][n &= 0xFF] == null) {
            xSElementDeclArray[n2][n] = new XSElementDecl();
        } else {
            xSElementDeclArray[n2][n].reset();
        }
        ++this.fElementDeclIndex;
        return this.fElementDecl[n2][n];
    }

    public final XSModelGroupImpl getModelGroup() {
        int n = this.fModelGroupIndex;
        int n2 = n >> 8;
        this.ensureModelGroupCapacity(n2);
        XSModelGroupImpl[][] xSModelGroupImplArray = this.fModelGroup;
        if (xSModelGroupImplArray[n2][n &= 0xFF] == null) {
            xSModelGroupImplArray[n2][n] = new XSModelGroupImpl();
        } else {
            xSModelGroupImplArray[n2][n].reset();
        }
        ++this.fModelGroupIndex;
        return this.fModelGroup[n2][n];
    }

    public final XSParticleDecl getParticleDecl() {
        int n = this.fParticleDeclIndex;
        int n2 = n >> 8;
        this.ensureParticleDeclCapacity(n2);
        XSParticleDecl[][] xSParticleDeclArray = this.fParticleDecl;
        if (xSParticleDeclArray[n2][n &= 0xFF] == null) {
            xSParticleDeclArray[n2][n] = new XSParticleDecl();
        } else {
            xSParticleDeclArray[n2][n].reset();
        }
        ++this.fParticleDeclIndex;
        return this.fParticleDecl[n2][n];
    }

    public final XSSimpleTypeDecl getSimpleTypeDecl() {
        int n = this.fSTDeclIndex;
        int n2 = n >> 8;
        this.ensureSTDeclCapacity(n2);
        XSSimpleTypeDecl[][] xSSimpleTypeDeclArray = this.fSTDecl;
        if (xSSimpleTypeDeclArray[n2][n &= 0xFF] == null) {
            xSSimpleTypeDeclArray[n2][n] = new XSSimpleTypeDecl();
        } else {
            xSSimpleTypeDeclArray[n2][n].reset();
        }
        ++this.fSTDeclIndex;
        return this.fSTDecl[n2][n];
    }

    public void reset() {
        this.fElementDeclIndex = 0;
        this.fParticleDeclIndex = 0;
        this.fModelGroupIndex = 0;
        this.fSTDeclIndex = 0;
        this.fCTDeclIndex = 0;
        this.fAttrDeclIndex = 0;
        this.fAttributeUseIndex = 0;
    }
}

