/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSComplexTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;

public class XSElementDecl
implements XSElementDeclaration {
    private static final short ABSTRACT = 8;
    private static final short CONSTRAINT_MASK = 3;
    static final int INITIAL_SIZE = 2;
    private static final short NILLABLE = 4;
    public static final short SCOPE_ABSENT = 0;
    public static final short SCOPE_GLOBAL = 1;
    public static final short SCOPE_LOCAL = 2;
    public short fBlock;
    public ValidatedInfo fDefault = null;
    private String fDescription = null;
    XSComplexTypeDecl fEnclosingCT = null;
    public short fFinal;
    int fIDCPos = 0;
    IdentityConstraint[] fIDConstraints;
    short fMiscFlags = (short)0;
    public String fName = null;
    public short fScope = (short)0;
    public XSElementDecl fSubGroup = null;
    public String fTargetNamespace = null;
    public XSTypeDefinition fType = null;

    public XSElementDecl() {
        this.fBlock = (short)0;
        this.fFinal = (short)0;
        this.fIDConstraints = new IdentityConstraint[2];
    }

    static final IdentityConstraint[] resize(IdentityConstraint[] identityConstraintArray, int n) {
        IdentityConstraint[] identityConstraintArray2 = new IdentityConstraint[n];
        System.arraycopy(identityConstraintArray, 0, identityConstraintArray2, 0, Math.min(identityConstraintArray.length, n));
        return identityConstraintArray2;
    }

    public void addIDConstaint(IdentityConstraint identityConstraint) {
        int n = this.fIDCPos;
        IdentityConstraint[] identityConstraintArray = this.fIDConstraints;
        if (n == identityConstraintArray.length) {
            this.fIDConstraints = XSElementDecl.resize(identityConstraintArray, n * 2);
        }
        identityConstraintArray = this.fIDConstraints;
        n = this.fIDCPos;
        this.fIDCPos = n + 1;
        identityConstraintArray[n] = identityConstraint;
    }

    public boolean equals(Object object) {
        boolean bl = object == this;
        return bl;
    }

    @Override
    public boolean getAbstract() {
        boolean bl = (this.fMiscFlags & 8) != 0;
        return bl;
    }

    @Override
    public XSAnnotation getAnnotation() {
        return null;
    }

    @Override
    public short getConstraintType() {
        return (short)(this.fMiscFlags & 3);
    }

    @Override
    public String getConstraintValue() {
        String string2 = this.getConstraintType() == 0 ? null : this.fDefault.stringValue();
        return string2;
    }

    @Override
    public short getDisallowedSubstitutions() {
        return this.fBlock;
    }

    @Override
    public XSComplexTypeDefinition getEnclosingCTDefinition() {
        return this.fEnclosingCT;
    }

    public IdentityConstraint[] getIDConstraints() {
        int n = this.fIDCPos;
        if (n == 0) {
            return null;
        }
        IdentityConstraint[] identityConstraintArray = this.fIDConstraints;
        if (n < identityConstraintArray.length) {
            this.fIDConstraints = XSElementDecl.resize(identityConstraintArray, n);
        }
        return this.fIDConstraints;
    }

    @Override
    public XSNamedMap getIdentityConstraints() {
        return new XSNamedMapImpl(this.fIDConstraints, this.fIDCPos);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getNamespace() {
        return this.fTargetNamespace;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    @Override
    public boolean getNillable() {
        boolean bl = (this.fMiscFlags & 4) != 0;
        return bl;
    }

    @Override
    public short getScope() {
        return this.fScope;
    }

    @Override
    public XSElementDeclaration getSubstitutionGroupAffiliation() {
        return this.fSubGroup;
    }

    @Override
    public short getSubstitutionGroupExclusions() {
        return this.fFinal;
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public XSTypeDefinition getTypeDefinition() {
        return this.fType;
    }

    public int hashCode() {
        int n = this.fName.hashCode();
        String string2 = this.fTargetNamespace;
        int n2 = n;
        if (string2 != null) {
            n2 = (n << 16) + string2.hashCode();
        }
        return n2;
    }

    @Override
    public boolean isDisallowedSubstitution(short s) {
        boolean bl = (s & this.fBlock) != 0;
        return bl;
    }

    @Override
    public boolean isSubstitutionGroupExclusion(short s) {
        boolean bl = (s & this.fFinal) != 0;
        return bl;
    }

    public void reset() {
        this.fName = null;
        this.fTargetNamespace = null;
        this.fType = null;
        this.fMiscFlags = (short)0;
        this.fBlock = (short)0;
        this.fFinal = (short)0;
        this.fDefault = null;
        this.fSubGroup = null;
        int n = 0;
        while (true) {
            if (n >= this.fIDCPos) {
                this.fIDCPos = 0;
                return;
            }
            this.fIDConstraints[n] = null;
            ++n;
        }
    }

    public void setConstraintType(short s) {
        short s2 = this.fMiscFlags;
        s2 = (short)(s2 ^ s2 & 3);
        this.fMiscFlags = s2;
        this.fMiscFlags = (short)(s & 3 | s2);
    }

    public void setIsAbstract() {
        this.fMiscFlags = (short)(this.fMiscFlags | 8);
    }

    public void setIsGlobal() {
        this.fScope = (short)1;
    }

    public void setIsLocal(XSComplexTypeDecl xSComplexTypeDecl) {
        this.fScope = (short)2;
        this.fEnclosingCT = xSComplexTypeDecl;
    }

    public void setIsNillable() {
        this.fMiscFlags = (short)(this.fMiscFlags | 4);
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"");
            String string2 = this.fTargetNamespace;
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\"");
            stringBuffer.append(":");
            stringBuffer.append(this.fName);
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }
}

