/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSModelGroup;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;

public class XSModelGroupImpl
implements XSModelGroup {
    public static final short MODELGROUP_ALL = 103;
    public static final short MODELGROUP_CHOICE = 101;
    public static final short MODELGROUP_SEQUENCE = 102;
    public short fCompositor;
    private String fDescription = null;
    public int fParticleCount = 0;
    public XSParticleDecl[] fParticles = null;

    private int maxEffectiveTotalRangeAllSeq() {
        int n = 0;
        int n2 = 0;
        while (n < this.fParticleCount) {
            int n3 = this.fParticles[n].maxEffectiveTotalRange();
            if (n3 == -1) {
                return -1;
            }
            n2 += n3;
            ++n;
        }
        return n2;
    }

    private int maxEffectiveTotalRangeChoice() {
        XSParticleDecl[] xSParticleDeclArray = this.fParticles;
        int n = xSParticleDeclArray.length;
        int n2 = 0;
        if (n > 0) {
            n2 = n = xSParticleDeclArray[0].minEffectiveTotalRange();
            if (n == -1) {
                return -1;
            }
        }
        int n3 = 1;
        n = n2;
        n2 = n3;
        while (n2 < this.fParticleCount) {
            int n4 = this.fParticles[n2].maxEffectiveTotalRange();
            if (n4 == -1) {
                return -1;
            }
            n3 = n;
            if (n4 > n) {
                n3 = n4;
            }
            ++n2;
            n = n3;
        }
        return n;
    }

    private int minEffectiveTotalRangeAllSeq() {
        int n = 0;
        int n2 = 0;
        while (n < this.fParticleCount) {
            n2 += this.fParticles[n].minEffectiveTotalRange();
            ++n;
        }
        return n2;
    }

    private int minEffectiveTotalRangeChoice() {
        XSParticleDecl[] xSParticleDeclArray = this.fParticles;
        int n = xSParticleDeclArray.length;
        int n2 = 0;
        if (n > 0) {
            n2 = xSParticleDeclArray[0].minEffectiveTotalRange();
        }
        int n3 = 1;
        n = n2;
        n2 = n3;
        while (n2 < this.fParticleCount) {
            int n4 = this.fParticles[n2].minEffectiveTotalRange();
            n3 = n;
            if (n4 < n) {
                n3 = n4;
            }
            ++n2;
            n = n3;
        }
        return n;
    }

    @Override
    public XSAnnotation getAnnotation() {
        return null;
    }

    @Override
    public short getCompositor() {
        short s = this.fCompositor;
        if (s == 101) {
            return 2;
        }
        if (s == 102) {
            return 1;
        }
        return 3;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    @Override
    public XSObjectList getParticles() {
        return new XSObjectListImpl(this.fParticles, this.fParticleCount);
    }

    @Override
    public short getType() {
        return 7;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.fParticleCount) {
            if (!this.fParticles[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int maxEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.maxEffectiveTotalRangeChoice();
        }
        return this.maxEffectiveTotalRangeAllSeq();
    }

    public int minEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.minEffectiveTotalRangeChoice();
        }
        return this.minEffectiveTotalRangeAllSeq();
    }

    public void reset() {
        this.fCompositor = (short)102;
        this.fParticles = null;
        this.fParticleCount = 0;
        this.fDescription = null;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fCompositor == 103) {
                stringBuffer.append("all(");
            } else {
                stringBuffer.append('(');
            }
            if (this.fParticleCount > 0) {
                stringBuffer.append(this.fParticles[0].toString());
            }
            int n = 1;
            while (true) {
                char c;
                if (n >= this.fParticleCount) {
                    stringBuffer.append(')');
                    this.fDescription = stringBuffer.toString();
                    break;
                }
                char c2 = this.fCompositor == 101 ? (c = '|') : (c = ',');
                stringBuffer.append(c2);
                stringBuffer.append(this.fParticles[n].toString());
                ++n;
            }
        }
        return this.fDescription;
    }
}

