/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.dom;

import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.xs.dom.ElementNSImpl;

public final class DOMNodePool {
    private static final int CHUNK_MASK = 255;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private AttrNSImpl[][] fAttrNode;
    private int fAttrNodeIndex = 0;
    private int fElementIndex = 0;
    private ElementNSImpl[][] fElements = new ElementNSImpl[4][];
    private TextImpl[][] fTextNode = new TextImpl[4][];
    private int fTextNodeIndex = 0;

    public DOMNodePool() {
        this.fAttrNode = new AttrNSImpl[4][];
    }

    private void ensureAttrsCapacity(int n) {
        AttrNSImpl[][] attrNSImplArray = this.fAttrNode;
        if (attrNSImplArray.length <= n) {
            this.fAttrNode = DOMNodePool.resize(attrNSImplArray, attrNSImplArray.length * 2);
        } else if (attrNSImplArray[n] != null) {
            return;
        }
        this.fAttrNode[n] = new AttrNSImpl[256];
    }

    private void ensureElementsCapacity(int n) {
        ElementNSImpl[][] elementNSImplArray = this.fElements;
        if (elementNSImplArray.length <= n) {
            this.fElements = DOMNodePool.resize(elementNSImplArray, elementNSImplArray.length * 2);
        } else if (elementNSImplArray[n] != null) {
            return;
        }
        this.fElements[n] = new ElementNSImpl[256];
    }

    private void ensureTextCapacity(int n) {
        TextImpl[][] textImplArray = this.fTextNode;
        if (textImplArray.length <= n) {
            this.fTextNode = DOMNodePool.resize(textImplArray, textImplArray.length * 2);
        } else if (textImplArray[n] != null) {
            return;
        }
        this.fTextNode[n] = new TextImpl[256];
    }

    private static AttrNSImpl[][] resize(AttrNSImpl[][] attrNSImplArray, int n) {
        AttrNSImpl[][] attrNSImplArray2 = new AttrNSImpl[n][];
        System.arraycopy(attrNSImplArray, 0, attrNSImplArray2, 0, attrNSImplArray.length);
        return attrNSImplArray2;
    }

    private static TextImpl[][] resize(TextImpl[][] textImplArray, int n) {
        TextImpl[][] textImplArray2 = new TextImpl[n][];
        System.arraycopy(textImplArray, 0, textImplArray2, 0, textImplArray.length);
        return textImplArray2;
    }

    private static ElementNSImpl[][] resize(ElementNSImpl[][] elementNSImplArray, int n) {
        ElementNSImpl[][] elementNSImplArray2 = new ElementNSImpl[n][];
        System.arraycopy(elementNSImplArray, 0, elementNSImplArray2, 0, elementNSImplArray.length);
        return elementNSImplArray2;
    }

    public final AttrNSImpl getAttrNode() {
        int n = this.fAttrNodeIndex;
        int n2 = n >> 8;
        this.ensureAttrsCapacity(n2);
        AttrNSImpl[][] attrNSImplArray = this.fAttrNode;
        if (attrNSImplArray[n2][n &= 0xFF] == null) {
            attrNSImplArray[n2][n] = new AttrNSImpl();
        }
        ++this.fAttrNodeIndex;
        return this.fAttrNode[n2][n];
    }

    public final ElementNSImpl getElementNode() {
        int n = this.fElementIndex;
        int n2 = n >> 8;
        this.ensureElementsCapacity(n2);
        ElementNSImpl[][] elementNSImplArray = this.fElements;
        if (elementNSImplArray[n2][n &= 0xFF] == null) {
            elementNSImplArray[n2][n] = new ElementNSImpl();
        }
        ++this.fElementIndex;
        return this.fElements[n2][n];
    }

    public final TextImpl getTextNode() {
        int n = this.fTextNodeIndex;
        int n2 = n >> 8;
        this.ensureTextCapacity(n2);
        TextImpl[][] textImplArray = this.fTextNode;
        if (textImplArray[n2][n &= 0xFF] == null) {
            textImplArray[n2][n] = new TextImpl();
        }
        ++this.fTextNodeIndex;
        return this.fTextNode[n2][n];
    }

    public void reset() {
        this.fElementIndex = 0;
        this.fTextNodeIndex = 0;
        this.fAttrNodeIndex = 0;
    }
}

