/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.dom;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.dom.DOMNodePool;
import org.apache.xerces.impl.xs.dom.DocumentImpl;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.NonValidatingConfiguration;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Element;

public class DOMParser
extends org.apache.xerces.parsers.DOMParser {
    protected static final String DEFER_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    protected static final String DOCUMENT_CLASS = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    public DocumentImpl fDocumentImpl;
    XMLErrorReporter fErrorReporter;
    protected XMLLocator fLocator;
    private DOMNodePool fNodePool;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DOMParser() {
        super(new NonValidatingConfiguration());
        try {
            this.setProperty(DOCUMENT_CLASS, "org.apache.xerces.impl.xs.dom.DocumentImpl");
            this.setFeature(DEFER_EXPANSION, false);
        }
        catch (Exception exception) {}
        this.fNodePool = new DOMNodePool();
    }

    @Override
    public void characters(XMLString object, Augmentations object2) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            for (int i = ((XMLString)object).offset; i < ((XMLString)object).offset + ((XMLString)object).length; ++i) {
                if (XMLChar.isSpace(((XMLString)object).ch[i])) continue;
                if (this.fErrorReporter == null) {
                    try {
                        this.fErrorReporter = (XMLErrorReporter)this.getProperty(ERROR_REPORTER);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                        object2 = new XSMessageFormatter();
                        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)object2);
                    }
                }
                object = new String(((XMLString)object).ch, i, ((XMLString)object).length + ((XMLString)object).offset - i);
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{object}, (short)1);
                break;
            }
        } else {
            super.characters((XMLString)object, (Augmentations)object2);
        }
    }

    @Override
    protected Element createElementNode(QName qName) {
        return this.fDocumentImpl.createElementNS(qName.uri, qName.rawname, qName.localpart, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        super.endElement(qName, augmentations);
        int n = this.fAnnotationDepth;
        int n2 = this.fDepth;
        if (n == n2) {
            this.fAnnotationDepth = -1;
        }
        this.fDepth = n2 - 1;
    }

    public void resetNodePool() {
        this.fNodePool.reset();
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String object, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, (String)object, namespaceContext, augmentations);
        this.fDocumentImpl = object = (DocumentImpl)((AbstractDOMParser)this).fDocumentImpl;
        ((DocumentImpl)object).fNodePool = this.fNodePool;
        this.fLocator = xMLLocator;
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        super.startElement(qName, xMLAttributes, augmentations);
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (qName.localpart == SchemaSymbols.ELT_APPINFO || qName.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }
}

