/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSIDCDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.util.StringListImpl;

public abstract class IdentityConstraint
implements XSIDCDefinition {
    protected String fElementName;
    protected int fFieldCount;
    protected Field[] fFields;
    protected String fIdentityConstraintName;
    protected String fNamespace;
    protected Selector fSelector;
    protected short type;

    protected IdentityConstraint(String string2, String string3, String string4) {
        this.fNamespace = string2;
        this.fIdentityConstraintName = string3;
        this.fElementName = string4;
    }

    static final Field[] resize(Field[] fieldArray, int n) {
        Field[] fieldArray2 = new Field[n];
        System.arraycopy(fieldArray, 0, fieldArray2, 0, fieldArray.length);
        return fieldArray2;
    }

    public void addField(Field field) {
        int n;
        Field[] fieldArray = this.fFields;
        if (fieldArray == null) {
            this.fFields = new Field[4];
        } else {
            n = this.fFieldCount;
            if (n == fieldArray.length) {
                this.fFields = IdentityConstraint.resize(fieldArray, n * 2);
            }
        }
        fieldArray = this.fFields;
        n = this.fFieldCount;
        this.fFieldCount = n + 1;
        fieldArray[n] = field;
    }

    public boolean equals(IdentityConstraint identityConstraint) {
        if (!this.fIdentityConstraintName.equals(identityConstraint.fIdentityConstraintName)) {
            return false;
        }
        if (!this.fSelector.toString().equals(identityConstraint.fSelector.toString())) {
            return false;
        }
        int n = this.fFieldCount == identityConstraint.fFieldCount ? 1 : 0;
        if (n == 0) {
            return false;
        }
        n = 0;
        while (n < this.fFieldCount) {
            if (!this.fFields[n].toString().equals(identityConstraint.fFields[n].toString())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public XSObjectList getAnnotations() {
        return null;
    }

    @Override
    public short getCategory() {
        return this.type;
    }

    public String getElementName() {
        return this.fElementName;
    }

    public Field getFieldAt(int n) {
        return this.fFields[n];
    }

    public int getFieldCount() {
        return this.fFieldCount;
    }

    @Override
    public StringList getFieldStrs() {
        String[] stringArray = new String[this.fFieldCount];
        int n = 0;
        int n2;
        while (n < (n2 = this.fFieldCount)) {
            stringArray[n] = this.fFields[n].toString();
            ++n;
        }
        return new StringListImpl(stringArray, n2);
    }

    public String getIdentityConstraintName() {
        return this.fIdentityConstraintName;
    }

    @Override
    public String getName() {
        return this.fIdentityConstraintName;
    }

    @Override
    public String getNamespace() {
        return this.fNamespace;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    @Override
    public XSIDCDefinition getRefKey() {
        return null;
    }

    public Selector getSelector() {
        return this.fSelector;
    }

    @Override
    public String getSelectorStr() {
        return this.fSelector.toString();
    }

    @Override
    public short getType() {
        return 10;
    }

    public void setSelector(Selector selector) {
        this.fSelector = selector;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2 = super.toString();
        int n = string2.lastIndexOf(36);
        if (n != -1) {
            return string2.substring(n + 1);
        }
        n = string2.lastIndexOf(46);
        if (n == -1) return string2;
        return string2.substring(n + 1);
    }
}

