/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

public class Selector {
    protected IdentityConstraint fIDConstraint;
    protected IdentityConstraint fIdentityConstraint;
    protected XPath fXPath;

    public Selector(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator fieldActivator, int n) {
        return new Matcher(this.fXPath, fieldActivator, n);
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIdentityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public class Matcher
    extends XPathMatcher {
        protected int fElementDepth;
        protected FieldActivator fFieldActivator;
        protected int fInitialDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xPath, FieldActivator fieldActivator, int n) {
            super(xPath);
            this.fFieldActivator = fieldActivator;
            this.fInitialDepth = n;
        }

        @Override
        public void endElement(QName qName, XSElementDecl xSElementDecl, String string2) {
            super.endElement(qName, xSElementDecl, string2);
            int n = this.fElementDepth;
            this.fElementDepth = n - 1;
            if (n == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
            }
        }

        public IdentityConstraint getIdentityConstraint() {
            return Selector.this.fIdentityConstraint;
        }

        public int getInitialDepth() {
            return this.fInitialDepth;
        }

        @Override
        public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
            super.startDocumentFragment(symbolTable);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        @Override
        public void startElement(QName qName, XMLAttributes xMLAttributes, XSElementDecl xSElementDecl) throws XNIException {
            super.startElement(qName, xMLAttributes, xSElementDecl);
            ++this.fElementDepth;
            int n = this.isMatched();
            if (this.fMatchedDepth == -1 && (n & 1) == 1 || (n & 5) == 5) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
                int n2 = Selector.this.fIdentityConstraint.getFieldCount();
                for (n = 0; n < n2; ++n) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(n);
                    this.fFieldActivator.activateField(field, this.fInitialDepth).startElement(qName, xMLAttributes, xSElementDecl);
                }
            }
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String string2, SymbolTable symbolTable, NamespaceContext namespaceContext) throws XPathException {
            super(XPath.normalize(string2), symbolTable, namespaceContext);
            int n = 0;
            while (true) {
                if (n >= this.fLocationPaths.length) {
                    return;
                }
                if (this.fLocationPaths[n].steps[this.fLocationPaths[n].steps.length - 1].axis.type == 2) break;
                ++n;
            }
            throw new XPathException("c-selector-xpath");
        }

        private static String normalize(String string2) {
            StringBuffer stringBuffer = new StringBuffer(string2.length() + 5);
            while (true) {
                int n;
                if (!string2.trim().startsWith("/") && !string2.trim().startsWith(".")) {
                    stringBuffer.append("./");
                }
                if ((n = string2.indexOf(124)) == -1) {
                    stringBuffer.append(string2);
                    return stringBuffer.toString();
                }
                stringBuffer.append(string2.substring(0, ++n));
                string2 = string2.substring(n, string2.length());
            }
        }
    }
}

