/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public class CMNodeFactory {
    private static final boolean DEBUG = false;
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final int MULTIPLICITY = 1;
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private XMLErrorReporter fErrorReporter;
    private SecurityManager fSecurityManager = null;
    private int maxNodeLimit;
    private int nodeCount = 0;

    public CMNode getCMBinOpNode(int n, CMNode cMNode, CMNode cMNode2) {
        this.nodeCountCheck();
        return new XSCMBinOp(n, cMNode, cMNode2);
    }

    public CMNode getCMLeafNode(int n, Object object, int n2, int n3) {
        this.nodeCountCheck();
        return new XSCMLeaf(n, object, n2, n3);
    }

    public CMNode getCMUniOpNode(int n, CMNode cMNode) {
        this.nodeCountCheck();
        return new XSCMUniOp(n, cMNode);
    }

    public void nodeCountCheck() {
        if (this.fSecurityManager != null) {
            int n = this.nodeCount;
            this.nodeCount = n + 1;
            int n2 = this.maxNodeLimit;
            if (n > n2) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "maxOccurLimit", new Object[]{new Integer(n2)}, (short)2);
                this.nodeCount = 0;
            }
        }
    }

    public void reset(XMLComponentManager object) {
        block3: {
            this.fErrorReporter = (XMLErrorReporter)object.getProperty(ERROR_REPORTER);
            this.fSecurityManager = object = (SecurityManager)object.getProperty(SECURITY_MANAGER);
            if (object == null) break block3;
            try {
                this.maxNodeLimit = ((SecurityManager)object).getMaxOccurNodeLimit() * 1;
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                this.fSecurityManager = null;
            }
        }
    }

    public void resetNodeCount() {
        this.nodeCount = 0;
    }

    public void setProperty(String object, Object object2) throws XMLConfigurationException {
        if (((String)object).startsWith("http://apache.org/xml/properties/")) {
            if (((String)(object = ((String)object).substring(33))).equals("security-manager")) {
                this.fSecurityManager = object = (SecurityManager)object2;
                int n = object != null ? ((SecurityManager)object).getMaxOccurNodeLimit() * 1 : 0;
                this.maxNodeLimit = n;
                return;
            }
            if (((String)object).equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object2;
            }
        }
    }
}

