/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Vector;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_CHILD = 1;
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private XSElementDecl[] fAllElements;
    private boolean fHasOptionalContent = false;
    private boolean[] fIsOptionalElement;
    private int fNumElements = 0;

    public XSAllCM(boolean bl, int n) {
        this.fHasOptionalContent = bl;
        this.fAllElements = new XSElementDecl[n];
        this.fIsOptionalElement = new boolean[n];
    }

    public void addElement(XSElementDecl xSElementDecl, boolean bl) {
        XSElementDecl[] xSElementDeclArray = this.fAllElements;
        int n = this.fNumElements;
        xSElementDeclArray[n] = xSElementDecl;
        this.fIsOptionalElement[n] = bl;
        this.fNumElements = n + 1;
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n;
        int n2 = 0;
        block0: while (true) {
            int n3;
            if (n2 >= this.fNumElements) {
                return false;
            }
            n = n3 = n2 + 1;
            while (true) {
                if (n >= this.fNumElements) {
                    n2 = n3;
                    continue block0;
                }
                XSElementDecl[] xSElementDeclArray = this.fAllElements;
                if (XSConstraints.overlapUPA(xSElementDeclArray[n2], xSElementDeclArray[n], substitutionGroupHandler)) break block0;
                ++n;
            }
            break;
        }
        throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[n2].toString(), this.fAllElements[n].toString()});
    }

    @Override
    public boolean endContentModel(int[] nArray) {
        int n = nArray[0];
        if (n != -1 && n != -2) {
            if (this.fHasOptionalContent && n == 0) {
                return true;
            }
            n = 0;
            while (true) {
                if (n >= this.fNumElements) {
                    return true;
                }
                if (!this.fIsOptionalElement[n] && nArray[n + 1] == 0) {
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        int n = 0;
        while (n < this.fNumElements && (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[n])) == null) {
            ++n;
        }
        return xSElementDecl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (nArray[0] < 0) {
            nArray[0] = -2;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = 1;
        int n = 0;
        while (true) {
            XSElementDecl xSElementDecl;
            if (n >= this.fNumElements) {
                nArray[0] = -1;
                return this.findMatchingDecl(qName, substitutionGroupHandler);
            }
            int n2 = n + 1;
            if (nArray[n2] == 0 && (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[n])) != null) {
                nArray[n2] = 1;
                return xSElementDecl;
            }
            n = n2;
        }
    }

    @Override
    public int[] startContentModel() {
        int[] nArray = new int[this.fNumElements + 1];
        int n = 0;
        while (n <= this.fNumElements) {
            nArray[n] = 0;
            ++n;
        }
        return nArray;
    }

    @Override
    public Vector whatCanGoHere(int[] nArray) {
        Vector<XSElementDecl> vector = new Vector<XSElementDecl>();
        int n = 0;
        while (n < this.fNumElements) {
            int n2 = n + 1;
            if (nArray[n2] == 0) {
                vector.addElement(this.fAllElements[n]);
            }
            n = n2;
        }
        return vector;
    }
}

