/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;

public class XSCMLeaf
extends CMNode {
    private Object fLeaf = null;
    private int fParticleId = -1;
    private int fPosition = -1;

    public XSCMLeaf(int n, Object object, int n2, int n3) {
        super(n);
        this.fLeaf = object;
        this.fParticleId = n2;
        this.fPosition = n3;
    }

    @Override
    protected void calcFirstPos(CMStateSet cMStateSet) {
        int n = this.fPosition;
        if (n == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(n);
        }
    }

    @Override
    protected void calcLastPos(CMStateSet cMStateSet) {
        int n = this.fPosition;
        if (n == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(n);
        }
    }

    final Object getLeaf() {
        return this.fLeaf;
    }

    final int getParticleId() {
        return this.fParticleId;
    }

    final int getPosition() {
        return this.fPosition;
    }

    @Override
    public boolean isNullable() {
        boolean bl = this.fPosition == -1;
        return bl;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.fLeaf.toString());
        if (this.fPosition >= 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(" (Pos:");
            stringBuffer2.append(new Integer(this.fPosition).toString());
            stringBuffer2.append(")");
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }
}

