/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    XMLParserConfiguration config;
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;
    protected XMLLocator fLocator;
    SchemaDOM schemaDOM = new SchemaDOM();

    public SchemaDOMParser(XMLParserConfiguration xMLParserConfiguration) {
        this.config = xMLParserConfiguration;
    }

    @Override
    public void characters(XMLString object, Augmentations object2) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            for (int i = ((XMLString)object).offset; i < ((XMLString)object).offset + ((XMLString)object).length; ++i) {
                if (XMLChar.isSpace(((XMLString)object).ch[i])) continue;
                if (this.fErrorReporter == null) {
                    try {
                        this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                        object2 = new XSMessageFormatter();
                        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)object2);
                    }
                }
                object = new String(((XMLString)object).ch, i, ((XMLString)object).length + ((XMLString)object).offset - i);
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{object}, (short)1);
                break;
            }
        } else {
            this.schemaDOM.characters((XMLString)object, (Augmentations)object2);
        }
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.schemaDOM.emptyElement(qName, xMLAttributes, augmentations, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    @Override
    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.schemaDOM.endElement(qName, augmentations);
        int n = this.fAnnotationDepth;
        int n2 = this.fDepth;
        if (n == n2) {
            this.fAnnotationDepth = -1;
        }
        this.fDepth = n2 - 1;
    }

    public Document getDocument() {
        return this.schemaDOM;
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fLocator = xMLLocator;
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.schemaDOM.startElement(qName, xMLAttributes, augmentations, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (qName.localpart == SchemaSymbols.ELT_APPINFO || qName.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }
}

