/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractIDConstraintTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDKeyrefTraverser
extends XSDAbstractIDConstraintTraverser {
    public XSDKeyrefTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    /*
     * Enabled aggressive block sorting
     */
    void traverse(Element element, XSElementDecl xSElementDecl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string2 = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        if (string2 == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_NAME}, element);
        } else {
            QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_REFER];
            if (qName == null) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_REFER}, element);
            } else {
                IdentityConstraint identityConstraint = null;
                IdentityConstraint identityConstraint2 = (IdentityConstraint)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 5, qName, element);
                IdentityConstraint identityConstraint3 = identityConstraint;
                if (identityConstraint2 != null) {
                    if (identityConstraint2.getCategory() != 1 && identityConstraint2.getCategory() != 3) {
                        this.reportSchemaError("src-resolve", new Object[]{qName.rawname, "identity constraint key/unique"}, element);
                        identityConstraint3 = identityConstraint;
                    } else {
                        identityConstraint3 = (UniqueOrKey)identityConstraint2;
                    }
                }
                if (identityConstraint3 != null) {
                    identityConstraint = new KeyRef(xSDocumentInfo.fTargetNamespace, string2, xSElementDecl.fName, (UniqueOrKey)identityConstraint3);
                    this.traverseIdentityConstraint(identityConstraint, element, xSDocumentInfo, objectArray);
                    if (identityConstraint3.getFieldCount() != identityConstraint.getFieldCount()) {
                        this.reportSchemaError("c-props-correct.2", new Object[]{string2, identityConstraint3.getIdentityConstraintName()}, element);
                    } else {
                        schemaGrammar.addIDConstraintDecl(xSElementDecl, identityConstraint);
                    }
                }
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
    }
}

