/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.w3c.dom.Document;

class XSDocumentInfo {
    protected Stack SchemaNamespaceSupportStack = new Stack();
    protected boolean fAreLocalAttributesQualified;
    protected boolean fAreLocalElementsQualified;
    protected short fBlockDefault;
    protected short fFinalDefault;
    Vector fImportedNS = new Vector();
    protected boolean fIsChameleonSchema;
    protected SchemaNamespaceSupport fNamespaceSupport;
    protected SchemaNamespaceSupport fNamespaceSupportRoot;
    private Vector fReportedTNS = null;
    protected Document fSchemaDoc;
    SymbolTable fSymbolTable = null;
    protected String fTargetNamespace;
    protected ValidationState fValidationContext = new ValidationState();

    XSDocumentInfo(Document object, XSAttributeChecker xSAttributeChecker, SymbolTable symbolTable) throws XMLSchemaException {
        this.fSchemaDoc = object;
        Object[] objectArray = new SchemaNamespaceSupport();
        this.fNamespaceSupport = objectArray;
        objectArray.reset();
        boolean bl = false;
        this.fIsChameleonSchema = false;
        this.fSymbolTable = symbolTable;
        if (object != null) {
            objectArray = xSAttributeChecker.checkAttributes(DOMUtil.getRoot((Document)object), true, this);
            if (objectArray != null) {
                boolean bl2 = ((XInt)objectArray[XSAttributeChecker.ATTIDX_AFORMDEFAULT]).intValue() == 1;
                this.fAreLocalAttributesQualified = bl2;
                bl2 = bl;
                if (((XInt)objectArray[XSAttributeChecker.ATTIDX_EFORMDEFAULT]).intValue() == 1) {
                    bl2 = true;
                }
                this.fAreLocalElementsQualified = bl2;
                this.fBlockDefault = ((XInt)objectArray[XSAttributeChecker.ATTIDX_BLOCKDEFAULT]).shortValue();
                this.fFinalDefault = ((XInt)objectArray[XSAttributeChecker.ATTIDX_FINALDEFAULT]).shortValue();
                this.fTargetNamespace = object = (String)objectArray[XSAttributeChecker.ATTIDX_TARGETNAMESPACE];
                if (object != null) {
                    this.fTargetNamespace = symbolTable.addSymbol((String)object);
                }
                this.fNamespaceSupportRoot = new SchemaNamespaceSupport(this.fNamespaceSupport);
                this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
                this.fValidationContext.setSymbolTable(symbolTable);
                xSAttributeChecker.returnAttrArray(objectArray, null);
            } else {
                throw new XMLSchemaException(null, null);
            }
        }
    }

    public void addAllowedNS(String string2) {
        Vector vector = this.fImportedNS;
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        vector.addElement(string3);
    }

    void backupNSSupport(SchemaNamespaceSupport schemaNamespaceSupport) {
        this.SchemaNamespaceSupportStack.push(this.fNamespaceSupport);
        SchemaNamespaceSupport schemaNamespaceSupport2 = schemaNamespaceSupport;
        if (schemaNamespaceSupport == null) {
            schemaNamespaceSupport2 = this.fNamespaceSupportRoot;
        }
        this.fNamespaceSupport = schemaNamespaceSupport = new SchemaNamespaceSupport(schemaNamespaceSupport2);
        this.fValidationContext.setNamespaceSupport(schemaNamespaceSupport);
    }

    public boolean isAllowedNS(String string2) {
        Vector vector = this.fImportedNS;
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        return vector.contains(string3);
    }

    final boolean needReportTNSError(String string2) {
        Vector vector = this.fReportedTNS;
        if (vector == null) {
            this.fReportedTNS = new Vector();
        } else if (vector.contains(string2)) {
            return false;
        }
        this.fReportedTNS.addElement(string2);
        return true;
    }

    void restoreNSSupport() {
        SchemaNamespaceSupport schemaNamespaceSupport;
        this.fNamespaceSupport = schemaNamespaceSupport = (SchemaNamespaceSupport)this.SchemaNamespaceSupportStack.pop();
        this.fValidationContext.setNamespaceSupport(schemaNamespaceSupport);
    }

    public String toString() {
        CharSequence charSequence;
        if (this.fTargetNamespace == null) {
            charSequence = "no targetNamspace";
        } else {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("targetNamespace is ");
            ((StringBuffer)charSequence).append(this.fTargetNamespace);
            charSequence = ((StringBuffer)charSequence).toString();
        }
        return charSequence;
    }
}

