/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder
implements JAXPConstants {
    private DOMParser domParser = new DOMParser();
    private ErrorHandler eh = null;
    private EntityResolver er = null;

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (documentBuilderFactory.isValidating()) {
            this.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.domParser.setFeature("http://xml.org/sax/features/validation", documentBuilderFactory.isValidating());
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", documentBuilderFactory.isNamespaceAware());
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", documentBuilderFactory.isIgnoringElementContentWhitespace() ^ true);
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", documentBuilderFactory.isExpandEntityReferences() ^ true);
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", documentBuilderFactory.isIgnoringComments() ^ true);
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", documentBuilderFactory.isCoalescing() ^ true);
        this.setDocumentBuilderFactoryAttributes(hashtable);
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object v = hashtable.get(string2);
            if (v instanceof Boolean) {
                this.domParser.setFeature(string2, (Boolean)v);
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string2)) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(v)) continue;
                this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                continue;
            }
            this.domParser.setProperty(string2, v);
        }
        return;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            boolean bl = this.domParser.getFeature("http://xml.org/sax/features/namespaces");
            return bl;
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    @Override
    public boolean isValidating() {
        try {
            boolean bl = this.domParser.getFeature("http://xml.org/sax/features/validation");
            return bl;
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    @Override
    public Document newDocument() {
        return new DocumentImpl();
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource != null) {
            Object object = this.er;
            if (object != null) {
                this.domParser.setEntityResolver((EntityResolver)object);
            }
            if ((object = this.eh) != null) {
                this.domParser.setErrorHandler((ErrorHandler)object);
            }
            this.domParser.parse(inputSource);
            return this.domParser.getDocument();
        }
        throw new IllegalArgumentException("InputSource cannot be null");
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        ErrorHandler errorHandler2 = errorHandler;
        if (errorHandler == null) {
            errorHandler2 = new DefaultHandler();
        }
        this.eh = errorHandler2;
    }
}

