/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserImpl
extends javax.xml.parsers.SAXParser
implements JAXPConstants {
    private String schemaLanguage = null;
    private XMLReader xmlReader = new SAXParser();

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        if (sAXParserFactory.isValidating()) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", sAXParserFactory.isValidating());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", sAXParserFactory.isNamespaceAware());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", sAXParserFactory.isNamespaceAware() ^ true);
        this.setFeatures(hashtable);
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string2);
                this.xmlReader.setFeature(string2, bl);
            }
        }
    }

    @Override
    public Parser getParser() throws SAXException {
        return (Parser)((Object)this.xmlReader);
    }

    @Override
    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string2)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(string2);
    }

    @Override
    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            boolean bl = this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
            return bl;
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    @Override
    public boolean isValidating() {
        try {
            boolean bl = this.xmlReader.getFeature("http://xml.org/sax/features/validation");
            return bl;
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string2)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(object)) {
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                return;
            } else {
                if (object != null) throw new SAXNotSupportedException("Unsupported schema language");
                this.schemaLanguage = null;
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            return;
        } else {
            this.xmlReader.setProperty(string2, object);
        }
    }
}

