/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public abstract class BasicParserConfiguration
extends ParserConfigurationSettings
implements XMLParserConfiguration {
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected Vector fComponents = new Vector();
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fLastComponent;
    protected Locale fLocale;
    protected SymbolTable fSymbolTable;

    protected BasicParserConfiguration() {
        this(null, null);
    }

    protected BasicParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    protected BasicParserConfiguration(SymbolTable symbolTable, XMLComponentManager object) {
        super((XMLComponentManager)object);
        this.fRecognizedFeatures = new Vector();
        this.fRecognizedProperties = new Vector();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        this.addRecognizedFeatures(new String[]{VALIDATION, NAMESPACES, EXTERNAL_GENERAL_ENTITIES, EXTERNAL_PARAMETER_ENTITIES});
        this.setFeature(VALIDATION, false);
        this.setFeature(NAMESPACES, true);
        this.setFeature(EXTERNAL_GENERAL_ENTITIES, true);
        this.setFeature(EXTERNAL_PARAMETER_ENTITIES, true);
        this.addRecognizedProperties(new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER});
        object = symbolTable;
        if (symbolTable == null) {
            object = new SymbolTable();
        }
        this.fSymbolTable = object;
        this.setProperty(SYMBOL_TABLE, object);
    }

    protected void addComponent(XMLComponent xMLComponent) {
        Object object;
        int n;
        if (this.fComponents.contains(xMLComponent)) {
            return;
        }
        this.fComponents.addElement(xMLComponent);
        Object object2 = xMLComponent.getRecognizedFeatures();
        this.addRecognizedFeatures((String[])object2);
        String[] stringArray = xMLComponent.getRecognizedProperties();
        this.addRecognizedProperties(stringArray);
        int n2 = 0;
        if (object2 != null) {
            for (n = 0; n < ((String[])object2).length; ++n) {
                String string2 = object2[n];
                object = xMLComponent.getFeatureDefault(string2);
                if (object == null) continue;
                this.setFeature(string2, (Boolean)object);
            }
        }
        if (stringArray != null) {
            for (n = n2; n < stringArray.length; ++n) {
                object2 = stringArray[n];
                object = xMLComponent.getPropertyDefault((String)object2);
                if (object == null) continue;
                this.setProperty((String)object2, object);
            }
        }
    }

    @Override
    protected void checkProperty(String string2) throws XMLConfigurationException {
        if (string2.startsWith("http://xml.org/sax/properties/") && string2.substring(30).equals("xml-string")) {
            throw new XMLConfigurationException(1, string2);
        }
        super.checkProperty(string2);
    }

    @Override
    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    @Override
    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public abstract void parse(XMLInputSource var1) throws XNIException, IOException;

    protected void reset() throws XNIException {
        int n = this.fComponents.size();
        int n2 = 0;
        while (n2 < n) {
            ((XMLComponent)this.fComponents.elementAt(n2)).reset(this);
            ++n2;
        }
        return;
    }

    @Override
    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    @Override
    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
        XMLDocumentSource xMLDocumentSource = this.fLastComponent;
        if (xMLDocumentSource != null) {
            xMLDocumentSource.setDocumentHandler(xMLDocumentHandler);
        }
    }

    @Override
    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fProperties.put(ENTITY_RESOLVER, xMLEntityResolver);
    }

    @Override
    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fProperties.put(ERROR_HANDLER, xMLErrorHandler);
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        int n = this.fComponents.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                super.setFeature(string2, bl);
                return;
            }
            ((XMLComponent)this.fComponents.elementAt(n2)).setFeature(string2, bl);
            ++n2;
        }
    }

    @Override
    public void setLocale(Locale locale) throws XNIException {
        this.fLocale = locale;
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        int n = this.fComponents.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                super.setProperty(string2, object);
                return;
            }
            ((XMLComponent)this.fComponents.elementAt(n2)).setProperty(string2, object);
            ++n2;
        }
    }
}

