/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.parsers.XMLGrammarCachingConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.ls.DOMInputSource;

public class DOMASBuilderImpl
extends DOMBuilderImpl
implements DOMASBuilder {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected ASModelImpl fAbstractSchema;
    protected XSGrammarBucket fGrammarBucket;

    public DOMASBuilderImpl() {
        super(new XMLGrammarCachingConfiguration());
    }

    public DOMASBuilderImpl(XMLGrammarCachingConfiguration xMLGrammarCachingConfiguration) {
        super(xMLGrammarCachingConfiguration);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new XMLGrammarCachingConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        super(new XMLGrammarCachingConfiguration(symbolTable, xMLGrammarPool));
    }

    private void addGrammars(ASModelImpl aSModelImpl, XSGrammarBucket schemaGrammarArray) {
        schemaGrammarArray = schemaGrammarArray.getGrammars();
        int n = 0;
        while (n < schemaGrammarArray.length) {
            ASModelImpl aSModelImpl2 = new ASModelImpl();
            aSModelImpl2.setGrammar(schemaGrammarArray[n]);
            aSModelImpl.addASModel(aSModelImpl2);
            ++n;
        }
        return;
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        ASModelImpl aSModelImpl = this.fAbstractSchema;
        if (aSModelImpl != null) {
            this.initGrammarBucketRecurse(aSModelImpl);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl aSModelImpl) {
        if (aSModelImpl.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(aSModelImpl.getGrammar());
        }
        int n = 0;
        while (n < aSModelImpl.getInternalASModels().size()) {
            this.initGrammarBucketRecurse((ASModelImpl)aSModelImpl.getInternalASModels().elementAt(n));
            ++n;
        }
        return;
    }

    private void initGrammarPool(ASModelImpl object, XMLGrammarPool xMLGrammarPool) {
        Grammar[] grammarArray = new Grammar[1];
        SchemaGrammar schemaGrammar = ((ASModelImpl)object).getGrammar();
        int n = 0;
        grammarArray[0] = schemaGrammar;
        if (schemaGrammar != null) {
            xMLGrammarPool.cacheGrammars(grammarArray[0].getGrammarDescription().getGrammarType(), grammarArray);
        }
        object = ((ASModelImpl)object).getInternalASModels();
        while (n < ((Vector)object).size()) {
            this.initGrammarPool((ASModelImpl)((Vector)object).elementAt(n), xMLGrammarPool);
            ++n;
        }
        return;
    }

    @Override
    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    ASModel parseASInputSource(XMLInputSource object) throws Exception {
        if (this.fGrammarBucket == null) {
            this.fGrammarBucket = new XSGrammarBucket();
        }
        this.initGrammarBucket();
        XMLGrammarCachingConfiguration xMLGrammarCachingConfiguration = (XMLGrammarCachingConfiguration)this.fConfiguration;
        xMLGrammarCachingConfiguration.lockGrammarPool();
        SchemaGrammar schemaGrammar = xMLGrammarCachingConfiguration.parseXMLSchema((XMLInputSource)object);
        xMLGrammarCachingConfiguration.unlockGrammarPool();
        object = null;
        if (schemaGrammar != null) {
            object = new ASModelImpl();
            this.fGrammarBucket.putGrammar(schemaGrammar, true);
            this.addGrammars((ASModelImpl)object, this.fGrammarBucket);
        }
        return object;
    }

    @Override
    public ASModel parseASInputSource(DOMInputSource object) throws DOMASException, Exception {
        object = this.dom2xmlInputSource((DOMInputSource)object);
        try {
            object = this.parseASInputSource((XMLInputSource)object);
            return object;
        }
        catch (XNIException xNIException) {
            throw xNIException.getException();
        }
    }

    @Override
    public ASModel parseASURI(String string2) throws DOMASException, Exception {
        return this.parseASInputSource(new XMLInputSource(null, string2, null));
    }

    @Override
    public void setAbstractSchema(ASModel object) {
        Object object2;
        this.fAbstractSchema = (ASModelImpl)object;
        object = object2 = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        if (object2 == null) {
            object = new XMLGrammarPoolImpl();
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", object);
        }
        if ((object2 = this.fAbstractSchema) != null) {
            this.initGrammarPool((ASModelImpl)object2, (XMLGrammarPool)object);
        }
    }
}

