/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import java.util.Stack;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMBuilderFilter;
import org.w3c.dom.ls.DOMEntityResolver;
import org.w3c.dom.ls.DOMInputSource;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder,
DOMConfiguration {
    protected static final boolean DEBUG = false;
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected boolean fBusy = false;
    protected String fSchemaType = null;

    public DOMBuilderImpl(String string2, String string3) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", string2));
        if (string3 != null) {
            if (string3.equals(Constants.NS_DTD)) {
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (string3.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XML11Configuration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XML11Configuration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPool);
    }

    public DOMBuilderImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        this.fConfiguration.addRecognizedFeatures(new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-mediatypes-only", "certified"});
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("cdata-sections", true);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("infoset", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("supported-mediatypes-only", false);
        this.fConfiguration.setFeature("certified", true);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    @Override
    public boolean canSetParameter(String string2, Object object) {
        if (object != Boolean.TRUE && object != Boolean.FALSE) {
            if (string2.equals("error-handler")) {
                return object instanceof DOMErrorHandler;
            }
            if (string2.equals("entity-resolver")) {
                return object instanceof DOMEntityResolver;
            }
            if (string2.equals("schema-type")) {
                return object instanceof String && (object.equals(Constants.NS_XMLSCHEMA) || object.equals(Constants.NS_DTD));
            }
            if (string2.equals("schema-location")) {
                return object instanceof String;
            }
            return string2.equals("http://apache.org/xml/properties/dom/document-class-name");
        }
        boolean bl = object == Boolean.TRUE;
        if (!(string2.equals("infoset") || string2.equals("supported-mediatypes-only") || string2.equals("canonical-form"))) {
            if (!string2.equals("cdata-sections") && !string2.equals("namespace-declarations")) {
                if (!(string2.equals("charset-overrides-xml-encoding") || string2.equals("comments") || string2.equals("datatype-normalization") || string2.equals("entities") || string2.equals("namespaces") || string2.equals("validate") || string2.equals("validate-if-schema") || string2.equals("whitespace-in-element-content"))) {
                    try {
                        this.fConfiguration.getFeature(string2);
                        return true;
                    }
                    catch (XMLConfigurationException xMLConfigurationException) {
                        return false;
                    }
                }
                return true;
            }
            return bl;
        }
        return bl ^ true;
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource object) {
        object = object.getStringData() != null ? new XMLInputSource(object.getPublicId(), object.getSystemId(), object.getBaseURI(), new StringReader(object.getStringData()), "UTF-16") : (object.getCharacterStream() != null ? new XMLInputSource(object.getPublicId(), object.getSystemId(), object.getBaseURI(), object.getCharacterStream(), "UTF-16") : (object.getByteStream() != null ? new XMLInputSource(object.getPublicId(), object.getSystemId(), object.getBaseURI(), object.getByteStream(), object.getEncoding()) : new XMLInputSource(object.getPublicId(), object.getSystemId(), object.getBaseURI())));
        return object;
    }

    @Override
    public boolean getAsync() {
        return false;
    }

    @Override
    public boolean getBusy() {
        return this.fBusy;
    }

    @Override
    public DOMConfiguration getConfig() {
        return this;
    }

    @Override
    public DOMBuilderFilter getFilter() {
        return this.fDOMFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getParameter(String object) throws DOMException {
        if (((String)object).equals("comments")) {
            if (!this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments")) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("datatype-normalization")) {
            if (!this.fConfiguration.getFeature(NORMALIZE_DATA)) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("entities")) {
            if (!this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes")) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("namespaces")) {
            if (!this.fConfiguration.getFeature(NAMESPACES)) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("validate")) {
            if (!this.fConfiguration.getFeature(VALIDATION_FEATURE)) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("validate-if-schema")) {
            if (!this.fConfiguration.getFeature(DYNAMIC_VALIDATION)) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (((String)object).equals("whitespace-in-element-content")) {
            if (!this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace")) return Boolean.FALSE;
            return Boolean.TRUE;
        }
        if (!(((String)object).equals("namespace-declarations") || ((String)object).equals("cdata-sections") || ((String)object).equals("canonical-form") || ((String)object).equals("supported-mediatypes-only") || ((String)object).equals("infoset") || ((String)object).equals("charset-overrides-xml-encoding"))) {
            if (((String)object).equals("error-handler")) {
                if (this.fErrorHandler == null) return null;
                return this.fErrorHandler.getErrorHandler();
            }
            if (((String)object).equals("entity-resolver")) {
                try {
                    object = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                    if (object == null) return null;
                    if (!(object instanceof DOMEntityResolverWrapper)) return null;
                    return ((DOMEntityResolverWrapper)object).getEntityResolver();
                }
                catch (XMLConfigurationException xMLConfigurationException) {
                    return null;
                }
            }
            if (((String)object).equals("schema-type")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            }
            if (((String)object).equals("schema-location")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaSource");
            }
            if (((String)object).equals(SYMBOL_TABLE)) {
                return this.fConfiguration.getProperty(SYMBOL_TABLE);
            }
            if (((String)object).equals("http://apache.org/xml/properties/dom/document-class-name")) {
                return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
            }
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
        }
        if (!this.fConfiguration.getFeature((String)object)) return Boolean.FALSE;
        return Boolean.TRUE;
    }

    @Override
    public Document parse(DOMInputSource object) {
        block2: {
            object = this.dom2xmlInputSource((DOMInputSource)object);
            this.fBusy = true;
            try {
                this.parse((XMLInputSource)object);
                this.fBusy = false;
            }
            catch (Exception exception) {
                this.fBusy = false;
                if (this.fErrorHandler == null) break block2;
                object = new DOMErrorImpl();
                ((DOMErrorImpl)object).fException = exception;
                ((DOMErrorImpl)object).fMessage = exception.getMessage();
                ((DOMErrorImpl)object).fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError((DOMError)object);
            }
        }
        return this.getDocument();
    }

    @Override
    public Document parseURI(String object) {
        block2: {
            object = new XMLInputSource(null, (String)object, null);
            this.fBusy = true;
            try {
                this.parse((XMLInputSource)object);
                this.fBusy = false;
            }
            catch (Exception exception) {
                this.fBusy = false;
                if (this.fErrorHandler == null) break block2;
                object = new DOMErrorImpl();
                ((DOMErrorImpl)object).fException = exception;
                ((DOMErrorImpl)object).fMessage = exception.getMessage();
                ((DOMErrorImpl)object).fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError((DOMError)object);
            }
        }
        return this.getDocument();
    }

    @Override
    public Node parseWithContext(DOMInputSource dOMInputSource, Node node, short s) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fRejectedElement.clear();
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    @Override
    public void setFilter(DOMBuilderFilter dOMBuilderFilter) {
        this.fDOMFilter = dOMBuilderFilter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setParameter(String object, Object object2) throws DOMException {
        if (object2 != Boolean.TRUE && object2 != Boolean.FALSE) {
            if (((String)object).equals("error-handler")) {
                if (!(object2 instanceof DOMErrorHandler)) {
                    throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                }
                this.fErrorHandler = object = new DOMErrorHandlerWrapper((DOMErrorHandler)object2);
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                return;
            }
            if (((String)object).equals("entity-resolver")) {
                if (!(object2 instanceof DOMEntityResolver)) {
                    throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                }
                object = this.fConfiguration;
                DOMEntityResolverWrapper dOMEntityResolverWrapper = new DOMEntityResolverWrapper((DOMEntityResolver)object2);
                object.setProperty("http://apache.org/xml/properties/internal/entity-resolver", dOMEntityResolverWrapper);
                return;
            }
            if (((String)object).equals("schema-location")) {
                if (!(object2 instanceof String)) {
                    throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                }
                if (this.fSchemaType == Constants.NS_XMLSCHEMA) {
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", object2);
                    return;
                }
                object2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object});
                object = new DOMException(9, (String)object2);
                throw object;
            }
            if (((String)object).equals("schema-type")) {
                if (!(object2 instanceof String)) {
                    throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                }
                boolean bl = object2.equals(Constants.NS_XMLSCHEMA);
                if (bl) {
                    this.fConfiguration.setFeature(XMLSCHEMA, true);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                    object = Constants.NS_XMLSCHEMA;
                } else {
                    if (!object2.equals(Constants.NS_DTD)) return;
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                    object = Constants.NS_DTD;
                }
                this.fSchemaType = object;
                return;
            }
            if (((String)object).equals("http://apache.org/xml/properties/dom/document-class-name")) {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", object2);
                return;
            }
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
        }
        boolean bl = object2 == Boolean.TRUE;
        try {
            block33: {
                block35: {
                    block36: {
                        String string2;
                        block30: {
                            block34: {
                                block32: {
                                    block31: {
                                        block29: {
                                            if (!((String)object).equals("comments")) break block29;
                                            object2 = this.fConfiguration;
                                            string2 = "http://apache.org/xml/features/include-comments";
                                            break block30;
                                        }
                                        if (!((String)object).equals("datatype-normalization")) break block31;
                                        object2 = this.fConfiguration;
                                        string2 = NORMALIZE_DATA;
                                        break block30;
                                    }
                                    if (!((String)object).equals("entities")) break block32;
                                    object2 = this.fConfiguration;
                                    string2 = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
                                    break block30;
                                }
                                if (((String)object).equals("infoset") || ((String)object).equals("supported-mediatypes-only") || ((String)object).equals("canonical-form")) break block33;
                                if (!((String)object).equals("namespaces")) break block34;
                                object2 = this.fConfiguration;
                                string2 = NAMESPACES;
                                break block30;
                            }
                            if (((String)object).equals("cdata-sections") || ((String)object).equals("namespace-declarations")) break block35;
                            boolean bl2 = ((String)object).equals("validate");
                            if (bl2) {
                                this.fConfiguration.setFeature(VALIDATION_FEATURE, bl);
                                if (this.fSchemaType != Constants.NS_DTD) {
                                    this.fConfiguration.setFeature(XMLSCHEMA, bl);
                                }
                                if (!bl) return;
                                this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                                return;
                            }
                            if (((String)object).equals("validate-if-schema")) {
                                this.fConfiguration.setFeature(DYNAMIC_VALIDATION, bl);
                                if (!bl) return;
                                this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                                return;
                            }
                            if (!((String)object).equals("whitespace-in-element-content")) break block36;
                            object2 = this.fConfiguration;
                            string2 = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
                        }
                        object2.setFeature(string2, bl);
                        return;
                    }
                    if (((String)object).equals("psvi")) {
                        this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                        this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.PSVIDocumentImpl");
                        return;
                    }
                    this.fConfiguration.setFeature((String)object, bl);
                    return;
                }
                if (bl) {
                    return;
                }
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object});
                object2 = new DOMException(9, string3);
                throw object2;
            }
            if (!bl) {
                return;
            }
            object2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object});
            DOMException dOMException = new DOMException(9, (String)object2);
            throw dOMException;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            return;
        }
    }
}

