/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DOMParser
extends AbstractDOMParser {
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/grammar-pool"};
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";

    public DOMParser() {
        this(null, null);
    }

    public DOMParser(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    public DOMParser(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        super((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XML11Configuration"));
        this.fConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        if (symbolTable != null) {
            this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        }
        if (xMLGrammarPool != null) {
            this.fConfiguration.setProperty(XMLGRAMMAR_POOL, xMLGrammarPool);
        }
    }

    public DOMParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EntityResolver getEntityResolver() {
        EntityResolver entityResolver;
        XMLEntityResolver xMLEntityResolver;
        EntityResolver entityResolver2 = null;
        try {
            xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            entityResolver = entityResolver2;
            if (xMLEntityResolver == null) return entityResolver;
            entityResolver = entityResolver2;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            return entityResolver2;
        }
        if (!(xMLEntityResolver instanceof EntityResolverWrapper)) return entityResolver;
        return ((EntityResolverWrapper)xMLEntityResolver).getEntityResolver();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler;
        XMLErrorHandler xMLErrorHandler;
        ErrorHandler errorHandler2 = null;
        try {
            xMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            errorHandler = errorHandler2;
            if (xMLErrorHandler == null) return errorHandler;
            errorHandler = errorHandler2;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            return errorHandler2;
        }
        if (!(xMLErrorHandler instanceof ErrorHandlerWrapper)) return errorHandler;
        return ((ErrorHandlerWrapper)xMLErrorHandler).getErrorHandler();
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            boolean bl = this.fConfiguration.getFeature(string2);
            return bl;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string3);
            }
            throw new SAXNotSupportedException(string3);
        }
    }

    public Object getProperty(String object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (((String)object).equals("http://apache.org/xml/properties/dom/current-element-node")) {
            boolean bl;
            boolean bl2 = false;
            try {
                bl = this.getFeature("http://apache.org/xml/features/dom/defer-node-expansion");
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                bl = bl2;
            }
            if (!bl) {
                object = this.fCurrentNode != null && this.fCurrentNode.getNodeType() == 1 ? this.fCurrentNode : null;
                return object;
            }
            throw new SAXNotSupportedException("Current element node cannot be queried when node expansion is deferred.");
        }
        try {
            object = this.fConfiguration.getProperty((String)object);
            return object;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            object = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException((String)object);
            }
            throw new SAXNotSupportedException((String)object);
        }
    }

    public void parse(String object) throws SAXException, IOException {
        object = new XMLInputSource(null, (String)object, null);
        try {
            this.parse((XMLInputSource)object);
            return;
        }
        catch (XNIException xNIException) {
            xNIException.printStackTrace();
            Exception exception = xNIException.getException();
            if (exception != null) {
                if (!(exception instanceof SAXException)) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new SAXException(exception);
                }
                throw (SAXException)exception;
            }
            throw new SAXException(xNIException.getMessage());
        }
        catch (XMLParseException xMLParseException) {
            Object object2 = xMLParseException.getException();
            if (object2 != null) {
                if (!(object2 instanceof SAXException)) {
                    if (object2 instanceof IOException) {
                        throw (IOException)object2;
                    }
                    throw new SAXException((Exception)object2);
                }
                throw (SAXException)object2;
            }
            object2 = new LocatorImpl();
            ((LocatorImpl)object2).setPublicId(xMLParseException.getPublicId());
            ((LocatorImpl)object2).setSystemId(xMLParseException.getExpandedSystemId());
            ((LocatorImpl)object2).setLineNumber(xMLParseException.getLineNumber());
            ((LocatorImpl)object2).setColumnNumber(xMLParseException.getColumnNumber());
            throw new SAXParseException(xMLParseException.getMessage(), (Locator)object2);
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
            xMLInputSource.setByteStream(inputSource.getByteStream());
            xMLInputSource.setCharacterStream(inputSource.getCharacterStream());
            xMLInputSource.setEncoding(inputSource.getEncoding());
            this.parse(xMLInputSource);
            return;
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception != null) {
                if (!(exception instanceof SAXException)) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new SAXException(exception);
                }
                throw (SAXException)exception;
            }
            throw new SAXException(xNIException.getMessage());
        }
        catch (XMLParseException xMLParseException) {
            Object object = xMLParseException.getException();
            if (object != null) {
                if (!(object instanceof SAXException)) {
                    if (object instanceof IOException) {
                        throw (IOException)object;
                    }
                    throw new SAXException((Exception)object);
                }
                throw (SAXException)object;
            }
            object = new LocatorImpl();
            ((LocatorImpl)object).setPublicId(xMLParseException.getPublicId());
            ((LocatorImpl)object).setSystemId(xMLParseException.getExpandedSystemId());
            ((LocatorImpl)object).setLineNumber(xMLParseException.getLineNumber());
            ((LocatorImpl)object).setColumnNumber(xMLParseException.getColumnNumber());
            throw new SAXParseException(xMLParseException.getMessage(), (Locator)object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEntityResolver(EntityResolver entityResolver) {
        try {
            XMLParserConfiguration xMLParserConfiguration = this.fConfiguration;
            EntityResolverWrapper entityResolverWrapper = new EntityResolverWrapper(entityResolver);
            xMLParserConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolverWrapper);
            return;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
        try {
            XMLParserConfiguration xMLParserConfiguration = this.fConfiguration;
            ErrorHandlerWrapper errorHandlerWrapper = new ErrorHandlerWrapper(errorHandler);
            xMLParserConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", errorHandlerWrapper);
            return;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            return;
        }
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fConfiguration.setFeature(string2, bl);
            return;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }

    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fConfiguration.setProperty(string2, object);
            return;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            string2 = xMLConfigurationException.getMessage();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(string2);
            }
            throw new SAXNotSupportedException(string2);
        }
    }
}

