/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.DTDConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public class StandardParserConfiguration
extends DTDConfiguration {
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    protected static final String XMLSCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String XMLSCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected XMLSchemaValidator fSchemaValidator;

    public StandardParserConfiguration() {
        this(null, null, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null);
    }

    public StandardParserConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager) {
        super(symbolTable, xMLGrammarPool, xMLComponentManager);
        this.addRecognizedFeatures(new String[]{NORMALIZE_DATA, SCHEMA_ELEMENT_DEFAULT, SCHEMA_AUGMENT_PSVI, XMLSCHEMA_VALIDATION, XMLSCHEMA_FULL_CHECKING});
        this.setFeature(SCHEMA_ELEMENT_DEFAULT, true);
        this.setFeature(NORMALIZE_DATA, true);
        this.setFeature(SCHEMA_AUGMENT_PSVI, true);
        this.addRecognizedProperties(new String[]{SCHEMA_LOCATION, SCHEMA_NONS_LOCATION});
    }

    @Override
    protected void checkFeature(String string2) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/features/")) {
            String string3 = string2.substring(31);
            if (string3.equals("validation/schema")) {
                return;
            }
            if (string3.equals("validation/schema-full-checking")) {
                return;
            }
            if (string3.equals("validation/schema/normalized-value")) {
                return;
            }
            if (string3.equals("validation/schema/element-default")) {
                return;
            }
        }
        super.checkFeature(string2);
    }

    @Override
    protected void checkProperty(String string2) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/")) {
            String string3 = string2.substring(33);
            if (string3.equals("schema/external-schemaLocation")) {
                return;
            }
            if (string3.equals("schema/external-noNamespaceSchemaLocation")) {
                return;
            }
        }
        if (string2.startsWith("http://java.sun.com/xml/jaxp/properties/") && string2.substring(40).equals("schemaSource")) {
            return;
        }
        super.checkProperty(string2);
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        if (this.getFeature(XMLSCHEMA_VALIDATION)) {
            if (this.fSchemaValidator == null) {
                this.fSchemaValidator = new XMLSchemaValidator();
                this.fProperties.put(SCHEMA_VALIDATOR, this.fSchemaValidator);
                this.addComponent(this.fSchemaValidator);
                if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                    XSMessageFormatter xSMessageFormatter = new XSMessageFormatter();
                    this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xSMessageFormatter);
                }
            }
            this.fLastComponent = this.fSchemaValidator;
            this.fNamespaceBinder.setDocumentHandler(this.fSchemaValidator);
            this.fSchemaValidator.setDocumentHandler(this.fDocumentHandler);
            this.fSchemaValidator.setDocumentSource(this.fNamespaceBinder);
        }
    }
}

