/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.SynchronizedSymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarCachingConfiguration
extends StandardParserConfiguration {
    public static final int BIG_PRIME = 2039;
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final XMLGrammarPoolImpl fStaticGrammarPool;
    protected static final SynchronizedSymbolTable fStaticSymbolTable;
    protected XMLDTDLoader fDTDLoader;
    protected XMLSchemaLoader fSchemaLoader;

    static {
        fStaticSymbolTable = new SynchronizedSymbolTable(2039);
        fStaticGrammarPool = new XMLGrammarPoolImpl();
    }

    public XMLGrammarCachingConfiguration() {
        this(fStaticSymbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable) {
        this(symbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable object, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager) {
        super((SymbolTable)object, xMLGrammarPool, xMLComponentManager);
        this.fSchemaLoader = object = new XMLSchemaLoader(this.fSymbolTable);
        ((XMLSchemaLoader)object).setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.fGrammarPool);
        this.fDTDLoader = new XMLDTDLoader(this.fSymbolTable, this.fGrammarPool);
    }

    @Override
    protected void checkFeature(String string2) throws XMLConfigurationException {
        super.checkFeature(string2);
    }

    @Override
    protected void checkProperty(String string2) throws XMLConfigurationException {
        super.checkProperty(string2);
    }

    public void clearGrammarPool() {
        this.fGrammarPool.clear();
    }

    public void lockGrammarPool() {
        this.fGrammarPool.lockPool();
    }

    DTDGrammar parseDTD(XMLInputSource object) throws IOException {
        XMLEntityResolver xMLEntityResolver = this.getEntityResolver();
        if (xMLEntityResolver != null) {
            this.fDTDLoader.setEntityResolver(xMLEntityResolver);
        }
        this.fDTDLoader.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.fErrorReporter);
        object = (DTDGrammar)this.fDTDLoader.loadGrammar((XMLInputSource)object);
        if (object != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/TR/REC-xml", new Grammar[]{object});
        }
        return object;
    }

    public Grammar parseGrammar(String string2, String string3) throws XNIException, IOException {
        return this.parseGrammar(string2, new XMLInputSource(null, string3, null));
    }

    public Grammar parseGrammar(String string2, XMLInputSource xMLInputSource) throws XNIException, IOException {
        if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
            return this.parseXMLSchema(xMLInputSource);
        }
        if (string2.equals("http://www.w3.org/TR/REC-xml")) {
            return this.parseDTD(xMLInputSource);
        }
        return null;
    }

    SchemaGrammar parseXMLSchema(XMLInputSource object) throws IOException {
        Object object2 = this.getEntityResolver();
        if (object2 != null) {
            this.fSchemaLoader.setEntityResolver((XMLEntityResolver)object2);
        }
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        this.fSchemaLoader.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.fErrorReporter);
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("http://apache.org/xml/properties/");
        ((StringBuffer)object2).append("schema/external-schemaLocation");
        object2 = ((StringBuffer)object2).toString();
        this.fSchemaLoader.setProperty((String)object2, this.getProperty((String)object2));
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("http://apache.org/xml/properties/");
        ((StringBuffer)object2).append("schema/external-noNamespaceSchemaLocation");
        object2 = ((StringBuffer)object2).toString();
        this.fSchemaLoader.setProperty((String)object2, this.getProperty((String)object2));
        this.fSchemaLoader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getProperty("http://java.sun.com/xml/jaxp/properties/schemaSource"));
        this.fSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, this.getFeature(SCHEMA_FULL_CHECKING));
        object = (SchemaGrammar)this.fSchemaLoader.loadGrammar((XMLInputSource)object);
        if (object != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", new Grammar[]{object});
        }
        return object;
    }

    public void unlockGrammarPool() {
        this.fGrammarPool.unlockPool();
    }
}

