/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarPreparser {
    private static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Hashtable KNOWN_LOADERS;
    private static final String[] RECOGNIZED_PROPERTIES;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected XMLEntityResolver fEntityResolver;
    protected XMLErrorReporter fErrorReporter;
    protected XMLGrammarPool fGrammarPool;
    private Hashtable fLoaders;
    protected Locale fLocale;
    protected SymbolTable fSymbolTable;

    static {
        Hashtable<String, String> hashtable;
        KNOWN_LOADERS = hashtable = new Hashtable<String, String>();
        hashtable.put("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.impl.xs.XMLSchemaLoader");
        hashtable.put("http://www.w3.org/TR/REC-xml", "org.apache.xerces.impl.dtd.XMLDTDLoader");
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ERROR_HANDLER, ENTITY_RESOLVER, GRAMMAR_POOL};
    }

    public XMLGrammarPreparser() {
        this(new SymbolTable());
    }

    public XMLGrammarPreparser(SymbolTable object) {
        this.fSymbolTable = object;
        this.fLoaders = new Hashtable();
        this.setLocale(Locale.getDefault());
        this.fErrorReporter = object = new XMLErrorReporter();
        ((XMLErrorReporter)object).setLocale(this.fLocale);
        this.fEntityResolver = new XMLEntityManager();
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public boolean getFeature(String string2, String string3) {
        return ((XMLGrammarLoader)this.fLoaders.get(string2)).getFeature(string3);
    }

    public XMLGrammarPool getGrammarPool() {
        return this.fGrammarPool;
    }

    public XMLGrammarLoader getLoader(String string2) {
        return (XMLGrammarLoader)this.fLoaders.get(string2);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public Object getProperty(String string2, String string3) {
        return ((XMLGrammarLoader)this.fLoaders.get(string2)).getProperty(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Grammar preparseGrammar(String object, XMLInputSource xMLInputSource) throws XNIException, IOException {
        if (!this.fLoaders.containsKey(object)) return null;
        object = (XMLGrammarLoader)this.fLoaders.get(object);
        object.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        object.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
        object.setProperty(ERROR_REPORTER, this.fErrorReporter);
        XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
        if (xMLGrammarPool == null) return object.loadGrammar(xMLInputSource);
        try {
            object.setProperty(GRAMMAR_POOL, xMLGrammarPool);
            return object.loadGrammar(xMLInputSource);
        }
        catch (Exception exception) {
            return object.loadGrammar(xMLInputSource);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerPreparser(String string2, XMLGrammarLoader object) {
        if (object != null) {
            this.fLoaders.put(string2, object);
            return true;
        }
        object = KNOWN_LOADERS;
        if (!((Hashtable)object).containsKey(string2)) return false;
        object = (String)((Hashtable)object).get(string2);
        try {
            object = (XMLGrammarLoader)ObjectFactory.newInstance((String)object, ObjectFactory.findClassLoader(), true);
            this.fLoaders.put(string2, object);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    public void setFeature(String string2, boolean bl) {
        Enumeration enumeration = this.fLoaders.elements();
        while (true) {
            if (!enumeration.hasMoreElements()) {
                if (string2.equals(CONTINUE_AFTER_FATAL_ERROR)) {
                    this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
                }
                return;
            }
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setFeature(string2, bl);
            }
            catch (Exception exception) {
            }
        }
    }

    public void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
        this.fGrammarPool = xMLGrammarPool;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public void setProperty(String string2, Object object) {
        Enumeration enumeration = this.fLoaders.elements();
        while (enumeration.hasMoreElements()) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setProperty(string2, object);
            }
            catch (Exception exception) {
            }
        }
        return;
    }
}

