/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.xerces.xni.Augmentations;

public class AugmentationsImpl
implements Augmentations {
    private AugmentationsItemsContainer fAugmentationsContainer = new SmallContainer();

    @Override
    public Object getItem(String string2) {
        return this.fAugmentationsContainer.getItem(string2);
    }

    @Override
    public Enumeration keys() {
        return this.fAugmentationsContainer.keys();
    }

    @Override
    public Object putItem(String object, Object object2) {
        if ((object = this.fAugmentationsContainer.putItem(object, object2)) == null && this.fAugmentationsContainer.isFull()) {
            this.fAugmentationsContainer = this.fAugmentationsContainer.expand();
        }
        return object;
    }

    @Override
    public void removeAllItems() {
        this.fAugmentationsContainer.clear();
    }

    @Override
    public Object removeItem(String string2) {
        return this.fAugmentationsContainer.removeItem(string2);
    }

    public String toString() {
        return this.fAugmentationsContainer.toString();
    }

    abstract class AugmentationsItemsContainer {
        AugmentationsItemsContainer() {
        }

        public abstract void clear();

        public abstract AugmentationsItemsContainer expand();

        public abstract Object getItem(Object var1);

        public abstract boolean isFull();

        public abstract Enumeration keys();

        public abstract Object putItem(Object var1, Object var2);

        public abstract Object removeItem(Object var1);
    }

    class LargeContainer
    extends AugmentationsItemsContainer {
        final Hashtable fAugmentations = new Hashtable();

        LargeContainer() {
        }

        @Override
        public void clear() {
            this.fAugmentations.clear();
        }

        @Override
        public AugmentationsItemsContainer expand() {
            return this;
        }

        @Override
        public Object getItem(Object object) {
            return this.fAugmentations.get(object);
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public Enumeration keys() {
            return this.fAugmentations.keys();
        }

        @Override
        public Object putItem(Object object, Object object2) {
            return this.fAugmentations.put(object, object2);
        }

        @Override
        public Object removeItem(Object object) {
            return this.fAugmentations.remove(object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LargeContainer");
            Enumeration enumeration = this.fAugmentations.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                stringBuffer.append("\nkey == ");
                stringBuffer.append(k);
                stringBuffer.append("; value == ");
                stringBuffer.append(this.fAugmentations.get(k));
            }
            return stringBuffer.toString();
        }
    }

    class SmallContainer
    extends AugmentationsItemsContainer {
        static final int SIZE_LIMIT = 10;
        final Object[] fAugmentations = new Object[20];
        int fNumEntries = 0;

        SmallContainer() {
        }

        @Override
        public void clear() {
            int n = 0;
            while (true) {
                if (n >= this.fNumEntries * 2) {
                    this.fNumEntries = 0;
                    return;
                }
                Object[] objectArray = this.fAugmentations;
                objectArray[n] = null;
                objectArray[n + 1] = null;
                n += 2;
            }
        }

        @Override
        public AugmentationsItemsContainer expand() {
            LargeContainer largeContainer = new LargeContainer();
            int n = 0;
            while (n < this.fNumEntries * 2) {
                Object[] objectArray = this.fAugmentations;
                largeContainer.putItem(objectArray[n], objectArray[n + 1]);
                n += 2;
            }
            return largeContainer;
        }

        @Override
        public Object getItem(Object object) {
            int n = 0;
            while (n < this.fNumEntries * 2) {
                if (this.fAugmentations[n].equals(object)) {
                    return this.fAugmentations[n + 1];
                }
                n += 2;
            }
            return null;
        }

        @Override
        public boolean isFull() {
            boolean bl = this.fNumEntries == 10;
            return bl;
        }

        @Override
        public Enumeration keys() {
            return new SmallContainerKeyEnumeration();
        }

        @Override
        public Object putItem(Object object, Object object2) {
            int n = 0;
            while (true) {
                int n2;
                if (n >= (n2 = this.fNumEntries) * 2) {
                    Object[] objectArray = this.fAugmentations;
                    objectArray[n2 * 2] = object;
                    objectArray[n2 * 2 + 1] = object2;
                    this.fNumEntries = n2 + 1;
                    return null;
                }
                if (this.fAugmentations[n].equals(object)) {
                    Object[] objectArray = this.fAugmentations;
                    object = objectArray[++n];
                    objectArray[n] = object2;
                    return object;
                }
                n += 2;
            }
        }

        @Override
        public Object removeItem(Object object) {
            int n = 0;
            while (n < this.fNumEntries * 2) {
                if (this.fAugmentations[n].equals(object)) {
                    object = this.fAugmentations[n + 1];
                    while (true) {
                        Object[] objectArray;
                        int n2;
                        if (n >= (n2 = this.fNumEntries) * 2 - 2) {
                            objectArray = this.fAugmentations;
                            objectArray[n2 * 2 - 2] = null;
                            objectArray[n2 * 2 - 1] = null;
                            this.fNumEntries = n2 - 1;
                            return object;
                        }
                        objectArray = this.fAugmentations;
                        n2 = n + 2;
                        objectArray[n] = objectArray[n2];
                        objectArray[n + 1] = objectArray[n + 3];
                        n = n2;
                    }
                }
                n += 2;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("SmallContainer - fNumEntries == ");
            stringBuffer2.append(this.fNumEntries);
            stringBuffer.append(stringBuffer2.toString());
            int n = 0;
            while (n < 20) {
                stringBuffer.append("\nfAugmentations[");
                stringBuffer.append(n);
                stringBuffer.append("] == ");
                stringBuffer.append(this.fAugmentations[n]);
                stringBuffer.append("; fAugmentations[");
                int n2 = n + 1;
                stringBuffer.append(n2);
                stringBuffer.append("] == ");
                stringBuffer.append(this.fAugmentations[n2]);
                n += 2;
            }
            return stringBuffer.toString();
        }

        class SmallContainerKeyEnumeration
        implements Enumeration {
            Object[] enumArray;
            int next;

            SmallContainerKeyEnumeration() {
                this.enumArray = new Object[SmallContainer.this.fNumEntries];
                int n = 0;
                this.next = 0;
                while (n < SmallContainer.this.fNumEntries) {
                    this.enumArray[n] = SmallContainer.this.fAugmentations[n * 2];
                    ++n;
                }
                return;
            }

            @Override
            public boolean hasMoreElements() {
                boolean bl = this.next < this.enumArray.length;
                return bl;
            }

            public Object nextElement() {
                int n = this.next;
                Object[] objectArray = this.enumArray;
                if (n < objectArray.length) {
                    Object object = objectArray[n];
                    objectArray[n] = null;
                    this.next = n + 1;
                    return object;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

