/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.PrintWriter;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;

public class DefaultErrorHandler
implements XMLErrorHandler {
    protected PrintWriter fOut;

    public DefaultErrorHandler() {
        this(new PrintWriter(System.err));
    }

    public DefaultErrorHandler(PrintWriter printWriter) {
        this.fOut = printWriter;
    }

    private void printError(String string2, XMLParseException xMLParseException) {
        this.fOut.print("[");
        this.fOut.print(string2);
        this.fOut.print("] ");
        String string3 = xMLParseException.getExpandedSystemId();
        if (string3 != null) {
            int n = string3.lastIndexOf(47);
            string2 = string3;
            if (n != -1) {
                string2 = string3.substring(n + 1);
            }
            this.fOut.print(string2);
        }
        this.fOut.print(':');
        this.fOut.print(xMLParseException.getLineNumber());
        this.fOut.print(':');
        this.fOut.print(xMLParseException.getColumnNumber());
        this.fOut.print(": ");
        this.fOut.print(xMLParseException.getMessage());
        this.fOut.println();
        this.fOut.flush();
    }

    @Override
    public void error(String string2, String string3, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    @Override
    public void fatalError(String string2, String string3, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    @Override
    public void warning(String string2, String string3, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }
}

