/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public final class IntStack {
    private int[] fData;
    private int fDepth;

    private void ensureCapacity(int n) {
        int[] nArray = this.fData;
        if (nArray == null) {
            this.fData = new int[32];
        } else if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            this.fData = nArray2;
        }
    }

    public void clear() {
        this.fDepth = 0;
    }

    public int peek() {
        return this.fData[this.fDepth - 1];
    }

    public int pop() {
        int n;
        int[] nArray = this.fData;
        this.fDepth = n = this.fDepth - 1;
        return nArray[n];
    }

    public void print() {
        System.out.print('(');
        System.out.print(this.fDepth);
        System.out.print(") {");
        int n = 0;
        while (true) {
            block6: {
                block5: {
                    if (n >= this.fDepth) break block5;
                    if (n != 3) break block6;
                    System.out.print(" ...");
                }
                System.out.print(" }");
                System.out.println();
                return;
            }
            System.out.print(' ');
            System.out.print(this.fData[n]);
            if (n < this.fDepth - 1) {
                System.out.print(',');
            }
            ++n;
        }
    }

    public void push(int n) {
        this.ensureCapacity(this.fDepth + 1);
        int[] nArray = this.fData;
        int n2 = this.fDepth;
        this.fDepth = n2 + 1;
        nArray[n2] = n;
    }

    public int size() {
        return this.fDepth;
    }
}

