/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;

public class NamespaceSupport
implements NamespaceContext {
    protected int[] fContext;
    protected int fCurrentContext;
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected String[] fPrefixes;

    public NamespaceSupport() {
        this.fContext = new int[8];
        this.fPrefixes = new String[16];
    }

    public NamespaceSupport(NamespaceContext namespaceContext) {
        this.fContext = new int[8];
        this.fPrefixes = new String[16];
        this.pushContext();
        Enumeration enumeration = namespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.declarePrefix(string2, namespaceContext.getURI(string2));
        }
        return;
    }

    @Override
    public boolean declarePrefix(String string2, String string3) {
        if (string2 != XMLSymbols.PREFIX_XML && string2 != XMLSymbols.PREFIX_XMLNS) {
            int n = this.fNamespaceSize;
            while (true) {
                String[] stringArray;
                if (n <= this.fContext[this.fCurrentContext]) {
                    n = this.fNamespaceSize;
                    stringArray = this.fNamespace;
                    if (n == stringArray.length) {
                        String[] stringArray2 = new String[n * 2];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n);
                        this.fNamespace = stringArray2;
                    }
                    stringArray = this.fNamespace;
                    int n2 = this.fNamespaceSize;
                    this.fNamespaceSize = n = n2 + 1;
                    stringArray[n2] = string2;
                    this.fNamespaceSize = n + 1;
                    stringArray[n] = string3;
                    return true;
                }
                stringArray = this.fNamespace;
                if (stringArray[n - 2] == string2) {
                    stringArray[n - 1] = string3;
                    return true;
                }
                n -= 2;
            }
        }
        return false;
    }

    @Override
    public Enumeration getAllPrefixes() {
        if (this.fPrefixes.length < this.fNamespace.length / 2) {
            this.fPrefixes = new String[this.fNamespaceSize];
        }
        int n = 2;
        int n2 = 0;
        block0: while (n < this.fNamespaceSize - 2) {
            Object object = this.fNamespace;
            int n3 = n + 2;
            object = object[n3];
            n = 0;
            while (true) {
                block9: {
                    boolean bl;
                    block8: {
                        block7: {
                            if (n < n2) break block7;
                            bl = true;
                            break block8;
                        }
                        if (this.fPrefixes[n] != object) break block9;
                        bl = false;
                    }
                    n = n3;
                    if (!bl) continue block0;
                    this.fPrefixes[n2] = object;
                    ++n2;
                    n = n3;
                    continue block0;
                }
                ++n;
            }
            break;
        }
        return new Prefixes(this.fPrefixes, n2);
    }

    @Override
    public String getDeclaredPrefixAt(int n) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + n * 2];
    }

    @Override
    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    @Override
    public String getPrefix(String string2) {
        int n = this.fNamespaceSize;
        while (n > 0) {
            int n2;
            String[] stringArray = this.fNamespace;
            if (stringArray[n - 1] == string2 && this.getURI(stringArray[n2 = n - 2]) == string2) {
                return this.fNamespace[n2];
            }
            n -= 2;
        }
        return null;
    }

    @Override
    public String getURI(String string2) {
        int n = this.fNamespaceSize;
        while (n > 0) {
            String[] stringArray = this.fNamespace;
            if (stringArray[n - 2] == string2) {
                return stringArray[n - 1];
            }
            n -= 2;
        }
        return null;
    }

    @Override
    public void popContext() {
        int[] nArray = this.fContext;
        int n = this.fCurrentContext;
        this.fCurrentContext = n - 1;
        this.fNamespaceSize = nArray[n];
    }

    @Override
    public void pushContext() {
        int n = this.fCurrentContext;
        int[] nArray = this.fContext;
        if (n + 1 == nArray.length) {
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            this.fContext = nArray2;
        }
        nArray = this.fContext;
        this.fCurrentContext = n = this.fCurrentContext + 1;
        nArray[n] = this.fNamespaceSize;
    }

    @Override
    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[0] = 0;
        String[] stringArray = this.fNamespace;
        this.fNamespaceSize = 0 + 1;
        stringArray[0] = XMLSymbols.PREFIX_XML;
        stringArray = this.fNamespace;
        int n = this.fNamespaceSize;
        this.fNamespaceSize = n + 1;
        stringArray[n] = NamespaceContext.XML_URI;
        stringArray = this.fNamespace;
        n = this.fNamespaceSize;
        this.fNamespaceSize = n + 1;
        stringArray[n] = XMLSymbols.PREFIX_XMLNS;
        stringArray = this.fNamespace;
        n = this.fNamespaceSize;
        this.fNamespaceSize = n + 1;
        stringArray[n] = NamespaceContext.XMLNS_URI;
        ++this.fCurrentContext;
    }

    final class Prefixes
    implements Enumeration {
        private int counter = 0;
        private String[] prefixes;
        private int size = 0;

        public Prefixes(String[] stringArray, int n) {
            this.prefixes = stringArray;
            this.size = n;
        }

        @Override
        public boolean hasMoreElements() {
            boolean bl = this.counter < this.size;
            return bl;
        }

        public Object nextElement() {
            if (this.counter < this.size) {
                String[] stringArray = NamespaceSupport.this.fPrefixes;
                int n = this.counter;
                this.counter = n + 1;
                return stringArray[n];
            }
            throw new NoSuchElementException("Illegal access to Namespace prefixes enumeration.");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.prefixes[n]);
                stringBuffer.append(" ");
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

