/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public class ParserConfigurationSettings
implements XMLComponentManager {
    static int counter = 1;
    protected Hashtable fFeatures;
    protected XMLComponentManager fParentSettings;
    protected Hashtable fProperties;
    protected Vector fRecognizedFeatures = new Vector();
    protected Vector fRecognizedProperties = new Vector();

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager xMLComponentManager) {
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        this.fParentSettings = xMLComponentManager;
    }

    public void addRecognizedFeatures(String[] stringArray) {
        int n = 0;
        int n2 = stringArray != null ? stringArray.length : 0;
        while (n < n2) {
            String string2 = stringArray[n];
            if (!this.fRecognizedFeatures.contains(string2)) {
                this.fRecognizedFeatures.addElement(string2);
            }
            ++n;
        }
        return;
    }

    public void addRecognizedProperties(String[] stringArray) {
        int n = 0;
        int n2 = stringArray != null ? stringArray.length : 0;
        while (n < n2) {
            String string2 = stringArray[n];
            if (!this.fRecognizedProperties.contains(string2)) {
                this.fRecognizedProperties.addElement(string2);
            }
            ++n;
        }
        return;
    }

    protected void checkFeature(String string2) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string2)) {
            XMLComponentManager xMLComponentManager = this.fParentSettings;
            if (xMLComponentManager != null) {
                xMLComponentManager.getFeature(string2);
            } else {
                throw new XMLConfigurationException(0, string2);
            }
        }
    }

    protected void checkProperty(String string2) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string2)) {
            XMLComponentManager xMLComponentManager = this.fParentSettings;
            if (xMLComponentManager != null) {
                xMLComponentManager.getProperty(string2);
            } else {
                throw new XMLConfigurationException(0, string2);
            }
        }
    }

    @Override
    public boolean getFeature(String string2) throws XMLConfigurationException {
        Boolean bl = (Boolean)this.fFeatures.get(string2);
        if (bl == null) {
            this.checkFeature(string2);
            return false;
        }
        return bl;
    }

    @Override
    public Object getProperty(String string2) throws XMLConfigurationException {
        Object v = this.fProperties.get(string2);
        if (v == null) {
            this.checkProperty(string2);
        }
        return v;
    }

    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        this.checkFeature(string2);
        Hashtable hashtable = this.fFeatures;
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        hashtable.put(string2, bl2);
    }

    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        this.checkProperty(string2);
        this.fProperties.put(string2, object);
    }
}

