/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class SymbolHash {
    protected Entry[] fBuckets;
    protected int fNum = 0;
    protected int fTableSize = 101;

    public SymbolHash() {
        this.fBuckets = new Entry[101];
    }

    public SymbolHash(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[n];
    }

    public void clear() {
        int n = 0;
        while (true) {
            if (n >= this.fTableSize) {
                this.fNum = 0;
                return;
            }
            this.fBuckets[n] = null;
            ++n;
        }
    }

    public Object get(Object object) {
        if ((object = this.search(object, (object.hashCode() & Integer.MAX_VALUE) % this.fTableSize)) != null) {
            return ((Entry)object).value;
        }
        return null;
    }

    public int getLength() {
        return this.fNum;
    }

    public int getValues(Object[] objectArray, int n) {
        int n2 = 0;
        block0: for (int i = 0; i < this.fTableSize && n2 < this.fNum; ++i) {
            Entry entry = this.fBuckets[i];
            while (true) {
                if (entry == null) {
                    continue block0;
                }
                objectArray[n + n2] = entry.value;
                ++n2;
                entry = entry.next;
            }
        }
        return this.fNum;
    }

    public SymbolHash makeClone() {
        SymbolHash symbolHash = new SymbolHash(this.fTableSize);
        symbolHash.fNum = this.fNum;
        int n = 0;
        while (n < this.fTableSize) {
            Entry[] entryArray = this.fBuckets;
            if (entryArray[n] != null) {
                symbolHash.fBuckets[n] = entryArray[n].makeClone();
            }
            ++n;
        }
        return symbolHash;
    }

    public void put(Object object, Object object2) {
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.fTableSize;
        Entry entry = this.search(object, n);
        if (entry != null) {
            entry.value = object2;
        } else {
            this.fBuckets[n] = object = new Entry(object, object2, this.fBuckets[n]);
            ++this.fNum;
        }
    }

    protected Entry search(Object object, int n) {
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            if (object.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected static final class Entry {
        public Object key;
        public Entry next;
        public Object value;

        public Entry() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        public Entry(Object object, Object object2, Entry entry) {
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        public Entry makeClone() {
            Entry entry = new Entry();
            entry.key = this.key;
            entry.value = this.value;
            Entry entry2 = this.next;
            if (entry2 != null) {
                entry.next = entry2.makeClone();
            }
            return entry;
        }
    }
}

