/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(101);
    }

    public SymbolTable(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[n];
    }

    public String addSymbol(String object) {
        int n = this.hash((String)object) % this.fTableSize;
        int n2 = ((String)object).length();
        Entry entry = this.fBuckets[n];
        while (true) {
            if (entry == null) {
                this.fBuckets[n] = object = new Entry((String)object, this.fBuckets[n]);
                return ((Entry)object).symbol;
            }
            if (n2 == entry.characters.length) {
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        return entry.symbol;
                    }
                    if (((String)object).charAt(n3) != entry.characters[n3]) break;
                    ++n3;
                }
            }
            entry = entry.next;
        }
    }

    public String addSymbol(char[] object, int n, int n2) {
        int n3 = this.hash((char[])object, n, n2) % this.fTableSize;
        Entry entry = this.fBuckets[n3];
        while (true) {
            if (entry == null) {
                object = new Entry((char[])object, n, n2, this.fBuckets[n3]);
                this.fBuckets[n3] = object;
                return object.symbol;
            }
            if (n2 == entry.characters.length) {
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) {
                        return entry.symbol;
                    }
                    if (object[n + n4] != entry.characters[n4]) break;
                    ++n4;
                }
            }
            entry = entry.next;
        }
    }

    public boolean containsSymbol(String string2) {
        int n = this.hash(string2);
        int n2 = this.fTableSize;
        int n3 = string2.length();
        Entry entry = this.fBuckets[n % n2];
        while (true) {
            n2 = 0;
            if (entry == null) {
                return false;
            }
            if (n3 == entry.characters.length) {
                while (true) {
                    if (n2 >= n3) {
                        return true;
                    }
                    if (string2.charAt(n2) != entry.characters[n2]) break;
                    ++n2;
                }
            }
            entry = entry.next;
        }
    }

    public boolean containsSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2);
        int n4 = this.fTableSize;
        Entry entry = this.fBuckets[n3 % n4];
        while (true) {
            n3 = 0;
            if (entry == null) {
                return false;
            }
            if (n2 == entry.characters.length) {
                while (true) {
                    if (n3 >= n2) {
                        return true;
                    }
                    if (cArray[n + n3] != entry.characters[n3]) break;
                    ++n3;
                }
            }
            entry = entry.next;
        }
    }

    public int hash(String string2) {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n3 = n3 * 37 + string2.charAt(n2);
            ++n2;
        }
        return 0x7FFFFFF & n3;
    }

    public int hash(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = n4 * 37 + cArray[n + n3];
            ++n3;
        }
        return 0x7FFFFFF & n4;
    }

    protected static final class Entry {
        public char[] characters;
        public Entry next;
        public String symbol;

        public Entry(String string2, Entry entry) {
            this.symbol = string2.intern();
            char[] cArray = new char[string2.length()];
            this.characters = cArray;
            string2.getChars(0, cArray.length, cArray, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n, int n2, Entry entry) {
            char[] cArray2 = new char[n2];
            this.characters = cArray2;
            System.arraycopy(cArray, n, cArray2, 0, n2);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

