/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.IOException;
import java.io.Serializable;

public class URI
implements Serializable {
    private static final int ASCII_ALPHA_CHARACTERS = 16;
    private static final int ASCII_DIGIT_CHARACTERS = 32;
    private static final int ASCII_HEX_CHARACTERS = 64;
    private static boolean DEBUG = false;
    private static final int MARK_CHARACTERS = 2;
    private static final int MASK_ALPHA_NUMERIC = 48;
    private static final int MASK_SCHEME_CHARACTER = 52;
    private static final int MASK_UNRESERVED_MASK = 50;
    private static final int MASK_URI_CHARACTER = 51;
    private static final int MASK_USERINFO_CHARACTER = 58;
    private static final int RESERVED_CHARACTERS = 1;
    private static final int SCHEME_CHARACTERS = 4;
    private static final int USERINFO_CHARACTERS = 8;
    private static final byte[] fgLookupTable = new byte[128];
    private String m_fragment;
    private String m_host;
    private String m_path;
    private int m_port;
    private String m_queryString;
    private String m_scheme;
    private String m_userinfo;

    static {
        int n = 48;
        while (true) {
            byte[] byArray;
            if (n > 57) {
                n = 65;
                while (true) {
                    int n2;
                    if (n > 70) {
                        n = 71;
                        while (true) {
                            if (n > 90) {
                                byArray = fgLookupTable;
                                byArray[59] = (byte)(byArray[59] | 1);
                                byArray[47] = (byte)(byArray[47] | 1);
                                byArray[63] = (byte)(byArray[63] | 1);
                                byArray[58] = (byte)(byArray[58] | 1);
                                byArray[64] = (byte)(byArray[64] | 1);
                                byArray[38] = (byte)(byArray[38] | 1);
                                byArray[61] = (byte)(byArray[61] | 1);
                                byArray[43] = (byte)(byArray[43] | 1);
                                byArray[36] = (byte)(byArray[36] | 1);
                                byArray[44] = (byte)(byArray[44] | 1);
                                byArray[91] = (byte)(byArray[91] | 1);
                                byArray[93] = (byte)(byArray[93] | 1);
                                byArray[45] = (byte)(byArray[45] | 2);
                                byArray[95] = (byte)(byArray[95] | 2);
                                byArray[46] = (byte)(byArray[46] | 2);
                                byArray[33] = (byte)(byArray[33] | 2);
                                byArray[126] = (byte)(byArray[126] | 2);
                                byArray[42] = (byte)(byArray[42] | 2);
                                byArray[39] = (byte)(byArray[39] | 2);
                                byArray[40] = (byte)(byArray[40] | 2);
                                byArray[41] = (byte)(byArray[41] | 2);
                                byArray[43] = (byte)(byArray[43] | 4);
                                byArray[45] = (byte)(byArray[45] | 4);
                                byArray[46] = (byte)(byArray[46] | 4);
                                byArray[59] = (byte)(byArray[59] | 8);
                                byArray[58] = (byte)(byArray[58] | 8);
                                byArray[38] = (byte)(byArray[38] | 8);
                                byArray[61] = (byte)(byArray[61] | 8);
                                byArray[43] = (byte)(byArray[43] | 8);
                                byArray[36] = (byte)(byArray[36] | 8);
                                byArray[44] = (byte)(byArray[44] | 8);
                                DEBUG = false;
                                return;
                            }
                            byArray = fgLookupTable;
                            byArray[n] = (byte)(byArray[n] | 0x10);
                            n2 = n + 32;
                            byArray[n2] = (byte)(byArray[n2] | 0x10);
                            ++n;
                        }
                    }
                    byArray = fgLookupTable;
                    byArray[n] = (byte)(byArray[n] | 0x50);
                    n2 = n + 32;
                    byArray[n2] = (byte)(byArray[n2] | 0x50);
                    ++n;
                }
            }
            byArray = fgLookupTable;
            byArray[n] = (byte)(byArray[n] | 0x60);
            ++n;
        }
    }

    public URI() {
        this.m_scheme = null;
        this.m_userinfo = null;
        this.m_host = null;
        this.m_port = -1;
        this.m_path = null;
        this.m_queryString = null;
        this.m_fragment = null;
    }

    public URI(String string2) throws MalformedURIException {
        URI uRI = null;
        this((URI)null, string2);
    }

    public URI(String string2, String string3) throws MalformedURIException {
        this.m_scheme = null;
        this.m_userinfo = null;
        this.m_host = null;
        this.m_port = -1;
        this.m_path = null;
        this.m_queryString = null;
        this.m_fragment = null;
        if (string2 != null && string2.trim().length() != 0) {
            if (string3 != null && string3.trim().length() != 0) {
                this.setScheme(string2);
                this.setPath(string3);
                return;
            }
            throw new MalformedURIException("Cannot construct URI with null/empty scheme-specific part!");
        }
        throw new MalformedURIException("Cannot construct URI with null/empty scheme!");
    }

    public URI(String string2, String string3, String string4, int n, String string5, String string6, String string7) throws MalformedURIException {
        this.m_scheme = null;
        this.m_userinfo = null;
        this.m_host = null;
        this.m_port = -1;
        this.m_path = null;
        this.m_queryString = null;
        this.m_fragment = null;
        if (string2 != null && string2.trim().length() != 0) {
            if (string4 == null) {
                if (string3 == null) {
                    if (n != -1) {
                        throw new MalformedURIException("Port may not be specified if host is not specified!");
                    }
                } else {
                    throw new MalformedURIException("Userinfo may not be specified if host is not specified!");
                }
            }
            if (string5 != null) {
                if (string5.indexOf(63) != -1 && string6 != null) {
                    throw new MalformedURIException("Query string cannot be specified in path and query string!");
                }
                if (string5.indexOf(35) != -1 && string7 != null) {
                    throw new MalformedURIException("Fragment cannot be specified in both the path and fragment!");
                }
            }
            this.setScheme(string2);
            this.setHost(string4);
            this.setPort(n);
            this.setUserinfo(string3);
            this.setPath(string5);
            this.setQueryString(string6);
            this.setFragment(string7);
            return;
        }
        throw new MalformedURIException("Scheme is required!");
    }

    public URI(String string2, String string3, String string4, String string5, String string6) throws MalformedURIException {
        this(string2, null, string3, -1, string4, string5, string6);
    }

    public URI(URI uRI) {
        this.m_scheme = null;
        this.m_userinfo = null;
        this.m_host = null;
        this.m_port = -1;
        this.m_path = null;
        this.m_queryString = null;
        this.m_fragment = null;
        this.initialize(uRI);
    }

    public URI(URI uRI, String string2) throws MalformedURIException {
        this.m_scheme = null;
        this.m_userinfo = null;
        this.m_host = null;
        this.m_port = -1;
        this.m_path = null;
        this.m_queryString = null;
        this.m_fragment = null;
        this.initialize(uRI, string2);
    }

    private void initialize(URI uRI) {
        this.m_scheme = uRI.getScheme();
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.getPort();
        this.m_path = uRI.getPath();
        this.m_queryString = uRI.getQueryString();
        this.m_fragment = uRI.getFragment();
    }

    private void initialize(URI object, String object2) throws MalformedURIException {
        object2 = object2 != null ? ((String)object2).trim() : null;
        int n = object2 != null ? ((String)object2).length() : 0;
        if (object == null && n == 0) {
            throw new MalformedURIException("Cannot initialize URI with empty parameters.");
        }
        if (n == 0) {
            this.initialize((URI)object);
            return;
        }
        int n2 = ((String)object2).indexOf(58);
        int n3 = ((String)object2).indexOf(47);
        int n4 = ((String)object2).indexOf(63);
        int n5 = ((String)object2).indexOf(35);
        if (!(n2 < 2 || n2 > n3 && n3 != -1 || n2 > n4 && n4 != -1 || n2 > n5 && n5 != -1)) {
            this.initializeScheme((String)object2);
            n4 = this.m_scheme.length() + 1;
        } else {
            if (object == null && n5 != 0) {
                throw new MalformedURIException("No scheme found in URI.");
            }
            n4 = 0;
        }
        n3 = n4 + 1;
        n5 = n4;
        if (n3 < n) {
            n5 = n4;
            if (((String)object2).charAt(n4) == '/') {
                n5 = n4;
                if (((String)object2).charAt(n3) == '/') {
                    for (n4 = n5 = n4 + 2; n4 < n && (n3 = (int)((String)object2).charAt(n4)) != 47 && n3 != 63 && n3 != 35; ++n4) {
                    }
                    if (n4 > n5) {
                        this.initializeAuthority((String)object2, n5, n4);
                    } else {
                        this.m_host = "";
                    }
                    n5 = n4;
                }
            }
        }
        this.initializePath((String)object2, n5);
        if (object != null) {
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = ((URI)object).getScheme();
                this.m_userinfo = ((URI)object).getUserinfo();
                this.m_host = ((URI)object).getHost();
                this.m_port = ((URI)object).getPort();
                this.m_path = ((URI)object).getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = ((URI)object).getQueryString();
                }
                return;
            }
            if (this.m_scheme == null) {
                this.m_scheme = ((URI)object).getScheme();
                if (this.m_host == null) {
                    this.m_userinfo = ((URI)object).getUserinfo();
                    this.m_host = ((URI)object).getHost();
                    this.m_port = ((URI)object).getPort();
                    if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                        return;
                    }
                    object2 = new String();
                    String string2 = ((URI)object).getPath();
                    object = object2;
                    if (string2 != null) {
                        n4 = string2.lastIndexOf(47);
                        object = object2;
                        if (n4 != -1) {
                            object = string2.substring(0, n4 + 1);
                        }
                    }
                    object2 = ((String)object).concat(this.m_path);
                    block1: while (true) {
                        if ((n4 = ((String)object2).indexOf("/./")) == -1) {
                            object = object2;
                            if (((String)object2).endsWith("/.")) {
                                object = ((String)object2).substring(0, ((String)object2).length() - 1);
                            }
                            n4 = 1;
                            while (true) {
                                if ((n = ((String)object).indexOf("/../", n4)) <= 0) {
                                    object2 = object;
                                    if (((String)object).endsWith("/..")) {
                                        n4 = ((String)object).substring(0, ((String)object).length() - 3).lastIndexOf(47);
                                        object2 = object;
                                        if (n4 != -1) {
                                            object2 = ((String)object).substring(0, n4 + 1);
                                        }
                                    }
                                    this.m_path = object2;
                                    break block1;
                                }
                                object2 = ((String)object).substring(0, ((String)object).indexOf("/../"));
                                n4 = ((String)object2).lastIndexOf(47);
                                if (n4 != -1 && !((String)object2).substring(n4).equals("..")) {
                                    object = ((String)object).substring(0, n4 + 1).concat(((String)object).substring(n + 4));
                                    continue;
                                }
                                n4 = n + 4;
                            }
                        }
                        object2 = ((String)object2).substring(0, n4 + 1).concat(((String)object2).substring(n4 + 3));
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeAuthority(String string2, int n, int n2) throws MalformedURIException {
        String string3;
        CharSequence charSequence;
        block16: {
            int n3;
            int n4 = string2.indexOf(64, n);
            int n5 = -1;
            int n6 = 0;
            if (n4 == -1) {
                charSequence = null;
                n4 = 0;
            } else {
                n3 = n;
                n4 = 0;
                while (true) {
                    if (n3 >= n2 || (n4 = (int)string2.charAt(n3)) == 64) {
                        charSequence = string2.substring(n, n3);
                        n = n3 + 1;
                        break;
                    }
                    ++n3;
                }
            }
            n3 = n;
            while (true) {
                if (n3 >= n2 || (n4 = (int)string2.charAt(n3)) == 58) {
                    string3 = string2.substring(n, n3);
                    n = n5;
                    if (string3.length() > 0) {
                        n = n5;
                        if (n4 == 58) {
                            break;
                        }
                    }
                    break block16;
                }
                ++n3;
            }
            n = n4 = n3 + 1;
            while (true) {
                if (n >= n2) {
                    string2 = string2.substring(n4, n);
                    n = n5;
                    if (string2.length() > 0) {
                        break;
                    }
                    break block16;
                }
                ++n;
            }
            n = n6;
            while (true) {
                if (n >= string2.length()) {
                    n = Integer.parseInt(string2);
                }
                if (!URI.isDigit(string2.charAt(n))) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append(string2);
                    ((StringBuffer)charSequence).append(" is invalid. Port should only contain digits!");
                    throw new MalformedURIException(((StringBuffer)charSequence).toString());
                }
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                n = n5;
            }
        }
        this.setHost(string3);
        this.setPort(n);
        this.setUserinfo((String)charSequence);
    }

    private void initializePath(String charSequence, int n) throws MalformedURIException {
        block22: {
            block21: {
                int n2;
                char c;
                int n3;
                char c2;
                int n4;
                block20: {
                    if (charSequence == null) break block22;
                    n4 = ((String)charSequence).length();
                    c2 = '\u0000';
                    for (n3 = n; n3 < n4; ++n3) {
                        block25: {
                            block24: {
                                block23: {
                                    c2 = c = ((String)charSequence).charAt(n3);
                                    if (c == '?') break;
                                    if (c == '#') {
                                        c2 = c;
                                        break;
                                    }
                                    if (c != '%') break block23;
                                    c2 = n3 + 2;
                                    if (c2 >= n4 || !URI.isHex(((String)charSequence).charAt(n3 + 1)) || !URI.isHex(((String)charSequence).charAt(c2))) {
                                        throw new MalformedURIException("Path contains invalid escape sequence!");
                                    }
                                    break block24;
                                }
                                if (!URI.isURICharacter(c)) break block25;
                            }
                            c2 = c;
                            continue;
                        }
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append("Path contains invalid character: ");
                        ((StringBuffer)charSequence).append(c);
                        throw new MalformedURIException(((StringBuffer)charSequence).toString());
                    }
                    this.m_path = ((String)charSequence).substring(n, n3);
                    n = c2;
                    n2 = n3++;
                    if (c2 != '?') break block20;
                    n = n3;
                    while (true) {
                        block27: {
                            block26: {
                                if (n >= n4) break block26;
                                c = ((String)charSequence).charAt(n);
                                if (c != '#') break block27;
                                c2 = c;
                            }
                            this.m_queryString = ((String)charSequence).substring(n3, n);
                            n2 = n;
                            n = c2;
                            break block20;
                        }
                        if (c == '%') {
                            c2 = n + 2;
                            if (c2 >= n4 || !URI.isHex(((String)charSequence).charAt(n + 1)) || !URI.isHex(((String)charSequence).charAt(c2))) {
                                throw new MalformedURIException("Query string contains invalid escape sequence!");
                            }
                        } else if (!URI.isURICharacter(c)) break;
                        ++n;
                        c2 = c;
                    }
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("Query string contains invalid character:");
                    ((StringBuffer)charSequence).append(c);
                    throw new MalformedURIException(((StringBuffer)charSequence).toString());
                }
                if (n == 35) {
                    c2 = n2 + 1;
                    n = c2;
                    while (true) {
                        if (n >= n4) {
                            this.m_fragment = ((String)charSequence).substring(c2, n);
                            break block21;
                        }
                        c = ((String)charSequence).charAt(n);
                        if (c == '%') {
                            n3 = n + 2;
                            if (n3 >= n4 || !URI.isHex(((String)charSequence).charAt(n + 1)) || !URI.isHex(((String)charSequence).charAt(n3))) {
                                throw new MalformedURIException("Fragment contains invalid escape sequence!");
                            }
                        } else if (!URI.isURICharacter(c)) break;
                        ++n;
                    }
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("Fragment contains invalid character:");
                    ((StringBuffer)charSequence).append(c);
                    throw new MalformedURIException(((StringBuffer)charSequence).toString());
                }
            }
            return;
        }
        throw new MalformedURIException("Cannot initialize path from null string!");
    }

    private void initializeScheme(String string2) throws MalformedURIException {
        char c;
        int n;
        int n2 = string2.length();
        for (n = 0; n < n2 && (c = string2.charAt(n)) != ':' && c != '/' && c != '?' && c != '#'; ++n) {
        }
        if ((string2 = string2.substring(0, n)).length() != 0) {
            this.setScheme(string2);
            return;
        }
        throw new MalformedURIException("No scheme found in URI.");
    }

    private static boolean isAlpha(char c) {
        boolean bl = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        return bl;
    }

    private static boolean isAlphanum(char c) {
        boolean bl = c <= 'z' && (fgLookupTable[c] & 0x30) != 0;
        return bl;
    }

    public static boolean isConformantSchemeName(String string2) {
        if (string2 != null && string2.trim().length() != 0) {
            if (!URI.isAlpha(string2.charAt(0))) {
                return false;
            }
            int n = 1;
            while (true) {
                if (n >= string2.length()) {
                    return true;
                }
                if (!URI.isSchemeCharacter(string2.charAt(n))) {
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        boolean bl = c >= '0' && c <= '9';
        return bl;
    }

    private static boolean isHex(char c) {
        boolean bl = c <= 'f' && (fgLookupTable[c] & 0x40) != 0;
        return bl;
    }

    private static boolean isReservedCharacter(char c) {
        boolean bl = true;
        if (c > ']' || (fgLookupTable[c] & 1) == 0) {
            bl = false;
        }
        return bl;
    }

    private static boolean isSchemeCharacter(char c) {
        boolean bl = c <= 'z' && (fgLookupTable[c] & 0x34) != 0;
        return bl;
    }

    private static boolean isURICharacter(char c) {
        boolean bl = c <= '~' && (fgLookupTable[c] & 0x33) != 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isURIString(String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '%') {
                int n3 = n2 + 2;
                if (n3 >= n || !URI.isHex(string2.charAt(n2 + 1)) || !URI.isHex(string2.charAt(n3))) return false;
                n2 = n3;
            } else if (!URI.isURICharacter(c)) return false;
            ++n2;
        }
        return true;
    }

    private static boolean isUnreservedCharacter(char c) {
        boolean bl = c <= '~' && (fgLookupTable[c] & 0x32) != 0;
        return bl;
    }

    private static boolean isUserinfoCharacter(char c) {
        boolean bl = c <= 'z' && (fgLookupTable[c] & 0x3A) != 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWellFormedAddress(String string2) {
        int n;
        if (string2 == null) {
            return false;
        }
        String string3 = string2.trim();
        int n2 = string3.length();
        if (n2 == 0 || n2 > 255 || string3.startsWith(".") || string3.startsWith("-")) return false;
        int n3 = n = string3.lastIndexOf(46);
        if (string3.endsWith(".")) {
            n3 = string3.substring(0, n).lastIndexOf(46);
        }
        if (++n3 < n2 && URI.isDigit(string2.charAt(n3))) {
            n3 = 0;
            n = 0;
            while (true) {
                if (n3 >= n2) {
                    if (n == 3) return true;
                    return false;
                }
                char c = string3.charAt(n3);
                if (c == '.') {
                    int n4;
                    if (!URI.isDigit(string3.charAt(n3 - 1)) || (n4 = n3 + 1) < n2 && !URI.isDigit(string3.charAt(n4))) return false;
                    ++n;
                } else if (!URI.isDigit(c)) {
                    return false;
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            char c = string3.charAt(n3);
            if (c == '.') {
                if (!URI.isAlphanum(string3.charAt(n3 - 1))) {
                    return false;
                }
                n = n3 + 1;
                if (n < n2 && !URI.isAlphanum(string3.charAt(n))) {
                    return false;
                }
            } else if (!URI.isAlphanum(c) && c != '-') {
                return false;
            }
            ++n3;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void appendPath(String var1_1) throws MalformedURIException {
        block3: {
            block4: {
                block8: {
                    block5: {
                        block7: {
                            block6: {
                                if (var1_1 == null || var1_1.trim().length() == 0) break block3;
                                if (!URI.isURIString(var1_1)) break block4;
                                var2_2 = this.m_path;
                                if (var2_2 == null || var2_2.trim().length() == 0) break block5;
                                if (!this.m_path.endsWith("/")) break block6;
                                if (!var1_1.startsWith("/")) ** GOTO lbl-1000
                                var2_2 = this.m_path;
                                var1_1 = var1_1.substring(1);
                                break block7;
                            }
                            if (var1_1.startsWith("/")) lbl-1000:
                            // 2 sources

                            {
                                var2_2 = this.m_path;
                            } else {
                                var2_2 = this.m_path;
                                var3_3 = new StringBuffer();
                                var3_3.append("/");
                                var3_3.append(var1_1);
                                var1_1 = var3_3.toString();
                            }
                        }
                        var1_1 = var2_2.concat(var1_1);
                        break block8;
                    }
                    if (!var1_1.startsWith("/")) {
                        var2_2 = new StringBuffer();
                        var2_2.append("/");
                        var2_2.append(var1_1);
                        var1_1 = var2_2.toString();
                    }
                }
                this.m_path = var1_1;
                return;
            }
            throw new MalformedURIException("Path contains invalid character!");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            String string2;
            object = (URI)object;
            String string3 = this.m_scheme;
            if ((string3 == null && ((URI)object).m_scheme == null || string3 != null && (string2 = ((URI)object).m_scheme) != null && string3.equals(string2)) && ((string2 = this.m_userinfo) == null && ((URI)object).m_userinfo == null || string2 != null && (string3 = ((URI)object).m_userinfo) != null && string2.equals(string3)) && ((string3 = this.m_host) == null && ((URI)object).m_host == null || string3 != null && (string2 = ((URI)object).m_host) != null && string3.equals(string2)) && this.m_port == ((URI)object).m_port && ((string3 = this.m_path) == null && ((URI)object).m_path == null || string3 != null && (string2 = ((URI)object).m_path) != null && string3.equals(string2)) && ((string2 = this.m_queryString) == null && ((URI)object).m_queryString == null || string2 != null && (string3 = ((URI)object).m_queryString) != null && string2.equals(string3)) && ((string3 = this.m_fragment) == null && ((URI)object).m_fragment == null || string3 != null && (object = ((URI)object).m_fragment) != null && string3.equals(object))) {
                return true;
            }
        }
        return false;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (bl && this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (bl2 && this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public int getPort() {
        return this.m_port;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != -1) {
            stringBuffer.append("//");
        }
        if ((string2 = this.m_userinfo) != null) {
            stringBuffer.append(string2);
            stringBuffer.append('@');
        }
        if ((string2 = this.m_host) != null) {
            stringBuffer.append(string2);
        }
        if (this.m_port != -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.m_port);
        }
        if ((string2 = this.m_path) != null) {
            stringBuffer.append(string2);
        }
        if (this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public boolean isGenericURI() {
        boolean bl = this.m_host != null;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFragment(String string2) throws MalformedURIException {
        if (string2 == null) {
            string2 = null;
        } else {
            if (!this.isGenericURI()) throw new MalformedURIException("Fragment can only be set for a generic URI!");
            if (this.getPath() == null) throw new MalformedURIException("Fragment cannot be set when path is null!");
            if (!URI.isURIString(string2)) throw new MalformedURIException("Fragment contains invalid character!");
        }
        this.m_fragment = string2;
    }

    public void setHost(String string2) throws MalformedURIException {
        if (string2 != null && string2.trim().length() != 0) {
            if (!URI.isWellFormedAddress(string2)) {
                throw new MalformedURIException("Host is not a well formed address!");
            }
        } else {
            this.m_host = string2;
            this.m_userinfo = null;
            this.m_port = -1;
        }
        this.m_host = string2;
    }

    public void setPath(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(string2, 0);
        }
    }

    public void setPort(int n) throws MalformedURIException {
        block7: {
            block6: {
                block5: {
                    if (n < 0 || n > 65535) break block5;
                    if (this.m_host == null) {
                        throw new MalformedURIException("Port cannot be set when host is null!");
                    }
                    break block6;
                }
                if (n != -1) break block7;
            }
            this.m_port = n;
            return;
        }
        throw new MalformedURIException("Invalid port number!");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setQueryString(String string2) throws MalformedURIException {
        if (string2 == null) {
            string2 = null;
        } else {
            if (!this.isGenericURI()) throw new MalformedURIException("Query string can only be set for a generic URI!");
            if (this.getPath() == null) throw new MalformedURIException("Query string cannot be set when path is null!");
            if (!URI.isURIString(string2)) throw new MalformedURIException("Query string contains invalid character!");
        }
        this.m_queryString = string2;
    }

    public void setScheme(String string2) throws MalformedURIException {
        if (string2 != null) {
            if (URI.isConformantSchemeName(string2)) {
                this.m_scheme = string2.toLowerCase();
                return;
            }
            throw new MalformedURIException("The scheme is not conformant.");
        }
        throw new MalformedURIException("Cannot set scheme from null string!");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setUserinfo(String charSequence) throws MalformedURIException {
        if (charSequence == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException("Userinfo cannot be set when host is null!");
            }
            int n = ((String)charSequence).length();
            for (int i = 0; i < n; ++i) {
                char c = ((String)charSequence).charAt(i);
                if (c == '%') {
                    int n2 = i + 2;
                    if (n2 < n && URI.isHex(((String)charSequence).charAt(i + 1)) && URI.isHex(((String)charSequence).charAt(n2))) continue;
                    throw new MalformedURIException("Userinfo contains invalid escape sequence!");
                }
                if (URI.isUserinfoCharacter(c)) continue;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("Userinfo contains invalid character:");
                ((StringBuffer)charSequence).append(c);
                throw new MalformedURIException(((StringBuffer)charSequence).toString());
            }
        }
        this.m_userinfo = charSequence;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.m_scheme;
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getSchemeSpecificPart());
        return stringBuffer.toString();
    }

    public static class MalformedURIException
    extends IOException {
        public MalformedURIException() {
        }

        public MalformedURIException(String string2) {
            super(string2);
        }
    }
}

