/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class XML11Char {
    public static final int MASK_XML11_CONTENT = 32;
    public static final int MASK_XML11_CONTROL = 16;
    public static final int MASK_XML11_NAME = 8;
    public static final int MASK_XML11_NAME_START = 4;
    public static final int MASK_XML11_NCNAME = 128;
    public static final int MASK_XML11_NCNAME_START = 64;
    public static final int MASK_XML11_SPACE = 2;
    public static final int MASK_XML11_VALID = 1;
    public static final byte[] XML11CHARS;

    static {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        int[] nArray;
        XML11CHARS = new byte[65536];
        int n = 8;
        int[] nArray2 = nArray = new int[8];
        nArray[0] = 33;
        nArray2[1] = 126;
        nArray2[2] = 160;
        nArray2[3] = 8231;
        nArray2[4] = 8233;
        nArray2[5] = 55295;
        nArray2[6] = 57344;
        nArray2[7] = 65533;
        int[] nArray3 = objectArray3 = new int[10];
        objectArray3[0] = 1;
        nArray3[1] = 8;
        nArray3[2] = 11;
        nArray3[3] = 12;
        nArray3[4] = 14;
        nArray3[5] = 31;
        nArray3[6] = 127;
        nArray3[7] = 132;
        nArray3[8] = 134;
        nArray3[9] = 159;
        int[] nArray4 = objectArray2 = new int[24];
        objectArray2[0] = 58;
        nArray4[1] = 58;
        nArray4[2] = 65;
        nArray4[3] = 90;
        nArray4[4] = 95;
        nArray4[5] = 95;
        nArray4[6] = 97;
        nArray4[7] = 122;
        nArray4[8] = 192;
        nArray4[9] = 767;
        nArray4[10] = 880;
        nArray4[11] = 893;
        nArray4[12] = 895;
        nArray4[13] = 8191;
        nArray4[14] = 8204;
        nArray4[15] = 8205;
        nArray4[16] = 8304;
        nArray4[17] = 8591;
        nArray4[18] = 11264;
        nArray4[19] = 12271;
        nArray4[20] = 12289;
        nArray4[21] = 55295;
        nArray4[22] = 63744;
        nArray4[23] = 65533;
        int[] nArray5 = objectArray = new int[12];
        objectArray[0] = 45;
        nArray5[1] = 45;
        nArray5[2] = 46;
        nArray5[3] = 46;
        nArray5[4] = 48;
        nArray5[5] = 57;
        nArray5[6] = 183;
        nArray5[7] = 183;
        nArray5[8] = 768;
        nArray5[9] = 879;
        nArray5[10] = 8255;
        nArray5[11] = 8256;
        int n2 = 0;
        int n3 = 0;
        block0: while (true) {
            byte[] byArray;
            if (n3 >= n) {
                n3 = 0;
                while (true) {
                    if (n3 >= 6) {
                        n3 = 0;
                        block2: while (true) {
                            if (n3 >= 10) {
                                n3 = 0;
                                block3: while (true) {
                                    if (n3 >= 24) {
                                        n3 = 0;
                                        block4: while (true) {
                                            if (n3 >= 12) {
                                                objectArray = XML11CHARS;
                                                objectArray[58] = (byte)(objectArray[58] & 0xFFFFFF3F);
                                                n3 = n2;
                                                while (true) {
                                                    if (n3 >= 5) {
                                                        return;
                                                    }
                                                    objectArray = XML11CHARS;
                                                    n = (new int[]{60, 38, 10, 13, 93})[n3];
                                                    objectArray[n] = (byte)(objectArray[n] & 0xFFFFFFDF);
                                                    ++n3;
                                                }
                                            }
                                            n = objectArray[n3];
                                            while (true) {
                                                if (n > objectArray[n3 + 1]) {
                                                    n3 += 2;
                                                    continue block4;
                                                }
                                                objectArray2 = XML11CHARS;
                                                objectArray2[n] = (byte)(objectArray2[n] | 0x88);
                                                ++n;
                                            }
                                            break;
                                        }
                                    }
                                    n = objectArray2[n3];
                                    while (true) {
                                        if (n > objectArray2[n3 + 1]) {
                                            n3 += 2;
                                            continue block3;
                                        }
                                        objectArray3 = XML11CHARS;
                                        objectArray3[n] = (byte)(objectArray3[n] | 0xCC);
                                        ++n;
                                    }
                                    break;
                                }
                            }
                            n = objectArray3[n3];
                            while (true) {
                                if (n > objectArray3[n3 + 1]) {
                                    n3 += 2;
                                    continue block2;
                                }
                                byArray = XML11CHARS;
                                byArray[n] = (byte)(byArray[n] | 0x11);
                                ++n;
                            }
                            break;
                        }
                    }
                    byArray = XML11CHARS;
                    n = (new int[]{9, 10, 13, 32, 133, 8232})[n3];
                    byArray[n] = (byte)(byArray[n] | 0x23);
                    ++n3;
                }
            }
            int n4 = nArray[n3];
            while (true) {
                if (n4 > nArray[n3 + 1]) {
                    n3 += 2;
                    continue block0;
                }
                byArray = XML11CHARS;
                byArray[n4] = (byte)(byArray[n4] | 0x21);
                ++n4;
                n = 8;
            }
            break;
        }
    }

    public static boolean isXML11Content(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 0x20) != 0 || 65536 <= n && n <= 0x10FFFF;
        return bl;
    }

    public static boolean isXML11Invalid(int n) {
        return XML11Char.isXML11Valid(n) ^ true;
    }

    public static boolean isXML11NCName(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 0x80) != 0 || 65536 <= n && n < 983040;
        return bl;
    }

    public static boolean isXML11NCNameStart(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 0x40) != 0 || 65536 <= n && n < 983040;
        return bl;
    }

    public static boolean isXML11Name(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 8) != 0 || n >= 65536 && n < 983040;
        return bl;
    }

    public static boolean isXML11NameStart(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 4) != 0 || 65536 <= n && n < 983040;
        return bl;
    }

    public static boolean isXML11Space(int n) {
        boolean bl = n < 65536 && (XML11CHARS[n] & 2) != 0;
        return bl;
    }

    public static boolean isXML11Valid(int n) {
        boolean bl;
        block3: {
            boolean bl2;
            block2: {
                bl2 = true;
                if (n >= 65536) break block2;
                bl = bl2;
                if ((XML11CHARS[n] & 1) != 0) break block3;
            }
            bl = 65536 <= n && n <= 0x10FFFF ? bl2 : false;
        }
        return bl;
    }

    public static boolean isXML11ValidLiteral(int n) {
        boolean bl;
        block3: {
            boolean bl2;
            block2: {
                byte[] byArray;
                bl2 = true;
                if (n >= 65536 || ((byArray = XML11CHARS)[n] & 1) == 0) break block2;
                bl = bl2;
                if ((byArray[n] & 0x10) == 0) break block3;
            }
            bl = 65536 <= n && n <= 0x10FFFF ? bl2 : false;
        }
        return bl;
    }

    public static boolean isXML11ValidNCName(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        if (!XML11Char.isXML11NCNameStart(string2.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string2.length()) {
            if (!XML11Char.isXML11NCName(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isXML11ValidName(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        if (!XML11Char.isXML11NameStart(string2.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string2.length()) {
            if (!XML11Char.isXML11Name(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isXML11ValidNmtoken(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string2.length()) {
            if (!XML11Char.isXML11Name(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

