/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected Attribute[] fAttributes = new Attribute[4];
    protected Augmentations[] fAugmentations = new AugmentationsImpl[4];
    protected int fLength;
    protected boolean fNamespaces = true;

    public XMLAttributesImpl() {
        int n = 0;
        Attribute[] attributeArray;
        while (n < (attributeArray = this.fAttributes).length) {
            attributeArray[n] = new Attribute();
            this.fAugmentations[n] = new AugmentationsImpl();
            ++n;
        }
        return;
    }

    @Override
    public int addAttribute(QName qName, String string2, String string3) {
        AugmentationsImpl[] augmentationsImplArray;
        int n = qName.uri != null && !qName.uri.equals("") ? this.getIndex(qName.uri, qName.localpart) : this.getIndex(qName.rawname);
        int n2 = n;
        if (n == -1) {
            int n3 = this.fLength;
            this.fLength = n3 + 1;
            Attribute[] attributeArray = this.fAttributes;
            n2 = n3;
            if (n3 == attributeArray.length) {
                n2 = attributeArray.length + 4;
                Attribute[] attributeArray2 = new Attribute[n2];
                augmentationsImplArray = new AugmentationsImpl[attributeArray.length + 4];
                System.arraycopy(attributeArray, 0, attributeArray2, 0, attributeArray.length);
                System.arraycopy(this.fAugmentations, 0, augmentationsImplArray, 0, this.fAttributes.length);
                n = this.fAttributes.length;
                while (true) {
                    if (n >= n2) {
                        this.fAttributes = attributeArray2;
                        this.fAugmentations = augmentationsImplArray;
                        n2 = n3;
                        break;
                    }
                    attributeArray2[n] = new Attribute();
                    augmentationsImplArray[n] = new AugmentationsImpl();
                    ++n;
                }
            }
        }
        this.fAugmentations[n2].removeAllItems();
        augmentationsImplArray = this.fAttributes[n2];
        augmentationsImplArray.name.setValues(qName);
        augmentationsImplArray.type = string2;
        augmentationsImplArray.value = string3;
        augmentationsImplArray.nonNormalizedValue = string3;
        augmentationsImplArray.specified = false;
        return n2;
    }

    @Override
    public Augmentations getAugmentations(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fAugmentations[n];
        }
        return null;
    }

    @Override
    public Augmentations getAugmentations(String object) {
        int n = this.getIndex((String)object);
        object = n != -1 ? this.fAugmentations[n] : null;
        return object;
    }

    @Override
    public Augmentations getAugmentations(String object, String string2) {
        int n = this.getIndex((String)object, string2);
        object = n != -1 ? this.fAugmentations[n] : null;
        return object;
    }

    @Override
    public int getIndex(String string2) {
        int n = 0;
        while (n < this.fLength) {
            Attribute attribute = this.fAttributes[n];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getIndex(String string2, String string3) {
        int n = 0;
        while (n < this.fLength) {
            Attribute attribute = this.fAttributes[n];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(string3) && (string2 == attribute.name.uri || string2 != null && attribute.name.uri != null && attribute.name.uri.equals(string2))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public String getLocalName(int n) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n >= 0 && n < this.fLength) {
            return this.fAttributes[n].name.localpart;
        }
        return null;
    }

    public String getName(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fAttributes[n].name.rawname;
        }
        return null;
    }

    @Override
    public void getName(int n, QName qName) {
        qName.setValues(this.fAttributes[n].name);
    }

    @Override
    public String getNonNormalizedValue(int n) {
        return this.fAttributes[n].nonNormalizedValue;
    }

    @Override
    public String getPrefix(int n) {
        if (n >= 0 && n < this.fLength) {
            String string2 = this.fAttributes[n].name.prefix;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getQName(int n) {
        if (n >= 0 && n < this.fLength) {
            String string2 = this.fAttributes[n].name.rawname;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
        return null;
    }

    public boolean getSchemaId(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fAttributes[n].schemaId;
        }
        return false;
    }

    public boolean getSchemaId(String string2) {
        int n = this.getIndex(string2);
        boolean bl = n != -1 ? this.fAttributes[n].schemaId : false;
        return bl;
    }

    public boolean getSchemaId(String string2, String string3) {
        boolean bl = this.fNamespaces;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        int n = this.getIndex(string2, string3);
        if (n != -1) {
            bl2 = this.fAttributes[n].schemaId;
        }
        return bl2;
    }

    @Override
    public String getType(int n) {
        if (n >= 0 && n < this.fLength) {
            String string2;
            String string3 = string2 = this.fAttributes[n].type;
            if (string2.indexOf(40) == 0) {
                string3 = string2;
                if (string2.lastIndexOf(41) == string2.length() - 1) {
                    string3 = "NMTOKEN";
                }
            }
            return string3;
        }
        return null;
    }

    @Override
    public String getType(String string2) {
        int n = this.getIndex(string2);
        string2 = n != -1 ? this.getType(n) : null;
        return string2;
    }

    @Override
    public String getType(String string2, String string3) {
        boolean bl = this.fNamespaces;
        Object var4_4 = null;
        if (!bl) {
            return null;
        }
        int n = this.getIndex(string2, string3);
        string2 = var4_4;
        if (n != -1) {
            string2 = this.getType(n);
        }
        return string2;
    }

    @Override
    public String getURI(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fAttributes[n].name.uri;
        }
        return null;
    }

    @Override
    public String getValue(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fAttributes[n].value;
        }
        return null;
    }

    @Override
    public String getValue(String string2) {
        int n = this.getIndex(string2);
        string2 = n != -1 ? this.fAttributes[n].value : null;
        return string2;
    }

    @Override
    public String getValue(String string2, String string3) {
        int n = this.getIndex(string2, string3);
        string2 = n != -1 ? this.getValue(n) : null;
        return string2;
    }

    @Override
    public boolean isSpecified(int n) {
        return this.fAttributes[n].specified;
    }

    @Override
    public void removeAllAttributes() {
        this.fLength = 0;
    }

    @Override
    public void removeAttributeAt(int n) {
        int n2 = this.fLength;
        if (n < n2 - 1) {
            Object[] objectArray = this.fAttributes;
            Attribute attribute = objectArray[n];
            Augmentations augmentations = this.fAugmentations[n];
            int n3 = n + 1;
            System.arraycopy(objectArray, n3, objectArray, n, n2 - n - 1);
            objectArray = this.fAugmentations;
            System.arraycopy(objectArray, n3, objectArray, n, this.fLength - n - 1);
            objectArray = this.fAttributes;
            n = this.fLength;
            objectArray[n - 1] = attribute;
            this.fAugmentations[n - 1] = augmentations;
        }
        --this.fLength;
    }

    @Override
    public void setAugmentations(int n, Augmentations augmentations) {
        this.fAugmentations[n] = augmentations;
    }

    @Override
    public void setName(int n, QName qName) {
        this.fAttributes[n].name.setValues(qName);
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    @Override
    public void setNonNormalizedValue(int n, String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = this.fAttributes[n].value;
        }
        this.fAttributes[n].nonNormalizedValue = string3;
    }

    public void setSchemaId(int n, boolean bl) {
        this.fAttributes[n].schemaId = bl;
    }

    @Override
    public void setSpecified(int n, boolean bl) {
        this.fAttributes[n].specified = bl;
    }

    @Override
    public void setType(int n, String string2) {
        this.fAttributes[n].type = string2;
    }

    public void setURI(int n, String string2) {
        this.fAttributes[n].name.uri = string2;
    }

    @Override
    public void setValue(int n, String string2) {
        Attribute attribute = this.fAttributes[n];
        attribute.value = string2;
        attribute.nonNormalizedValue = string2;
    }

    static class Attribute {
        public QName name = new QName();
        public String nonNormalizedValue;
        public boolean schemaId;
        public boolean specified;
        public String type;
        public String value;

        Attribute() {
        }
    }
}

