/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    private static final boolean DEBUG = false;
    protected static final int TABLE_SIZE = 11;
    protected int fGrammarCount = 0;
    protected Entry[] fGrammars = null;
    protected boolean fPoolIsLocked;

    public XMLGrammarPoolImpl() {
        this.fGrammars = new Entry[11];
        this.fPoolIsLocked = false;
    }

    public XMLGrammarPoolImpl(int n) {
        this.fGrammars = new Entry[n];
        this.fPoolIsLocked = false;
    }

    @Override
    public void cacheGrammars(String string2, Grammar[] grammarArray) {
        if (!this.fPoolIsLocked) {
            for (int i = 0; i < grammarArray.length; ++i) {
                this.putGrammar(grammarArray[i]);
            }
        }
    }

    @Override
    public void clear() {
        int n = 0;
        while (true) {
            Entry[] entryArray;
            if (n >= (entryArray = this.fGrammars).length) {
                this.fGrammarCount = 0;
                return;
            }
            if (entryArray[n] != null) {
                entryArray[n].clear();
                this.fGrammars[n] = null;
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode(xMLGrammarDescription);
            Entry[] entryArray2 = this.fGrammars;
            Entry entry = entryArray2[(Integer.MAX_VALUE & n) % entryArray2.length];
            void var4_6;
            while (var4_6 != null) {
                if (var4_6.hash == n && this.equals(var4_6.desc, xMLGrammarDescription)) {
                    return true;
                }
                Entry entry2 = var4_6.next;
            }
            return false;
        }
    }

    public boolean equals(XMLGrammarDescription xMLGrammarDescription, XMLGrammarDescription xMLGrammarDescription2) {
        return xMLGrammarDescription.equals(xMLGrammarDescription2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Grammar getGrammar(XMLGrammarDescription object) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode((XMLGrammarDescription)object);
            Entry[] entryArray2 = this.fGrammars;
            Entry entry = entryArray2[(Integer.MAX_VALUE & n) % entryArray2.length];
            void var4_6;
            while (var4_6 != null) {
                if (var4_6.hash == n && this.equals(var4_6.desc, (XMLGrammarDescription)object)) {
                    return var4_6.grammar;
                }
                Entry entry2 = var4_6.next;
            }
            return null;
        }
    }

    public int hashCode(XMLGrammarDescription xMLGrammarDescription) {
        return xMLGrammarDescription.hashCode();
    }

    @Override
    public void lockPool() {
        this.fPoolIsLocked = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putGrammar(Grammar grammar) {
        if (this.fPoolIsLocked) return;
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            XMLGrammarDescription xMLGrammarDescription = grammar.getGrammarDescription();
            int n = this.hashCode(xMLGrammarDescription);
            Entry[] entryArray2 = this.fGrammars;
            int n2 = (Integer.MAX_VALUE & n) % entryArray2.length;
            Entry entry = entryArray2[n2];
            while (true) {
                void var5_7;
                if (var5_7 == null) {
                    Entry entry2;
                    this.fGrammars[n2] = entry2 = new Entry(n, xMLGrammarDescription, grammar, this.fGrammars[n2]);
                    ++this.fGrammarCount;
                    return;
                }
                if (var5_7.hash == n && this.equals(var5_7.desc, xMLGrammarDescription)) {
                    var5_7.grammar = grammar;
                    return;
                }
                Entry entry3 = var5_7.next;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Grammar removeGrammar(XMLGrammarDescription object) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode((XMLGrammarDescription)object);
            Entry[] entryArray2 = this.fGrammars;
            int n2 = (Integer.MAX_VALUE & n) % entryArray2.length;
            Entry entry = entryArray2[n2];
            Object var6_9 = null;
            void var4_6;
            while (var4_6 != null) {
                if (var4_6.hash == n && this.equals(var4_6.desc, (XMLGrammarDescription)object)) {
                    void var6_10;
                    if (var6_10 != null) {
                        var6_10.next = var4_6.next;
                    } else {
                        this.fGrammars[n2] = var4_6.next;
                    }
                    object = var4_6.grammar;
                    var4_6.grammar = null;
                    --this.fGrammarCount;
                    return object;
                }
                Entry entry2 = var4_6.next;
                void var6_11 = var4_6;
                Entry entry3 = entry2;
            }
            return null;
        }
    }

    @Override
    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        return this.getGrammar(xMLGrammarDescription);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Grammar[] retrieveInitialGrammarSet(String grammarArray) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.fGrammars.length;
            Grammar[] grammarArray2 = new Grammar[this.fGrammarCount];
            int n2 = 0;
            int n3 = 0;
            block3: while (true) {
                if (n2 >= n) {
                    grammarArray = new Grammar[n3];
                    System.arraycopy(grammarArray2, 0, grammarArray, 0, n3);
                    return grammarArray;
                }
                Entry entry = this.fGrammars[n2];
                while (true) {
                    if (entry == null) {
                        ++n2;
                        continue block3;
                    }
                    int n4 = n3;
                    if (entry.desc.getGrammarType().equals(grammarArray)) {
                        grammarArray2[n3] = entry.grammar;
                        n4 = n3 + 1;
                    }
                    entry = entry.next;
                    n3 = n4;
                }
                break;
            }
        }
    }

    @Override
    public void unlockPool() {
        this.fPoolIsLocked = false;
    }

    protected static final class Entry {
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public int hash;
        public Entry next;

        protected Entry(int n, XMLGrammarDescription xMLGrammarDescription, Grammar grammar, Entry entry) {
            this.hash = n;
            this.desc = xMLGrammarDescription;
            this.grammar = grammar;
            this.next = entry;
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            Entry entry = this.next;
            if (entry != null) {
                entry.clear();
                this.next = null;
            }
        }
    }
}

