/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.IndentPrinter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriterFilter;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    static /* synthetic */ Class class$java$lang$String;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;
    private int _elementStateCount;
    private ElementState[] _elementStates;
    protected EncodingInfo _encodingInfo;
    protected OutputFormat _format;
    protected boolean _indenting;
    private OutputStream _output;
    private Vector _preRoot;
    protected Hashtable _prefixes;
    private boolean _prepared;
    protected Printer _printer;
    protected boolean _started;
    private Writer _writer;
    protected Node fCurrentNode = null;
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected DOMErrorHandler fDOMErrorHandler;
    protected DOMWriterFilter fDOMFilter;
    protected Hashtable fFeatures;
    protected final StringBuffer fStrBuffer = new StringBuffer(40);

    protected BaseMarkupSerializer(OutputFormat outputFormat) {
        this._elementStates = new ElementState[10];
        int n = 0;
        while (true) {
            ElementState[] elementStateArray;
            if (n >= (elementStateArray = this._elementStates).length) {
                this._format = outputFormat;
                return;
            }
            elementStateArray[n] = new ElementState();
            ++n;
        }
    }

    static /* synthetic */ Class class$(String object) {
        try {
            object = Class.forName((String)object);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    public ContentHandler asContentHandler() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public DOMSerializer asDOMSerializer() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public DocumentHandler asDocumentHandler() throws IOException {
        this.prepare();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void attributeDecl(String string2, String string3, String string4, String string5, String string6) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ATTLIST ");
            this._printer.printText(string2);
            this._printer.printText(' ');
            this._printer.printText(string3);
            this._printer.printText(' ');
            this._printer.printText(string4);
            if (string5 != null) {
                this._printer.printText(' ');
                this._printer.printText(string5);
            }
            if (string6 != null) {
                this._printer.printText(" \"");
                this.printEscaped(string6);
                this._printer.printText('\"');
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void characters(String string2) throws IOException {
        ElementState elementState = this.content();
        if (!elementState.inCData && !elementState.doCData) {
            if (elementState.preserveSpace) {
                int n = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(string2, true, elementState.unescaped);
                this._printer.setNextIndent(n);
            } else {
                this.printText(string2, false, elementState.unescaped);
            }
        } else {
            if (!elementState.inCData) {
                this._printer.printText("<![CDATA[");
                elementState.inCData = true;
            }
            int n = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printCDATAText(string2);
            this._printer.setNextIndent(n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void characters(char[] var1_1, int var2_3, int var3_4) throws SAXException {
        block10: {
            try {
                var4_5 = this.content();
                if (!var4_5.inCData && !var4_5.doCData) {
                    if (var4_5.preserveSpace) {
                        var5_6 = this._printer.getNextIndent();
                        this._printer.setNextIndent(0);
                        this.printText(var1_1, var2_3, var3_4, true, var4_5.unescaped);
                        this._printer.setNextIndent(var5_6);
                        return;
                    }
                    this.printText(var1_1, var2_3, var3_4, false, var4_5.unescaped);
                    return;
                }
                if (!var4_5.inCData) {
                    this._printer.printText("<![CDATA[");
                    var4_5.inCData = true;
                }
                var6_8 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
lbl17:
                // 2 sources

                while (true) {
                    if (var2_3 >= var3_4) {
                        this._printer.setNextIndent(var6_8);
                        return;
                    }
                    break;
                }
            }
            catch (IOException var1_2) {
                throw new SAXException(var1_2);
            }
            var7_9 = var1_1[var2_3];
            if (var7_9 != ']' || (var5_7 = var2_3 + 2) >= var3_4 || var1_1[var2_3 + 1] != ']' || var1_1[var5_7] != '>') ** GOTO lbl29
            {
                this._printer.printText("]]]]><![CDATA[>");
                var2_3 = var5_7;
                break block10;
lbl29:
                // 1 sources

                if (XMLChar.isValid(var7_9)) ** GOTO lbl42
                if (++var2_3 >= var3_4) ** GOTO lbl33
            }
            {
                this.surrogates(var7_9, var1_1[var2_3]);
                break block10;
lbl33:
                // 1 sources

                var4_5 = new StringBuffer();
                var4_5.append("The character '");
                var4_5.append(var7_9);
                var4_5.append("' is an invalid XML character");
                this.fatalError(var4_5.toString());
                break block10;
lbl42:
                // 1 sources

                if (!(var7_9 >= ' ' && this._encodingInfo.isPrintable(var7_9) && var7_9 != '\u00f7' || var7_9 == '\n' || var7_9 == '\r' || var7_9 == '\t')) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(var7_9));
                    this._printer.printText(";<![CDATA[");
                    break block10;
                }
                this._printer.printText(var7_9);
            }
        }
        ++var2_3;
        ** while (true)
    }

    public void comment(String string2) throws IOException {
        if (this._format.getOmitComments()) {
            return;
        }
        ElementState elementState = this.content();
        int n = string2.indexOf("-->");
        if (n >= 0) {
            StringBuffer stringBuffer = this.fStrBuffer;
            stringBuffer.append("<!--");
            stringBuffer.append(string2.substring(0, n));
            stringBuffer.append("-->");
        } else {
            StringBuffer stringBuffer = this.fStrBuffer;
            stringBuffer.append("<!--");
            stringBuffer.append(string2);
            stringBuffer.append("-->");
        }
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            if (this._indenting && !elementState.preserveSpace) {
                this._printer.breakLine();
            }
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                elementState.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
        elementState.afterComment = true;
        elementState.afterElement = false;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            String string2 = new String(cArray, n, n2);
            this.comment(string2);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected ElementState content() throws IOException {
        ElementState elementState = this.getElementState();
        if (!this.isDocumentState()) {
            if (elementState.inCData && !elementState.doCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (elementState.empty) {
                this._printer.printText('>');
                elementState.empty = false;
            }
            elementState.afterElement = false;
            elementState.afterComment = false;
        }
        return elementState;
    }

    @Override
    public void elementDecl(String string2, String string3) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ELEMENT ");
            this._printer.printText(string2);
            this._printer.printText(' ');
            this._printer.printText(string3);
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endCDATA() {
        this.getElementState().doCData = false;
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.serializePreRoot();
            this._printer.flush();
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public abstract void endElement(String var1) throws SAXException;

    @Override
    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    @Override
    public void endEntity(String string2) {
    }

    public void endNonEscaping() {
        this.getElementState().unescaped = false;
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    public void endPreserving() {
        this.getElementState().preserveSpace = false;
    }

    protected ElementState enterElementState(String string2, String string3, String string4, boolean bl) {
        int n = this._elementStateCount;
        Object object = this._elementStates;
        if (n + 1 == ((ElementState[])object).length) {
            int n2 = ((ElementState[])object).length + 10;
            ElementState[] elementStateArray = new ElementState[n2];
            n = 0;
            block0: while (true) {
                if (n >= ((ElementState[])(object = this._elementStates)).length) {
                    n = ((ElementState[])object).length;
                    while (true) {
                        if (n >= n2) {
                            this._elementStates = elementStateArray;
                            break block0;
                        }
                        elementStateArray[n] = new ElementState();
                        ++n;
                    }
                }
                elementStateArray[n] = object[n];
                ++n;
            }
        }
        this._elementStateCount = n = this._elementStateCount + 1;
        object = this._elementStates[n];
        object.namespaceURI = string2;
        object.localName = string3;
        object.rawName = string4;
        object.preserveSpace = bl;
        object.empty = true;
        object.afterElement = false;
        object.afterComment = false;
        object.inCData = false;
        object.doCData = false;
        object.unescaped = false;
        object.prefixes = this._prefixes;
        this._prefixes = null;
        return object;
    }

    @Override
    public void externalEntityDecl(String string2, String string3, String string4) throws SAXException {
        try {
            this._printer.enterDTD();
            this.unparsedEntityDecl(string2, string3, string4, null);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void fatalError(String string2) throws IOException {
        if (this.fDOMErrorHandler != null) {
            this.modifyDOMError(string2, (short)2, this.fCurrentNode);
            this.fDOMErrorHandler.handleError(this.fDOMError);
            return;
        }
        throw new IOException(string2);
    }

    protected ElementState getElementState() {
        return this._elementStates[this._elementStateCount];
    }

    protected abstract String getEntityRef(int var1);

    protected boolean getFeature(String string2) {
        return (Boolean)this.fFeatures.get(string2);
    }

    protected String getPrefix(String string2) {
        int n;
        Object object = this._prefixes;
        if (object != null && (object = (String)((Hashtable)object).get(string2)) != null) {
            return object;
        }
        int n2 = n = this._elementStateCount;
        if (n == 0) {
            return null;
        }
        while (n2 > 0) {
            if (this._elementStates[n2].prefixes != null && (object = (String)this._elementStates[n2].prefixes.get(string2)) != null) {
                return object;
            }
            --n2;
        }
        return null;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        block4: {
            try {
                this.content();
                if (!this._indenting) break block4;
                this._printer.setThisIndent(0);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            while (n2 > 0) {
                this._printer.printText(cArray[n]);
                ++n;
                --n2;
            }
        }
        return;
    }

    @Override
    public void internalEntityDecl(String string2, String string3) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ENTITY ");
            this._printer.printText(string2);
            this._printer.printText(" \"");
            this.printEscaped(string3);
            this._printer.printText("\">");
            if (this._indenting) {
                this._printer.breakLine();
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected boolean isDocumentState() {
        boolean bl = this._elementStateCount == 0;
        return bl;
    }

    protected ElementState leaveElementState() {
        int n = this._elementStateCount;
        if (n > 0) {
            this._prefixes = null;
            this._elementStateCount = --n;
            return this._elementStates[n];
        }
        throw new IllegalStateException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "Internal", null));
    }

    protected DOMError modifyDOMError(String string2, short s, Node node) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = string2;
        this.fDOMError.fSeverity = s;
        this.fDOMError.fLocator = new DOMLocatorImpl(-1, -1, -1, node, null);
        return this.fDOMError;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        try {
            block4: {
                block5: {
                    block3: {
                        this._printer.enterDTD();
                        if (string3 == null) break block3;
                        this._printer.printText("<!NOTATION ");
                        this._printer.printText(string2);
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(string3);
                        if (string4 == null) break block4;
                        this._printer.printText(' ');
                        break block5;
                    }
                    this._printer.printText("<!NOTATION ");
                    this._printer.printText(string2);
                    this._printer.printText(" SYSTEM ");
                }
                this.printDoctypeURL(string4);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void prepare() throws IOException {
        if (this._prepared) {
            return;
        }
        if (this._writer == null && this._output == null) {
            throw new IOException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null));
        }
        Object object = this._format.getEncodingInfo();
        this._encodingInfo = object;
        OutputStream outputStream = this._output;
        if (outputStream != null) {
            this._writer = ((EncodingInfo)object).getWriter(outputStream);
        }
        if (this._format.getIndenting()) {
            this._indenting = true;
            object = new IndentPrinter(this._writer, this._format);
        } else {
            this._indenting = false;
            object = new Printer(this._writer, this._format);
        }
        this._printer = object;
        this._elementStateCount = 0;
        object = this._elementStates[0];
        ((ElementState)object).namespaceURI = null;
        ((ElementState)object).localName = null;
        ((ElementState)object).rawName = null;
        ((ElementState)object).preserveSpace = this._format.getPreserveSpace();
        ((ElementState)object).empty = true;
        ((ElementState)object).afterElement = false;
        ((ElementState)object).afterComment = false;
        ((ElementState)object).inCData = false;
        ((ElementState)object).doCData = false;
        ((ElementState)object).prefixes = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
        this._started = false;
        this._prepared = true;
    }

    protected void printCDATAText(String string2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string2.charAt(n2);
            if (c == ']' && (n3 = n2 + 2) < n && string2.charAt(n2 + 1) == ']' && string2.charAt(n3) == '>') {
                if (this.fFeatures != null && this.fDOMErrorHandler != null) {
                    if (!this.getFeature("split-cdata-sections")) {
                        this.modifyDOMError(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null), (short)2, this.fCurrentNode);
                        if (!this.fDOMErrorHandler.handleError(this.fDOMError)) {
                            throw new IOException();
                        }
                    } else {
                        this.modifyDOMError(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null), (short)0, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                n2 = n3;
            } else if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (!(c >= ' ' && this._encodingInfo.isPrintable(c) && c != '\u00f7' || c == '\n' || c == '\r' || c == '\t')) {
                this._printer.printText("]]>&#x");
                this._printer.printText(Integer.toHexString(c));
                this._printer.printText(";<![CDATA[");
            } else {
                this._printer.printText(c);
            }
            ++n2;
        }
        return;
    }

    protected void printDoctypeURL(String string2) throws IOException {
        this._printer.printText('\"');
        int n = 0;
        while (true) {
            if (n >= string2.length()) {
                this._printer.printText('\"');
                return;
            }
            if (string2.charAt(n) != '\"' && string2.charAt(n) >= ' ' && string2.charAt(n) <= '\u007f') {
                this._printer.printText(string2.charAt(n));
            } else {
                this._printer.printText('%');
                this._printer.printText(Integer.toHexString(string2.charAt(n)));
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printEscaped(int n) throws IOException {
        Object object;
        block7: {
            block6: {
                block5: {
                    object = this.getEntityRef(n);
                    if (object == null) break block5;
                    this._printer.printText('&');
                    this._printer.printText((String)object);
                    break block6;
                }
                if (n >= 32 && this._encodingInfo.isPrintable((char)n) && n != 247 || n == 10 || n == 13 || n == 9) break block7;
                this._printer.printText("&#x");
                this._printer.printText(Integer.toHexString(n));
            }
            this._printer.printText(';');
            return;
        }
        if (n < 65536) {
            object = this._printer;
        } else {
            object = this._printer;
            ((Printer)object).printText((char)(((n -= 65536) >> 10) + 55296));
            object = this._printer;
            n = (n & 0x3FF) + 56320;
        }
        ((Printer)object).printText((char)n);
    }

    protected void printEscaped(String string2) throws IOException {
        int n = 0;
        while (n < string2.length()) {
            int n2 = string2.charAt(n);
            int n3 = n;
            int n4 = n2;
            if ((n2 & 0xFC00) == 55296) {
                int n5 = n + 1;
                n3 = n;
                n4 = n2;
                if (n5 < string2.length()) {
                    char c = string2.charAt(n5);
                    n3 = n;
                    n4 = n2;
                    if ((0xFC00 & c) == 56320) {
                        n4 = (n2 - 55296 << 10) + 65536 + c - 56320;
                        n3 = n5;
                    }
                }
            }
            this.printEscaped(n4);
            n = n3 + 1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n = 0;
        int n2 = 0;
        if (bl) {
            n = n2;
            while (true) {
                if (n >= string2.length()) {
                    return;
                }
                char c = string2.charAt(n);
                if (c != '\n' && c != '\r' && !bl2) {
                    this.printEscaped(c);
                } else {
                    this._printer.printText(c);
                }
                ++n;
            }
        }
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c != ' ' && c != '\f' && c != '\t' && c != '\n' && c != '\r') {
                if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printEscaped(c);
                }
            } else {
                this._printer.printSpace();
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printText(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3 = n;
        int n4 = n2;
        if (bl) {
            while (true) {
                if (n2 <= 0) {
                    return;
                }
                char c = cArray[n];
                ++n;
                if (c != '\n' && c != '\r' && !bl2) {
                    this.printEscaped(c);
                } else {
                    this._printer.printText(c);
                }
                --n2;
            }
        }
        while (n4 > 0) {
            char c = cArray[n3];
            ++n3;
            if (c != ' ' && c != '\f' && c != '\t' && c != '\n' && c != '\r') {
                if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printEscaped(c);
                }
            } else {
                this._printer.printSpace();
            }
            --n4;
        }
        return;
    }

    @Override
    public final void processingInstruction(String string2, String string3) throws SAXException {
        try {
            this.processingInstructionIO(string2, string3);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstructionIO(String string2, String string3) throws IOException {
        ElementState elementState = this.content();
        int n = string2.indexOf("?>");
        if (n >= 0) {
            StringBuffer stringBuffer = this.fStrBuffer;
            stringBuffer.append("<?");
            stringBuffer.append(string2.substring(0, n));
        } else {
            StringBuffer stringBuffer = this.fStrBuffer;
            stringBuffer.append("<?");
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            this.fStrBuffer.append(' ');
            n = string3.indexOf("?>");
            if (n >= 0) {
                this.fStrBuffer.append(string3.substring(0, n));
            } else {
                this.fStrBuffer.append(string3);
            }
        }
        this.fStrBuffer.append("?>");
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                elementState.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
    }

    public boolean reset() {
        if (this._elementStateCount <= 1) {
            this._prepared = false;
            this.fCurrentNode = null;
            this.fStrBuffer.setLength(0);
            return true;
        }
        throw new IllegalStateException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ResetInMiddle", null));
    }

    @Override
    public void serialize(Document document) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(document);
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() == null) {
            return;
        }
        throw this._printer.getException();
    }

    @Override
    public void serialize(DocumentFragment documentFragment) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(documentFragment);
        this._printer.flush();
        if (this._printer.getException() == null) {
            return;
        }
        throw this._printer.getException();
    }

    @Override
    public void serialize(Element element) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(element);
        this._printer.flush();
        if (this._printer.getException() == null) {
            return;
        }
        throw this._printer.getException();
    }

    protected abstract void serializeElement(Element var1) throws IOException;

    /*
     * Exception decompiling
     */
    protected void serializeNode(Node var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void serializePreRoot() throws IOException {
        if (this._preRoot != null) {
            int n = 0;
            while (true) {
                if (n >= this._preRoot.size()) {
                    this._preRoot.removeAllElements();
                    break;
                }
                this.printText((String)this._preRoot.elementAt(n), true, true);
                if (this._indenting) {
                    this._printer.breakLine();
                }
                ++n;
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void setOutputByteStream(OutputStream outputStream) {
        if (outputStream != null) {
            this._output = outputStream;
            this._writer = null;
            this.reset();
            return;
        }
        throw new NullPointerException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"output"}));
    }

    @Override
    public void setOutputCharStream(Writer writer) {
        if (writer != null) {
            this._writer = writer;
            this._output = null;
            this.reset();
            return;
        }
        throw new NullPointerException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"writer"}));
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat != null) {
            this._format = outputFormat;
            this.reset();
            return;
        }
        throw new NullPointerException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"format"}));
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
        try {
            this.endCDATA();
            this.content();
            this._printer.printText('&');
            this._printer.printText(string2);
            this._printer.printText(';');
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startCDATA() {
        this.getElementState().doCData = true;
    }

    @Override
    public final void startDTD(String string2, String string3, String string4) throws SAXException {
        try {
            this._printer.enterDTD();
            this._docTypePublicId = string3;
            this._docTypeSystemId = string4;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.prepare();
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.toString());
        }
    }

    @Override
    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    @Override
    public abstract void startElement(String var1, AttributeList var2) throws SAXException;

    @Override
    public void startEntity(String string2) {
    }

    public void startNonEscaping() {
        this.getElementState().unescaped = true;
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new Hashtable();
        }
        Hashtable hashtable = this._prefixes;
        String string4 = string2;
        if (string2 == null) {
            string4 = "";
        }
        hashtable.put(string3, string4);
    }

    public void startPreserving() {
        this.getElementState().preserveSpace = true;
    }

    protected void surrogates(int n, int n2) throws IOException {
        block7: {
            CharSequence charSequence;
            block4: {
                block6: {
                    block2: {
                        String string2;
                        Printer printer;
                        block5: {
                            block3: {
                                if (!XMLChar.isHighSurrogate(n)) break block2;
                                if (XMLChar.isLowSurrogate(n2)) break block3;
                                charSequence = new StringBuffer();
                                ((StringBuffer)charSequence).append("The character '");
                                ((StringBuffer)charSequence).append((char)n2);
                                ((StringBuffer)charSequence).append("' is an invalid XML character");
                                charSequence = ((StringBuffer)charSequence).toString();
                                break block4;
                            }
                            if (XMLChar.isValid(n = XMLChar.supplemental((char)n, (char)n2))) break block5;
                            charSequence = new StringBuffer();
                            break block6;
                        }
                        if (this.content().inCData) {
                            this._printer.printText("]]>&#x");
                            this._printer.printText(Integer.toHexString(n));
                            printer = this._printer;
                            string2 = ";<![CDATA[";
                        } else {
                            this._printer.printText("&#x");
                            this._printer.printText(Integer.toHexString(n));
                            printer = this._printer;
                            string2 = ";";
                        }
                        printer.printText(string2);
                        break block7;
                    }
                    charSequence = new StringBuffer();
                }
                ((StringBuffer)charSequence).append("The character '");
                ((StringBuffer)charSequence).append((char)n);
                ((StringBuffer)charSequence).append("' is an invalid XML character");
                charSequence = ((StringBuffer)charSequence).toString();
            }
            this.fatalError((String)charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        try {
            this._printer.enterDTD();
            if (string3 == null) {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(string2);
                this._printer.printText(" SYSTEM ");
            } else {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(string2);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(string3);
                this._printer.printText(' ');
            }
            this.printDoctypeURL(string4);
            if (string5 != null) {
                this._printer.printText(" NDATA ");
                this._printer.printText(string5);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

