/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XML11Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DOMWriterFilter;

public class DOMWriterImpl
implements DOMWriter,
DOMConfiguration {
    private String fEncoding;
    private XMLSerializer serializer;
    private XML11Serializer xml11Serializer;

    public DOMWriterImpl() {
        XMLSerializer xMLSerializer;
        this.serializer = xMLSerializer = new XMLSerializer();
        this.initSerializer(xMLSerializer);
    }

    private void checkAllFeatures(XMLSerializer object) {
        Object object2 = this.getParameter("whitespace-in-element-content");
        Boolean bl = Boolean.TRUE;
        object = ((BaseMarkupSerializer)object)._format;
        boolean bl2 = object2 == bl;
        ((OutputFormat)object).setPreserveSpace(bl2);
    }

    private void copySettings(XMLSerializer xMLSerializer, XMLSerializer xMLSerializer2) {
        xMLSerializer2._format.setOmitXMLDeclaration(xMLSerializer._format.getOmitXMLDeclaration());
        xMLSerializer2.fNamespaces = xMLSerializer.fNamespaces;
        xMLSerializer2.fDOMErrorHandler = xMLSerializer.fDOMErrorHandler;
        xMLSerializer2._format.setEncoding(xMLSerializer._format.getEncoding());
        xMLSerializer2._format.setLineSeparator(xMLSerializer._format.getLineSeparator());
        xMLSerializer2.fDOMFilter = xMLSerializer.fDOMFilter;
        Enumeration enumeration = xMLSerializer.fFeatures.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = xMLSerializer.fFeatures.get(k);
            xMLSerializer2.fFeatures.put(k, v);
        }
        return;
    }

    private void initSerializer(XMLSerializer xMLSerializer) {
        xMLSerializer.fNamespaces = true;
        xMLSerializer.fNSBinder = new NamespaceSupport();
        xMLSerializer.fLocalNSBinder = new NamespaceSupport();
        xMLSerializer.fSymbolTable = new SymbolTable();
        xMLSerializer.fFeatures = new Hashtable();
        xMLSerializer.fFeatures.put("namespaces", Boolean.TRUE);
        xMLSerializer.fFeatures.put("normalize-characters", Boolean.FALSE);
        xMLSerializer.fFeatures.put("split-cdata-sections", Boolean.TRUE);
        xMLSerializer.fFeatures.put("validate", Boolean.FALSE);
        xMLSerializer.fFeatures.put("entities", Boolean.FALSE);
        xMLSerializer.fFeatures.put("whitespace-in-element-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("discard-default-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("canonical-form", Boolean.FALSE);
        xMLSerializer.fFeatures.put("format-pretty-print", Boolean.FALSE);
        xMLSerializer.fFeatures.put("xml-declaration", Boolean.TRUE);
        xMLSerializer.fFeatures.put("unknown-characters", Boolean.TRUE);
    }

    @Override
    public boolean canSetParameter(String string2, Object object) {
        if (string2.equals("normalize-characters") && object == Boolean.TRUE) {
            return false;
        }
        if (string2.equals("validate") && object == Boolean.TRUE) {
            return false;
        }
        if (string2.equals("whitespace-in-element-content") && object == Boolean.FALSE) {
            return false;
        }
        if (string2.equals("canonical-form") && object == Boolean.TRUE) {
            return false;
        }
        if (string2.equals("format-pretty-print") && object == Boolean.TRUE) {
            return false;
        }
        return this.serializer.fFeatures.get(string2) != null || string2.equals("error-handler");
        {
        }
    }

    @Override
    public DOMConfiguration getConfig() {
        return this;
    }

    @Override
    public String getEncoding() {
        return this.fEncoding;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.serializer.fDOMErrorHandler;
    }

    @Override
    public DOMWriterFilter getFilter() {
        return null;
    }

    @Override
    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    @Override
    public Object getParameter(String string2) throws DOMException {
        Object v = this.serializer.fFeatures.get(string2);
        if (v == null) {
            if (string2.equals("error-handler")) {
                return this.serializer.fDOMErrorHandler;
            }
            if (!(string2.equals("entity-resolver") || string2.equals("schema-location") || string2.equals("schema-type"))) {
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string2}));
            }
            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string2}));
        }
        return (Boolean)v;
    }

    @Override
    public void setEncoding(String string2) {
        this.serializer._format.setEncoding(string2);
        this.fEncoding = this.serializer._format.getEncoding();
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.serializer.fDOMErrorHandler = dOMErrorHandler;
    }

    @Override
    public void setFilter(DOMWriterFilter dOMWriterFilter) {
        this.serializer.fDOMFilter = dOMWriterFilter;
    }

    @Override
    public void setNewLine(String string2) {
        this.serializer._format.setLineSeparator(string2);
    }

    @Override
    public void setParameter(String object, Object object2) throws DOMException {
        block13: {
            block14: {
                block12: {
                    block10: {
                        block11: {
                            boolean bl = this.serializer.fFeatures.containsKey(object);
                            boolean bl2 = false;
                            if (!bl) break block10;
                            if (object2 != Boolean.TRUE && object2 != Boolean.FALSE) {
                                throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                            }
                            if (!this.canSetParameter((String)object, object2)) break block11;
                            this.serializer.fFeatures.put(object, object2);
                            if (((String)object).equals("xml-declaration")) {
                                this.serializer._format.setOmitXMLDeclaration((Boolean)object2 ^ true);
                            } else if (((String)object).equals("namespaces")) {
                                object = this.serializer;
                                if (object2 == Boolean.TRUE) {
                                    bl2 = true;
                                }
                                ((XMLSerializer)object).fNamespaces = bl2;
                            }
                            break block12;
                        }
                        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                    }
                    if (!((String)object).equals("error-handler")) break block13;
                    if (!(object2 instanceof DOMErrorHandler)) break block14;
                    this.serializer.fDOMErrorHandler = (DOMErrorHandler)object2;
                }
                return;
            }
            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
        }
        if (!(((String)object).equals("entity-resolver") || ((String)object).equals("schema-location") || ((String)object).equals("schema-type"))) {
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
        }
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
    }

    @Override
    public boolean writeNode(OutputStream outputStream, Node object) {
        block14: {
            Object object2;
            block13: {
                String string2;
                block12: {
                    object2 = object.getNodeType() == 9 ? (Document)object : object.getOwnerDocument();
                    String string3 = null;
                    Method method = object2.getClass().getMethod("getVersion", new Class[0]);
                    string2 = string3;
                    if (method == null) break block12;
                    try {
                        string2 = (String)method.invoke(object2, null);
                    }
                    catch (Exception exception) {
                        string2 = string3;
                    }
                }
                if (string2 != null && string2.equals("1.1")) {
                    if (this.xml11Serializer == null) {
                        this.xml11Serializer = object2 = new XML11Serializer();
                        this.initSerializer((XMLSerializer)object2);
                    }
                    this.copySettings(this.serializer, this.xml11Serializer);
                    object2 = this.xml11Serializer;
                } else {
                    object2 = this.serializer;
                }
                this.checkAllFeatures((XMLSerializer)object2);
                ((XMLSerializer)object2).reset();
                ((BaseMarkupSerializer)object2).setOutputByteStream(outputStream);
                if (object != null) break block13;
                return false;
            }
            try {
                if (object.getNodeType() == 9) {
                    ((BaseMarkupSerializer)object2).serialize((Document)object);
                    break block14;
                }
                if (object.getNodeType() == 11) {
                    ((BaseMarkupSerializer)object2).serialize((DocumentFragment)object);
                    break block14;
                }
                if (object.getNodeType() == 1) {
                    ((BaseMarkupSerializer)object2).serialize((Element)object);
                    break block14;
                }
                return false;
            }
            catch (Exception exception) {
                if (((BaseMarkupSerializer)object2).fDOMErrorHandler == null) break block14;
                object = new DOMErrorImpl();
                ((DOMErrorImpl)object).fException = exception;
                ((DOMErrorImpl)object).fMessage = exception.getMessage();
                ((DOMErrorImpl)object).fSeverity = (short)1;
                ((BaseMarkupSerializer)object2).fDOMErrorHandler.handleError((DOMError)object);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String writeToString(Node node) throws DOMException {
        Object object;
        Object object2;
        block10: {
            object2 = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                object = object2.getClass().getMethod("getVersion", new Class[0]);
                if (object == null) break block10;
                object2 = (String)((Method)object).invoke(object2, null);
            }
            catch (Exception exception) {}
        }
        object2 = null;
        if (object2 != null && ((String)object2).equals("1.1")) {
            if (this.xml11Serializer == null) {
                this.xml11Serializer = object2 = new XML11Serializer();
                this.initSerializer((XMLSerializer)object2);
            }
            this.copySettings(this.serializer, this.xml11Serializer);
            object2 = this.xml11Serializer;
        } else {
            object2 = this.serializer;
        }
        this.checkAllFeatures((XMLSerializer)object2);
        object = new StringWriter();
        try {
            ((XMLSerializer)object2).reset();
            ((BaseMarkupSerializer)object2).setOutputCharStream((Writer)object);
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 9) {
                ((BaseMarkupSerializer)object2).serialize((Document)node);
                return ((StringWriter)object).toString();
            }
            if (node.getNodeType() == 11) {
                ((BaseMarkupSerializer)object2).serialize((DocumentFragment)node);
                return ((StringWriter)object).toString();
            }
            if (node.getNodeType() != 1) return null;
            ((BaseMarkupSerializer)object2).serialize((Element)node);
            return ((StringWriter)object).toString();
        }
        catch (IOException iOException) {
            throw new DOMException(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{iOException.getMessage()}));
        }
    }
}

