/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xerces.util.EncodingMap;
import sun.io.CharToByteConverter;

public class EncodingInfo {
    CharToByteConverter fCToB = null;
    boolean fHaveTriedCToB = false;
    String ianaName;
    String javaName;
    int lastPrintable;

    public EncodingInfo(String string2, String string3, int n) {
        this.ianaName = string2;
        this.javaName = EncodingMap.getIANA2JavaMapping(string2);
        this.lastPrintable = n;
    }

    public static void testJavaEncodingName(String string2) throws UnsupportedEncodingException {
        new String(new byte[]{118, 97, 108, 105, 100}, string2);
    }

    public String getIANAName() {
        return this.ianaName;
    }

    public Writer getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        String string2;
        if (this.javaName != null) {
            return new OutputStreamWriter(outputStream, this.javaName);
        }
        this.javaName = string2 = EncodingMap.getIANA2JavaMapping(this.ianaName);
        if (string2 == null) {
            return new OutputStreamWriter(outputStream, "UTF8");
        }
        return new OutputStreamWriter(outputStream, this.javaName);
    }

    public boolean isPrintable(char c) {
        if (c <= this.lastPrintable) {
            return true;
        }
        if (this.fCToB == null) {
            if (this.fHaveTriedCToB) {
                return false;
            }
            try {
                this.fCToB = CharToByteConverter.getConverter((String)this.javaName);
            }
            catch (Exception exception) {
                this.fHaveTriedCToB = true;
                return false;
            }
        }
        try {
            boolean bl = this.fCToB.canConvert(c);
            return bl;
        }
        catch (Exception exception) {
            this.fCToB = null;
            this.fHaveTriedCToB = false;
            return false;
        }
    }
}

