/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Locale;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HTMLSerializer
extends BaseMarkupSerializer {
    public static final String XHTMLNamespace = "http://www.w3.org/1999/xhtml";
    private boolean _xhtml;
    private String fUserXHTMLNamespace;

    public HTMLSerializer() {
        this(false, new OutputFormat("html", "ISO-8859-1", false));
    }

    public HTMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", "ISO-8859-1", false);
        }
        this(false, outputFormat);
        this.setOutputByteStream(outputStream);
    }

    public HTMLSerializer(Writer writer, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", "ISO-8859-1", false);
        }
        this(false, outputFormat);
        this.setOutputCharStream(writer);
    }

    public HTMLSerializer(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", "ISO-8859-1", false);
        }
        this(false, outputFormat);
    }

    protected HTMLSerializer(boolean bl, OutputFormat outputFormat) {
        super(outputFormat);
        this.fUserXHTMLNamespace = null;
        this._xhtml = bl;
    }

    @Override
    protected void characters(String string2) throws IOException {
        this.content();
        super.characters(string2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.content().doCData = false;
            super.characters(cArray, n, n2);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2) throws SAXException {
        this.endElement(null, null, string2);
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.endElementIO(string2, string3, string4);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void endElementIO(String object, String object2, String object3) throws IOException {
        block11: {
            block12: {
                block9: {
                    block10: {
                        this._printer.unindent();
                        object3 = this.getElementState();
                        object = ((ElementState)object3).namespaceURI == null ? ((ElementState)object3).rawName : (!(((ElementState)object3).namespaceURI.equals(XHTMLNamespace) || (object = this.fUserXHTMLNamespace) != null && ((String)object).equals(((ElementState)object3).namespaceURI)) ? null : ((ElementState)object3).localName);
                        if (!this._xhtml) break block9;
                        if (!((ElementState)object3).empty) break block10;
                        this._printer.printText(" />");
                        break block11;
                    }
                    if (((ElementState)object3).inCData) {
                        this._printer.printText("]]>");
                    }
                    this._printer.printText("</");
                    object2 = this._printer;
                    object3 = ((ElementState)object3).rawName.toLowerCase(Locale.ENGLISH);
                    break block12;
                }
                if (((ElementState)object3).empty) {
                    this._printer.printText('>');
                }
                if (object != null && HTMLdtd.isOnlyOpening((String)object)) break block11;
                if (this._indenting && !((ElementState)object3).preserveSpace && ((ElementState)object3).afterElement) {
                    this._printer.breakLine();
                }
                if (((ElementState)object3).inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                object2 = this._printer;
                object3 = ((ElementState)object3).rawName;
            }
            ((Printer)object2).printText((String)object3);
            this._printer.printText('>');
        }
        object2 = this.leaveElementState();
        if (object == null || !((String)object).equalsIgnoreCase("A") && !((String)object).equalsIgnoreCase("TD")) {
            ((ElementState)object2).afterElement = true;
        }
        ((ElementState)object2).empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    protected String escapeURI(String string2) {
        int n = string2.indexOf("\"");
        String string3 = string2;
        if (n >= 0) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    @Override
    protected String getEntityRef(int n) {
        return HTMLdtd.fromChar(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void serializeElement(Element node) throws IOException {
        Object object;
        boolean bl;
        String string2;
        block24: {
            string2 = node.getTagName();
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                    this._printer.breakLine();
                }
            }
            bl = elementState.preserveSpace;
            this._printer.printText('<');
            if (this._xhtml) {
                this._printer.printText(string2.toLowerCase(Locale.ENGLISH));
            } else {
                this._printer.printText(string2);
            }
            this._printer.indent();
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) break block24;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Object object2;
                block27: {
                    String string3;
                    block28: {
                        block30: {
                            block26: {
                                block29: {
                                    block25: {
                                        object = (Attr)namedNodeMap.item(i);
                                        string3 = object.getName().toLowerCase(Locale.ENGLISH);
                                        object2 = object.getValue();
                                        if (!object.getSpecified()) continue;
                                        this._printer.printSpace();
                                        if (!this._xhtml) break block25;
                                        object = object2;
                                        if (object2 != null) break block26;
                                        this._printer.printText(string3);
                                        object2 = this._printer;
                                        object = "=\"\"";
                                        break block27;
                                    }
                                    object = object2;
                                    if (object2 == null) {
                                        object = "";
                                    }
                                    if (!this._format.getPreserveEmptyAttributes() && ((String)object).length() == 0) break block28;
                                    if (!HTMLdtd.isURI(string2, string3)) break block29;
                                    this._printer.printText(string3);
                                    this._printer.printText("=\"");
                                    this._printer.printText(this.escapeURI((String)object));
                                    break block30;
                                }
                                if (HTMLdtd.isBoolean(string2, string3)) break block28;
                            }
                            this._printer.printText(string3);
                            this._printer.printText("=\"");
                            this.printEscaped((String)object);
                        }
                        this._printer.printText('\"');
                        continue;
                    }
                    object2 = this._printer;
                    object = string3;
                }
                ((Printer)object2).printText((String)object);
            }
        }
        if (HTMLdtd.isPreserveSpace(string2)) {
            bl = true;
        }
        if (!node.hasChildNodes() && HTMLdtd.isEmptyTag(string2)) {
            this._printer.unindent();
            if (this._xhtml) {
                this._printer.printText(" />");
            } else {
                this._printer.printText('>');
            }
            elementState.afterElement = true;
            elementState.empty = false;
            if (!this.isDocumentState()) return;
            this._printer.flush();
            return;
        }
        object = this.enterElementState(null, null, string2, bl);
        if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("TD")) {
            ((ElementState)object).empty = false;
            this._printer.printText('>');
        }
        if (string2.equalsIgnoreCase("SCRIPT") || string2.equalsIgnoreCase("STYLE")) {
            if (this._xhtml) {
                ((ElementState)object).doCData = true;
            } else {
                ((ElementState)object).unescaped = true;
            }
        }
        node = node.getFirstChild();
        while (true) {
            if (node == null) {
                this.endElementIO(null, null, string2);
                return;
            }
            this.serializeNode(node);
            node = node.getNextSibling();
        }
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("html", "ISO-8859-1", false);
        }
        super.setOutputFormat(outputFormat);
    }

    public void setXHTMLNamespace(String string2) {
        this.fUserXHTMLNamespace = string2;
    }

    protected void startDocument(String string2) throws IOException {
        block6: {
            block8: {
                block9: {
                    block7: {
                        this._printer.leaveDTD();
                        if (this._started) break block6;
                        if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                            string2 = this._xhtml ? "-//W3C//DTD XHTML 1.0 Strict//EN" : "-//W3C//DTD HTML 4.0//EN";
                            this._docTypePublicId = string2;
                            this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                        }
                        if (this._format.getOmitDocumentType()) break block6;
                        if (this._docTypePublicId == null || this._xhtml && this._docTypeSystemId == null) break block7;
                        this._printer.printText("<!DOCTYPE HTML PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._docTypeSystemId == null) break block8;
                        if (this._indenting) {
                            this._printer.breakLine();
                            this._printer.printText("                      ");
                        } else {
                            this._printer.printText(' ');
                        }
                        break block9;
                    }
                    if (this._docTypeSystemId == null) break block6;
                    this._printer.printText("<!DOCTYPE HTML SYSTEM ");
                }
                this.printDoctypeURL(this._docTypeSystemId);
            }
            this._printer.printText('>');
            this._printer.breakLine();
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String object, String string2, String string3, Attributes object2) throws SAXException {
        try {
            String string4;
            boolean bl;
            boolean bl2;
            Object object3;
            Object object4;
            block31: {
                block32: {
                    block30: {
                        if (this._printer == null) break block30;
                        object4 = this.getElementState();
                        if (this.isDocumentState()) {
                            if (!this._started) {
                                object3 = string2 == null ? string3 : string2;
                                this.startDocument((String)object3);
                            }
                        } else {
                            if (((ElementState)object4).empty) {
                                this._printer.printText('>');
                            }
                            if (this._indenting && !((ElementState)object4).preserveSpace && (((ElementState)object4).empty || ((ElementState)object4).afterElement)) {
                                this._printer.breakLine();
                            }
                        }
                        bl2 = ((ElementState)object4).preserveSpace;
                        if (string3 == null) {
                            if (object != null && (string3 = this.getPrefix((String)object)).length() > 0) {
                                object3 = new StringBuffer();
                                ((StringBuffer)object3).append(string3);
                                ((StringBuffer)object3).append(":");
                                ((StringBuffer)object3).append(string2);
                                string3 = ((StringBuffer)object3).toString();
                            } else {
                                string3 = string2;
                            }
                            bl = true;
                        } else {
                            bl = false;
                        }
                        object3 = object == null ? string3 : (!(((String)object).equals(XHTMLNamespace) || (object3 = this.fUserXHTMLNamespace) != null && ((String)object3).equals(object)) ? null : string2);
                        this._printer.printText('<');
                        if (this._xhtml) {
                            this._printer.printText(string3.toLowerCase(Locale.ENGLISH));
                        } else {
                            this._printer.printText(string3);
                        }
                        this._printer.indent();
                        if (object2 == null) break block31;
                        break block32;
                    }
                    object = new IllegalStateException("SER002 No writer supplied for serializer");
                    throw object;
                }
                for (int i = 0; i < object2.getLength(); ++i) {
                    block37: {
                        String string5;
                        block39: {
                            block35: {
                                block33: {
                                    block38: {
                                        block36: {
                                            block34: {
                                                this._printer.printSpace();
                                                string4 = object2.getQName(i).toLowerCase(Locale.ENGLISH);
                                                string5 = object2.getValue(i);
                                                if (this._xhtml || object != null) break block33;
                                                object4 = string5;
                                                if (string5 == null) {
                                                    object4 = "";
                                                }
                                                if (this._format.getPreserveEmptyAttributes() || ((String)object4).length() != 0) break block34;
                                                object4 = this._printer;
                                                break block35;
                                            }
                                            if (!HTMLdtd.isURI(string3, string4)) break block36;
                                            this._printer.printText(string4);
                                            this._printer.printText("=\"");
                                            this._printer.printText(this.escapeURI((String)object4));
                                            object4 = this._printer;
                                            break block37;
                                        }
                                        if (!HTMLdtd.isBoolean(string3, string4)) break block38;
                                        object4 = this._printer;
                                        break block35;
                                    }
                                    this._printer.printText(string4);
                                    this._printer.printText("=\"");
                                    this.printEscaped((String)object4);
                                    object4 = this._printer;
                                    break block37;
                                }
                                if (string5 != null) break block39;
                                this._printer.printText(string4);
                                object4 = this._printer;
                                string4 = "=\"\"";
                            }
                            ((Printer)object4).printText(string4);
                            continue;
                        }
                        this._printer.printText(string4);
                        this._printer.printText("=\"");
                        this.printEscaped(string5);
                        object4 = this._printer;
                    }
                    ((Printer)object4).printText('\"');
                }
            }
            boolean bl3 = bl2;
            if (object3 != null) {
                bl3 = bl2;
                if (HTMLdtd.isPreserveSpace((String)object3)) {
                    bl3 = true;
                }
            }
            if (bl) {
                object4 = this._prefixes.keys();
                while (object4.hasMoreElements()) {
                    this._printer.printSpace();
                    object2 = (String)object4.nextElement();
                    string4 = (String)this._prefixes.get(object2);
                    if (string4.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped((String)object2);
                        object2 = this._printer;
                    } else {
                        this._printer.printText("xmlns:");
                        this._printer.printText(string4);
                        this._printer.printText("=\"");
                        this.printEscaped((String)object2);
                        object2 = this._printer;
                    }
                    ((Printer)object2).printText('\"');
                }
            }
            object = this.enterElementState((String)object, string2, string3, bl3);
            if (object3 != null && (((String)object3).equalsIgnoreCase("A") || ((String)object3).equalsIgnoreCase("TD"))) {
                ((ElementState)object).empty = false;
                this._printer.printText('>');
            }
            if (object3 == null) return;
            if (!string3.equalsIgnoreCase("SCRIPT")) {
                if (!string3.equalsIgnoreCase("STYLE")) return;
            }
            if (this._xhtml) {
                ((ElementState)object).doCData = true;
                return;
            }
            ((ElementState)object).unescaped = true;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String object, AttributeList object2) throws SAXException {
        try {
            boolean bl;
            block23: {
                Object object3;
                block24: {
                    block22: {
                        if (this._printer == null) break block22;
                        object3 = this.getElementState();
                        if (this.isDocumentState()) {
                            if (!this._started) {
                                this.startDocument((String)object);
                            }
                        } else {
                            if (((ElementState)object3).empty) {
                                this._printer.printText('>');
                            }
                            if (this._indenting && !((ElementState)object3).preserveSpace && (((ElementState)object3).empty || ((ElementState)object3).afterElement)) {
                                this._printer.breakLine();
                            }
                        }
                        bl = ((ElementState)object3).preserveSpace;
                        this._printer.printText('<');
                        if (this._xhtml) {
                            this._printer.printText(((String)object).toLowerCase(Locale.ENGLISH));
                        } else {
                            this._printer.printText((String)object);
                        }
                        this._printer.indent();
                        if (object2 == null) break block23;
                        break block24;
                    }
                    object = new IllegalStateException("SER002 No writer supplied for serializer");
                    throw object;
                }
                for (int i = 0; i < object2.getLength(); ++i) {
                    block26: {
                        String string2;
                        block30: {
                            block28: {
                                block29: {
                                    block27: {
                                        String string3;
                                        block25: {
                                            this._printer.printSpace();
                                            string2 = object2.getName(i).toLowerCase(Locale.ENGLISH);
                                            string3 = object2.getValue(i);
                                            boolean bl2 = this._xhtml;
                                            if (!bl2) break block25;
                                            if (string3 == null) {
                                                this._printer.printText(string2);
                                                this._printer.printText("=\"\"");
                                                continue;
                                            }
                                            this._printer.printText(string2);
                                            this._printer.printText("=\"");
                                            this.printEscaped(string3);
                                            object3 = this._printer;
                                            break block26;
                                        }
                                        object3 = string3;
                                        if (string3 == null) {
                                            object3 = "";
                                        }
                                        if (this._format.getPreserveEmptyAttributes() || ((String)object3).length() != 0) break block27;
                                        object3 = this._printer;
                                        break block28;
                                    }
                                    if (!HTMLdtd.isURI((String)object, string2)) break block29;
                                    this._printer.printText(string2);
                                    this._printer.printText("=\"");
                                    this._printer.printText(this.escapeURI((String)object3));
                                    object3 = this._printer;
                                    break block26;
                                }
                                if (!HTMLdtd.isBoolean((String)object, string2)) break block30;
                                object3 = this._printer;
                            }
                            ((Printer)object3).printText(string2);
                            continue;
                        }
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped((String)object3);
                        object3 = this._printer;
                    }
                    ((Printer)object3).printText('\"');
                }
            }
            if (HTMLdtd.isPreserveSpace((String)object)) {
                bl = true;
            }
            object2 = this.enterElementState(null, null, (String)object, bl);
            if (((String)object).equalsIgnoreCase("A") || ((String)object).equalsIgnoreCase("TD")) {
                ((ElementState)object2).empty = false;
                this._printer.printText('>');
            }
            if (!((String)object).equalsIgnoreCase("SCRIPT")) {
                if (!((String)object).equalsIgnoreCase("STYLE")) return;
            }
            if (this._xhtml) {
                ((ElementState)object2).doCData = true;
                return;
            }
            ((ElementState)object2).unescaped = true;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

