/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.UnsupportedEncodingException;
import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.Encodings;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLDocument;

public class OutputFormat {
    private boolean _allowJavaNames = false;
    private String[] _cdataElements;
    private String _doctypePublic;
    private String _doctypeSystem;
    private String _encoding = "UTF-8";
    private EncodingInfo _encodingInfo = null;
    private int _indent = 0;
    private String _lineSeparator = "\n";
    private int _lineWidth = 72;
    private String _mediaType;
    private String _method;
    private String[] _nonEscapingElements;
    private boolean _omitComments = false;
    private boolean _omitDoctype = false;
    private boolean _omitXmlDeclaration = false;
    private boolean _preserve = false;
    private boolean _preserveEmptyAttributes = false;
    private boolean _standalone = false;
    private boolean _stripComments = false;
    private String _version;

    public OutputFormat() {
    }

    public OutputFormat(String string2, String string3, boolean bl) {
        this.setMethod(string2);
        this.setEncoding(string3);
        this.setIndenting(bl);
    }

    public OutputFormat(Document document) {
        this.setMethod(OutputFormat.whichMethod(document));
        this.setDoctype(OutputFormat.whichDoctypePublic(document), OutputFormat.whichDoctypeSystem(document));
        this.setMediaType(OutputFormat.whichMediaType(this.getMethod()));
    }

    public OutputFormat(Document document, String string2, boolean bl) {
        this(document);
        this.setEncoding(string2);
        this.setIndenting(bl);
    }

    public static String whichDoctypePublic(Document document) {
        Object object = document.getDoctype();
        if (object != null) {
            try {
                object = object.getPublicId();
                return object;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (document instanceof HTMLDocument) {
            return "-//W3C//DTD XHTML 1.0 Strict//EN";
        }
        return null;
    }

    public static String whichDoctypeSystem(Document document) {
        Object object = document.getDoctype();
        if (object != null) {
            try {
                object = object.getSystemId();
                return object;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (document instanceof HTMLDocument) {
            return "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
        }
        return null;
    }

    public static String whichMediaType(String string2) {
        if (string2.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (string2.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (string2.equalsIgnoreCase("xhtml")) {
            return "text/html";
        }
        if (string2.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (string2.equalsIgnoreCase("fop")) {
            return "application/pdf";
        }
        return null;
    }

    public static String whichMethod(Document node) {
        if (node instanceof HTMLDocument) {
            return "html";
        }
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equalsIgnoreCase("html")) {
                    return "html";
                }
                if (node.getNodeName().equalsIgnoreCase("root")) {
                    return "fop";
                }
                return "xml";
            }
            if (node.getNodeType() == 3) {
                String string2 = node.getNodeValue();
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.charAt(i) == ' ' || string2.charAt(i) == '\n' || string2.charAt(i) == '\t' || string2.charAt(i) == '\r') continue;
                    return "xml";
                }
            }
            node = node.getNextSibling();
        }
        return "xml";
    }

    public String[] getCDataElements() {
        return this._cdataElements;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public EncodingInfo getEncodingInfo() throws UnsupportedEncodingException {
        if (this._encodingInfo == null) {
            this._encodingInfo = Encodings.getEncodingInfo(this._encoding, this._allowJavaNames);
        }
        return this._encodingInfo;
    }

    public int getIndent() {
        return this._indent;
    }

    public boolean getIndenting() {
        boolean bl = this._indent > 0;
        return bl;
    }

    public char getLastPrintable() {
        if (this.getEncoding() != null && this.getEncoding().equalsIgnoreCase("ASCII")) {
            return '\u00ff';
        }
        return '\uffff';
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public String getMethod() {
        return this._method;
    }

    public String[] getNonEscapingElements() {
        return this._nonEscapingElements;
    }

    public boolean getOmitComments() {
        return this._omitComments;
    }

    public boolean getOmitDocumentType() {
        return this._omitDoctype;
    }

    public boolean getOmitXMLDeclaration() {
        return this._omitXmlDeclaration;
    }

    public boolean getPreserveEmptyAttributes() {
        return this._preserveEmptyAttributes;
    }

    public boolean getPreserveSpace() {
        return this._preserve;
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isCDataElement(String string2) {
        if (this._cdataElements == null) {
            return false;
        }
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = this._cdataElements).length) {
            if (stringArray[n].equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNonEscapingElement(String string2) {
        if (this._nonEscapingElements == null) {
            return false;
        }
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = this._nonEscapingElements).length) {
            if (stringArray[n].equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setAllowJavaNames(boolean bl) {
        this._allowJavaNames = bl;
    }

    public boolean setAllowJavaNames() {
        return this._allowJavaNames;
    }

    public void setCDataElements(String[] stringArray) {
        this._cdataElements = stringArray;
    }

    public void setDoctype(String string2, String string3) {
        this._doctypePublic = string2;
        this._doctypeSystem = string3;
    }

    public void setEncoding(String string2) {
        this._encoding = string2;
        this._encodingInfo = null;
    }

    public void setEncoding(EncodingInfo encodingInfo) {
        this._encoding = encodingInfo.getIANAName();
        this._encodingInfo = encodingInfo;
    }

    public void setIndent(int n) {
        int n2 = n;
        if (n < 0) {
            n2 = 0;
        }
        this._indent = n2;
    }

    public void setIndenting(boolean bl) {
        int n;
        if (bl) {
            this._indent = 4;
            n = 72;
        } else {
            n = 0;
            this._indent = 0;
        }
        this._lineWidth = n;
    }

    public void setLineSeparator(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "\n";
        }
        this._lineSeparator = string3;
    }

    public void setLineWidth(int n) {
        int n2 = n;
        if (n <= 0) {
            n2 = 0;
        }
        this._lineWidth = n2;
    }

    public void setMediaType(String string2) {
        this._mediaType = string2;
    }

    public void setMethod(String string2) {
        this._method = string2;
    }

    public void setNonEscapingElements(String[] stringArray) {
        this._nonEscapingElements = stringArray;
    }

    public void setOmitComments(boolean bl) {
        this._omitComments = bl;
    }

    public void setOmitDocumentType(boolean bl) {
        this._omitDoctype = bl;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this._omitXmlDeclaration = bl;
    }

    public void setPreserveEmptyAttributes(boolean bl) {
        this._preserveEmptyAttributes = bl;
    }

    public void setPreserveSpace(boolean bl) {
        this._preserve = bl;
    }

    public void setStandalone(boolean bl) {
        this._standalone = bl;
    }

    public void setVersion(String string2) {
        this._version = string2;
    }

    public static class DTD {
        public static final String HTMLPublicId = "-//W3C//DTD HTML 4.0//EN";
        public static final String HTMLSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
        public static final String XHTMLPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
        public static final String XHTMLSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
    }

    public static class Defaults {
        public static final String Encoding = "UTF-8";
        public static final int Indent = 4;
        public static final int LineWidth = 72;
    }
}

