/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;

public class Printer {
    private static final int BufferSize = 4096;
    private final char[] _buffer = new char[4096];
    protected Writer _docWriter;
    protected StringWriter _dtdWriter;
    protected IOException _exception;
    protected final OutputFormat _format;
    private int _pos = 0;
    protected Writer _writer;

    public Printer(Writer writer, OutputFormat outputFormat) {
        this._writer = writer;
        this._format = outputFormat;
        this._exception = null;
        this._dtdWriter = null;
        this._docWriter = null;
        this._pos = 0;
    }

    public void breakLine() throws IOException {
        int n;
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            char[] cArray = this._buffer;
            n = this._pos;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
        cArray[n] = (char)10;
        this._pos = n + 1;
    }

    public void breakLine(boolean bl) throws IOException {
        this.breakLine();
    }

    public void enterDTD() throws IOException {
        if (this._dtdWriter == null) {
            StringWriter stringWriter;
            this.flushLine(false);
            this._dtdWriter = stringWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = stringWriter;
        }
    }

    public void flush() throws IOException {
        try {
            this._writer.write(this._buffer, 0, this._pos);
            this._writer.flush();
            this._pos = 0;
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
    }

    public void flushLine(boolean bl) throws IOException {
        block2: {
            try {
                this._writer.write(this._buffer, 0, this._pos);
            }
            catch (IOException iOException) {
                if (this._exception != null) break block2;
                this._exception = iOException;
            }
        }
        this._pos = 0;
    }

    public IOException getException() {
        return this._exception;
    }

    public int getNextIndent() {
        return 0;
    }

    public void indent() {
    }

    public String leaveDTD() throws IOException {
        if (this._writer == this._dtdWriter) {
            this.flushLine(false);
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    public void printSpace() throws IOException {
        int n;
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            char[] cArray = this._buffer;
            n = this._pos;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
        cArray[n] = (char)32;
        this._pos = n + 1;
    }

    public void printText(char c) throws IOException {
        int n;
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            char[] cArray = this._buffer;
            n = this._pos;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
        cArray[n] = c;
        this._pos = n + 1;
    }

    public void printText(String string2) throws IOException {
        int n;
        int n2;
        try {
            n2 = string2.length();
            n = 0;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
        while (true) {
            if (n >= n2) {
                return;
            }
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = string2.charAt(n);
            ++this._pos;
            ++n;
            continue;
            break;
        }
    }

    public void printText(StringBuffer stringBuffer) throws IOException {
        int n;
        int n2;
        try {
            n2 = stringBuffer.length();
            n = 0;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            throw iOException;
        }
        while (true) {
            if (n >= n2) {
                return;
            }
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = stringBuffer.charAt(n);
            ++this._pos;
            ++n;
            continue;
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printText(char[] cArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            try {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                char[] cArray2 = this._buffer;
                n3 = this._pos;
            }
            catch (IOException iOException) {
                if (this._exception == null) {
                    this._exception = iOException;
                }
                throw iOException;
            }
            cArray2[n3] = cArray[n];
            ++n;
            {
                this._pos = n3 + 1;
                --n2;
                continue;
            }
            break;
        }
        return;
    }

    public void setNextIndent(int n) {
    }

    public void setThisIndent(int n) {
    }

    public void unindent() {
    }
}

