/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.apache.xml.serialize.TextSerializer;
import org.apache.xml.serialize.XHTMLSerializer;
import org.apache.xml.serialize.XMLSerializer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string2) {
        this._method = string2;
        if (!(string2.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            throw new IllegalArgumentException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string2}));
        }
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        throw new IllegalStateException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method}));
    }

    @Override
    protected String getSupportedMethod() {
        return this._method;
    }

    @Override
    public Serializer makeSerializer(OutputStream outputStream, OutputFormat object) throws UnsupportedEncodingException {
        object = this.getSerializer((OutputFormat)object);
        object.setOutputByteStream(outputStream);
        return object;
    }

    @Override
    public Serializer makeSerializer(Writer writer, OutputFormat object) {
        object = this.getSerializer((OutputFormat)object);
        object.setOutputCharStream(writer);
        return object;
    }

    @Override
    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }
}

