/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextSerializer
extends BaseMarkupSerializer {
    public TextSerializer() {
        super(new OutputFormat("text", null, false));
    }

    protected void characters(String string2, boolean bl) throws IOException {
        ElementState elementState = this.content();
        elementState.inCData = false;
        elementState.doCData = false;
        this.printText(string2, true, true);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            ElementState elementState = this.content();
            elementState.inCData = false;
            elementState.doCData = false;
            this.printText(cArray, n, n2, true, true);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void comment(String string2) {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
    }

    @Override
    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (!this.isDocumentState()) {
            if (elementState.empty) {
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    @Override
    public void endElement(String string2) throws SAXException {
        try {
            this.endElementIO(string2);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (string4 != null) {
            string3 = string4;
        }
        this.endElement(string3);
    }

    public void endElementIO(String object) throws IOException {
        this.getElementState();
        object = this.leaveElementState();
        ((ElementState)object).afterElement = true;
        ((ElementState)object).empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    protected String getEntityRef(int n) {
        return null;
    }

    @Override
    public void processingInstructionIO(String string2, String string3) throws IOException {
    }

    @Override
    protected void serializeElement(Element node) throws IOException {
        block5: {
            String string2 = node.getTagName();
            ElementState elementState = this.getElementState();
            if (this.isDocumentState() && !this._started) {
                this.startDocument(string2);
            }
            boolean bl = elementState.preserveSpace;
            if (node.hasChildNodes()) {
                this.enterElementState(null, null, string2, bl);
                node = node.getFirstChild();
                while (true) {
                    if (node == null) {
                        this.endElementIO(string2);
                        break block5;
                    }
                    this.serializeNode(node);
                    node = node.getNextSibling();
                }
            }
            if (!this.isDocumentState()) {
                elementState.afterElement = true;
                elementState.empty = false;
            }
        }
    }

    @Override
    protected void serializeNode(Node node) throws IOException {
        short s = node.getNodeType();
        if (s != 1) {
            if (s != 9 && s != 11) {
                if (s != 3 ? s == 4 && node.getNodeValue() != null : node.getNodeValue() != null) {
                    this.characters(node.getNodeValue(), true);
                }
            } else {
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.serializeNode(node);
                }
            }
        } else {
            this.serializeElement((Element)node);
        }
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("text", null, false);
        }
        super.setOutputFormat(outputFormat);
    }

    protected void startDocument(String string2) throws IOException {
        this._printer.leaveDTD();
        this._started = true;
        this.serializePreRoot();
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (string4 != null) {
            string3 = string4;
        }
        this.startElement(string3, null);
    }

    @Override
    public void startElement(String string2, AttributeList object) throws SAXException {
        try {
            object = this.getElementState();
            if (this.isDocumentState() && !this._started) {
                this.startDocument(string2);
            }
            this.enterElementState(null, null, string2, ((ElementState)object).preserveSpace);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

