/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected static final String PREFIX = "NS";
    protected boolean fDOML1;
    protected NamespaceSupport fLocalNSBinder;
    protected NamespaceSupport fNSBinder;
    protected int fNamespaceCounter;
    protected boolean fNamespaces;
    private boolean fPreserveSpace;
    protected SymbolTable fSymbolTable;

    public XML11Serializer() {
        this.fDOML1 = false;
        this.fNamespaceCounter = 1;
        this.fNamespaces = false;
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream outputStream, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", null, false);
        }
        super(outputStream, outputFormat);
        this.fDOML1 = false;
        this.fNamespaceCounter = 1;
        this.fNamespaces = false;
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
        this.fDOML1 = false;
        this.fNamespaceCounter = 1;
        this.fNamespaces = false;
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat outputFormat) {
        super(outputFormat);
        this.fDOML1 = false;
        this.fNamespaceCounter = 1;
        this.fNamespaces = false;
        this._format.setVersion("1.1");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void characters(char[] var1_1, int var2_3, int var3_4) throws SAXException {
        try {
            block17: {
                var4_5 = this.content();
                if (var4_5.inCData || var4_5.doCData) break block17;
                if (var4_5.preserveSpace) {
                    var5_6 = this._printer.getNextIndent();
                    this._printer.setNextIndent(0);
                    this.printText(var1_1, var2_3, var3_4, true, var4_5.unescaped);
                    this._printer.setNextIndent(var5_6);
                } else {
                    this.printText(var1_1, var2_3, var3_4, false, var4_5.unescaped);
                }
                ** GOTO lbl22
            }
            if (!var4_5.inCData) {
                this._printer.printText("<![CDATA[");
                var4_5.inCData = true;
            }
            var6_8 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
        }
        catch (IOException var1_2) {
            throw new SAXException(var1_2);
        }
        while (true) lbl-1000:
        // 2 sources

        {
            if (var2_3 < var3_4) ** break block18
            this._printer.setNextIndent(var6_8);
lbl22:
            // 3 sources

            return;
            break;
        }
        {
            block16: {
                var7_9 = var1_1[var2_3];
                if (var7_9 == ']' && (var5_7 = var2_3 + 2) < var3_4 && var1_1[var2_3 + 1] == ']' && var1_1[var5_7] == '>') {
                    this._printer.printText("]]]]><![CDATA[>");
                    var2_3 = var5_7;
                    break block16;
                }
                if (XML11Char.isXML11Valid(var7_9)) ** GOTO lbl47
                if (++var2_3 >= var3_4) ** GOTO lbl38
                this.surrogates(var7_9, var1_1[var2_3]);
                break block16;
lbl38:
                // 1 sources

                var4_5 = new StringBuffer();
                var4_5.append("The character '");
                var4_5.append(var7_9);
                var4_5.append("' is an invalid XML character");
                this.fatalError(var4_5.toString());
                break block16;
lbl47:
                // 1 sources

                if (this._encodingInfo.isPrintable(var7_9) && XML11Char.isXML11ValidLiteral(var7_9)) {
                    this._printer.printText(var7_9);
                    break block16;
                }
                this._printer.printText("]]>&#x");
                this._printer.printText(Integer.toHexString(var7_9));
                this._printer.printText(";<![CDATA[");
            }
            ++var2_3;
            ** while (true)
        }
    }

    @Override
    protected final void printCDATAText(String string2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string2.charAt(n2);
            if (c == ']' && (n3 = n2 + 2) < n && string2.charAt(n2 + 1) == ']' && string2.charAt(n3) == '>') {
                if (this.fFeatures != null && this.fDOMErrorHandler != null) {
                    if (!this.getFeature("split-cdata-sections")) {
                        this.modifyDOMError(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null), (short)2, this.fCurrentNode);
                        if (!this.fDOMErrorHandler.handleError(this.fDOMError)) {
                            throw new IOException();
                        }
                    } else {
                        this.modifyDOMError(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null), (short)0, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                n2 = n3;
            } else if (!XML11Char.isXML11Valid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (this._encodingInfo.isPrintable(c) && XML11Char.isXML11ValidLiteral(c)) {
                this._printer.printText(c);
            } else {
                this._printer.printText("]]>&#x");
                this._printer.printText(Integer.toHexString(c));
                this._printer.printText(";<![CDATA[");
            }
            ++n2;
        }
        return;
    }

    @Override
    protected void printEscaped(String string2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!XML11Char.isXML11Valid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else {
                this.printXMLChar(c);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = n3;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                char c = string2.charAt(n2);
                if (!XML11Char.isXML11Valid(c)) {
                    if (++n2 < n) {
                        this.surrogates(c, string2.charAt(n2));
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The character '");
                        stringBuffer.append(c);
                        stringBuffer.append("' is an invalid XML character");
                        this.fatalError(stringBuffer.toString());
                    }
                } else if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n2;
            }
        }
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!XML11Char.isXML11Valid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (XML11Char.isXML11Space(c)) {
                this._printer.printSpace();
            } else if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                this._printer.printText(c);
            } else {
                this.printXMLChar(c);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void printText(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3 = n;
        int n4 = n2;
        if (bl) {
            while (true) {
                n3 = n2 - 1;
                if (n2 <= 0) return;
                char c = cArray[n];
                ++n;
                if (!XML11Char.isXML11Valid(c)) {
                    if (++n < n3) {
                        this.surrogates(c, cArray[n]);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The character '");
                        stringBuffer.append(c);
                        stringBuffer.append("' is an invalid XML character");
                        this.fatalError(stringBuffer.toString());
                    }
                } else if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                n2 = n3;
            }
        }
        while (true) {
            n2 = n4 - 1;
            if (n4 <= 0) {
                return;
            }
            char c = cArray[n3];
            n = n3 + 1;
            if (!XML11Char.isXML11Valid(c)) {
                if (++n < n2) {
                    this.surrogates(c, cArray[n]);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (XML11Char.isXML11Space(c)) {
                this._printer.printSpace();
            } else if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                this._printer.printText(c);
            } else {
                this.printXMLChar(c);
            }
            n4 = n2;
            n3 = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final void printXMLChar(int n) throws IOException {
        block7: {
            String string2;
            Printer printer;
            block5: {
                block6: {
                    block4: {
                        if (n != 60) break block4;
                        printer = this._printer;
                        string2 = "&lt;";
                        break block5;
                    }
                    if (n != 38) break block6;
                    printer = this._printer;
                    string2 = "&amp;";
                    break block5;
                }
                if (n != 34) break block7;
                printer = this._printer;
                string2 = "&quot;";
            }
            printer.printText(string2);
            return;
        }
        EncodingInfo encodingInfo = this._encodingInfo;
        char c = (char)n;
        if (encodingInfo.isPrintable(c) && XML11Char.isXML11ValidLiteral(n)) {
            this._printer.printText(c);
            return;
        }
        this._printer.printText("&#x");
        this._printer.printText(Integer.toHexString(n));
        this._printer.printText(';');
    }

    @Override
    public boolean reset() {
        super.reset();
        return true;
    }

    @Override
    protected final void surrogates(int n, int n2) throws IOException {
        block7: {
            CharSequence charSequence;
            block4: {
                block6: {
                    block2: {
                        String string2;
                        Printer printer;
                        block5: {
                            block3: {
                                if (!XMLChar.isHighSurrogate(n)) break block2;
                                if (XMLChar.isLowSurrogate(n2)) break block3;
                                charSequence = new StringBuffer();
                                ((StringBuffer)charSequence).append("The character '");
                                ((StringBuffer)charSequence).append((char)n2);
                                ((StringBuffer)charSequence).append("' is an invalid XML character");
                                charSequence = ((StringBuffer)charSequence).toString();
                                break block4;
                            }
                            if (XML11Char.isXML11Valid(n = XMLChar.supplemental((char)n, (char)n2))) break block5;
                            charSequence = new StringBuffer();
                            break block6;
                        }
                        if (this.content().inCData) {
                            this._printer.printText("]]>&#x");
                            this._printer.printText(Integer.toHexString(n));
                            printer = this._printer;
                            string2 = ";<![CDATA[";
                        } else {
                            this._printer.printText("&#x");
                            this._printer.printText(Integer.toHexString(n));
                            printer = this._printer;
                            string2 = ";";
                        }
                        printer.printText(string2);
                        break block7;
                    }
                    charSequence = new StringBuffer();
                }
                ((StringBuffer)charSequence).append("The character '");
                ((StringBuffer)charSequence).append((char)n);
                ((StringBuffer)charSequence).append("' is an invalid XML character");
                charSequence = ((StringBuffer)charSequence).toString();
            }
            this.fatalError((String)charSequence);
        }
    }
}

