/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected static final String PREFIX = "NS";
    protected NamespaceSupport fLocalNSBinder;
    protected NamespaceSupport fNSBinder;
    protected boolean fNamespaces;
    private boolean fPreserveSpace;
    protected SymbolTable fSymbolTable;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
        this.fNamespaces = false;
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", null, false);
        }
        super(outputFormat);
        this.fNamespaces = false;
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", null, false);
        }
        super(outputFormat);
        this.fNamespaces = false;
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", null, false);
        }
        super(outputFormat);
        this.fNamespaces = false;
        this._format.setMethod("xml");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        --n;
        while (true) {
            block6: {
                block8: {
                    String string2;
                    block7: {
                        if (n < 0) {
                            return attributesImpl;
                        }
                        string2 = attributesImpl.getQName(n);
                        if (!string2.startsWith("xmlns")) break block6;
                        if (string2.length() != 5) break block7;
                        this.startPrefixMapping("", attributes.getValue(n));
                        break block8;
                    }
                    if (string2.charAt(5) != ':') break block6;
                    this.startPrefixMapping(string2.substring(6), attributes.getValue(n));
                }
                attributesImpl.removeAttribute(n);
            }
            --n;
        }
    }

    private void printAttribute(String string2, String string3, boolean bl) throws IOException {
        if (bl || this.fFeatures != null && !((Boolean)this.fFeatures.get("discard-default-content")).booleanValue()) {
            this._printer.printSpace();
            this._printer.printText(string2);
            this._printer.printText("=\"");
            this.printEscaped(string3);
            this._printer.printText('\"');
        }
        if (string2.equals("xml:space")) {
            bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
            this.fPreserveSpace = bl;
        }
    }

    private void printNamespaceAttr(String string2, String string3) throws IOException {
        this._printer.printSpace();
        if (string2 == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            Printer printer = this._printer;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("xmlns:");
            stringBuffer.append(string2);
            printer.printText(stringBuffer.toString());
        }
        this._printer.printText("=\"");
        this.printEscaped(string3);
        this._printer.printText('\"');
    }

    @Override
    public void endElement(String string2) throws SAXException {
        this.endElement(null, null, string2);
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.endElementIO(string2, string3, string4);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String object, String string2, String string3) throws IOException {
        this._printer.unindent();
        object = this.getElementState();
        if (((ElementState)object).empty) {
            this._printer.printText("/>");
        } else {
            if (((ElementState)object).inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !((ElementState)object).preserveSpace && (((ElementState)object).afterElement || ((ElementState)object).afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(((ElementState)object).rawName);
            this._printer.printText('>');
        }
        object = this.leaveElementState();
        ((ElementState)object).afterElement = true;
        ((ElementState)object).afterComment = false;
        ((ElementState)object).empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    protected String getEntityRef(int n) {
        if (n != 34) {
            if (n != 60) {
                if (n != 62) {
                    if (n != 38) {
                        if (n != 39) {
                            return null;
                        }
                        return "apos";
                    }
                    return "amp";
                }
                return "gt";
            }
            return "lt";
        }
        return "quot";
    }

    @Override
    protected void printEscaped(String string2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else {
                this.printXMLChar(c);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = n3;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                char c = string2.charAt(n2);
                if (!XMLChar.isValid(c)) {
                    if (++n2 < n) {
                        this.surrogates(c, string2.charAt(n2));
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The character '");
                        stringBuffer.append(c);
                        stringBuffer.append("' is an invalid XML character");
                        this.fatalError(stringBuffer.toString());
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n2;
            }
        }
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (XMLChar.isSpace(c)) {
                this._printer.printSpace();
            } else if (bl2) {
                this._printer.printText(c);
            } else {
                this.printXMLChar(c);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void printText(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3 = n;
        int n4 = n2;
        if (bl) {
            while (true) {
                n3 = n2 - 1;
                if (n2 <= 0) return;
                char c = cArray[n];
                ++n;
                if (!XMLChar.isValid(c)) {
                    if (++n < n3) {
                        this.surrogates(c, cArray[n]);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("The character '");
                        stringBuffer.append(c);
                        stringBuffer.append("' is an invalid XML character");
                        this.fatalError(stringBuffer.toString());
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                n2 = n3;
            }
        }
        while (true) {
            n2 = n4 - 1;
            if (n4 <= 0) {
                return;
            }
            char c = cArray[n3];
            n = n3 + 1;
            if (!XMLChar.isValid(c)) {
                if (++n < n2) {
                    this.surrogates(c, cArray[n]);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("The character '");
                    stringBuffer.append(c);
                    stringBuffer.append("' is an invalid XML character");
                    this.fatalError(stringBuffer.toString());
                }
            } else if (XMLChar.isSpace(c)) {
                this._printer.printSpace();
            } else if (bl2) {
                this._printer.printText(c);
            } else {
                this.printXMLChar(c);
            }
            n4 = n2;
            n3 = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printXMLChar(int n) throws IOException {
        block7: {
            String string2;
            Printer printer;
            block5: {
                block6: {
                    block4: {
                        if (n != 60) break block4;
                        printer = this._printer;
                        string2 = "&lt;";
                        break block5;
                    }
                    if (n != 38) break block6;
                    printer = this._printer;
                    string2 = "&amp;";
                    break block5;
                }
                if (n != 34) break block7;
                printer = this._printer;
                string2 = "&quot;";
            }
            printer.printText(string2);
            return;
        }
        if (!(n >= 32 && this._encodingInfo.isPrintable((char)n) || n == 10 || n == 13 || n == 9)) {
            this._printer.printText("&#x");
            this._printer.printText(Integer.toHexString(n));
            this._printer.printText(';');
            return;
        }
        this._printer.printText((char)n);
    }

    @Override
    public boolean reset() {
        super.reset();
        NamespaceSupport namespaceSupport = this.fNSBinder;
        if (namespaceSupport != null) {
            namespaceSupport.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void serializeElement(Element var1_1) throws IOException {
        block56: {
            block62: {
                block59: {
                    block60: {
                        block64: {
                            block63: {
                                block61: {
                                    block57: {
                                        block58: {
                                            if (this.fNamespaces) {
                                                this.fLocalNSBinder.reset();
                                                this.fNSBinder.pushContext();
                                            }
                                            var2_2 = var1_1.getTagName();
                                            var3_3 = this.getElementState();
                                            if (this.isDocumentState()) {
                                                if (!this._started) {
                                                    this.startDocument(var2_2);
                                                }
                                            } else {
                                                if (var3_3.empty) {
                                                    this._printer.printText('>');
                                                }
                                                if (var3_3.inCData) {
                                                    this._printer.printText("]]>");
                                                    var3_3.inCData = false;
                                                }
                                                if (this._indenting && !var3_3.preserveSpace && (var3_3.empty || var3_3.afterElement || var3_3.afterComment)) {
                                                    this._printer.breakLine();
                                                }
                                            }
                                            this.fPreserveSpace = var3_3.preserveSpace;
                                            if (var1_1.hasAttributes()) {
                                                var4_4 = var1_1.getAttributes();
                                                var5_5 = var4_4.getLength();
                                            } else {
                                                var4_4 = null;
                                                var5_5 = 0;
                                            }
                                            if (!this.fNamespaces) {
                                                this._printer.printText('<');
                                                this._printer.printText(var2_2);
                                                this._printer.indent();
                                                for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
                                                    var7_7 = (Attr)var4_4.item(var6_6);
                                                    var8_8 = var7_7.getName();
                                                    var10_10 = var9_9 = var7_7.getValue();
                                                    if (var9_9 == null) {
                                                        var10_10 = "";
                                                    }
                                                    if (var7_7.getSpecified()) {
                                                        this._printer.printSpace();
                                                        this._printer.printText((String)var8_8);
                                                        this._printer.printText("=\"");
                                                        this.printEscaped((String)var10_10);
                                                        this._printer.printText('\"');
                                                    }
                                                    if (!var8_8.equals("xml:space")) continue;
                                                    this.fPreserveSpace = var10_10.equals("preserve") != false ? true : this._format.getPreserveSpace();
                                                }
                                            } else {
                                                var6_6 = 0;
lbl45:
                                                // 2 sources

                                                while (true) {
                                                    if (var6_6 < var5_5) break block56;
                                                    var9_9 = var1_1.getNamespaceURI();
                                                    var10_10 = var1_1.getPrefix();
                                                    if (var9_9 != null && var10_10 != null && var9_9.length() == 0 && var10_10.length() != 0) {
                                                        this._printer.printText('<');
                                                        this._printer.printText(var1_1.getLocalName());
                                                        this._printer.indent();
                                                        var10_10 = null;
                                                    } else {
                                                        this._printer.printText('<');
                                                        this._printer.printText(var2_2);
                                                        this._printer.indent();
                                                    }
                                                    if (var9_9 != null) {
                                                        var9_9 = this.fSymbolTable.addSymbol((String)var9_9);
                                                        var10_10 = var10_10 != null && var10_10.length() != 0 ? this.fSymbolTable.addSymbol((String)var10_10) : XMLSymbols.EMPTY_STRING;
                                                        if (this.fNSBinder.getURI((String)var10_10) != var9_9) {
                                                            this.printNamespaceAttr((String)var10_10, (String)var9_9);
                                                            this.fLocalNSBinder.declarePrefix((String)var10_10, (String)var9_9);
                                                            this.fNSBinder.declarePrefix((String)var10_10, (String)var9_9);
                                                        }
                                                    } else if (var1_1.getLocalName() == null) {
                                                        if (this.fDOMErrorHandler != null) {
                                                            var10_10 = new StringBuffer();
                                                            var10_10.append("DOM Level 1 Node: ");
                                                            var10_10.append(var1_1.getNodeName());
                                                            this.modifyDOMError(var10_10.toString(), (short)1, var1_1);
                                                            if (!this.fDOMErrorHandler.handleError(this.fDOMError)) {
                                                                throw new RuntimeException("Process stoped at user request");
                                                            }
                                                        }
                                                    } else {
                                                        var10_10 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                                                        if (var10_10 != null && var10_10.length() > 0) {
                                                            this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                                                            this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                                                            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                                                        }
                                                    }
                                                    var6_6 = 0;
lbl88:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var6_6 < var5_5) break block57;
                                                        break;
                                                    }
                                                    break;
                                                }
                                            }
                                            if (var1_1.hasChildNodes()) {
                                                var10_10 = this.enterElementState(null, null, var2_2, this.fPreserveSpace);
                                                var10_10.doCData = this._format.isCDataElement(var2_2);
                                                var10_10.unescaped = this._format.isNonEscapingElement(var2_2);
                                                var1_1 = var1_1.getFirstChild();
                                                while (true) {
                                                    if (var1_1 == null) {
                                                        if (this.fNamespaces) {
                                                            this.fNSBinder.popContext();
                                                        }
                                                        this.endElementIO(null, null, var2_2);
                                                        break block58;
                                                    }
                                                    this.serializeNode(var1_1);
                                                    var1_1 = var1_1.getNextSibling();
                                                }
                                            }
                                            if (this.fNamespaces) {
                                                this.fNSBinder.popContext();
                                            }
                                            this._printer.unindent();
                                            this._printer.printText("/>");
                                            var3_3.afterElement = true;
                                            var3_3.afterComment = false;
                                            var3_3.empty = false;
                                            if (this.isDocumentState()) {
                                                this._printer.flush();
                                            }
                                        }
                                        return;
                                    }
                                    var11_11 = (Attr)var4_4.item(var6_6);
                                    var8_8 = var11_11.getValue();
                                    var10_10 = var11_11.getNodeName();
                                    var12_12 = var11_11.getNamespaceURI();
                                    var9_9 = var10_10;
                                    var7_7 = var12_12;
                                    if (var12_12 != null) {
                                        var9_9 = var10_10;
                                        var7_7 = var12_12;
                                        if (var12_12.length() == 0) {
                                            var9_9 = var11_11.getLocalName();
                                            var7_7 = null;
                                        }
                                    }
                                    var10_10 = var8_8;
                                    if (var8_8 == null) {
                                        var10_10 = XMLSymbols.EMPTY_STRING;
                                    }
                                    if (var7_7 == null) break block60;
                                    var8_8 = var11_11.getPrefix();
                                    var8_8 = var8_8 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol((String)var8_8);
                                    var13_13 = this.fSymbolTable.addSymbol(var11_11.getLocalName());
                                    if (var7_7 == null || !var7_7.equals(NamespaceContext.XMLNS_URI)) break block61;
                                    var9_9 = var11_11.getPrefix();
                                    var9_9 = var9_9 != null && var9_9.length() != 0 ? this.fSymbolTable.addSymbol((String)var9_9) : XMLSymbols.EMPTY_STRING;
                                    var8_8 = this.fSymbolTable.addSymbol(var11_11.getLocalName());
                                    if (var9_9 == XMLSymbols.PREFIX_XMLNS) {
                                        var9_9 = this.fLocalNSBinder.getURI((String)var8_8);
                                        if ((var10_10 = this.fSymbolTable.addSymbol((String)var10_10)).length() != 0 && var9_9 == null) {
                                            this.printNamespaceAttr((String)var8_8, (String)var10_10);
                                            this.fLocalNSBinder.declarePrefix((String)var8_8, (String)var10_10);
                                        }
                                    } else {
                                        this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                                        var9_9 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                                        var10_10 = this.fSymbolTable.addSymbol((String)var10_10);
                                        if (var9_9 == null) {
                                            this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, (String)var10_10);
                                        }
                                    }
                                    break block62;
                                }
                                var12_12 = this.fSymbolTable.addSymbol((String)var7_7);
                                var7_7 = this.fNSBinder.getURI((String)var8_8);
                                if (var8_8 != XMLSymbols.EMPTY_STRING && var7_7 == var12_12) ** GOTO lbl200
                                var7_7 = var11_11.getNodeName();
                                var9_9 = this.fNSBinder.getPrefix(var12_12);
                                if (var9_9 == null || var9_9 == XMLSymbols.EMPTY_STRING) break block63;
                                var8_8 = new StringBuffer();
                                var8_8.append((String)var9_9);
                                var8_8.append(":");
                                var8_8.append(var13_13);
                                var9_9 = var8_8.toString();
                                ** GOTO lbl200
                            }
                            if (var8_8 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI((String)var8_8) != null) break block64;
                            var9_9 = var8_8;
                            var8_8 = var7_7;
                            ** GOTO lbl193
                        }
                        var8_8 = this.fSymbolTable;
                        var9_9 = new StringBuffer();
                        var9_9.append("NS");
                        var9_9.append(1);
                        var9_9 = var8_8.addSymbol(var9_9.toString());
                        var14_14 = 2;
                        while (true) {
                            block65: {
                                if (this.fLocalNSBinder.getURI((String)var9_9) != null) break block65;
                                var8_8 = new StringBuffer();
                                var8_8.append((String)var9_9);
                                var8_8.append(":");
                                var8_8.append(var13_13);
                                var8_8 = var8_8.toString();
lbl193:
                                // 2 sources

                                this.printNamespaceAttr((String)var9_9, var12_12);
                                var10_10 = this.fSymbolTable.addSymbol((String)var10_10);
                                this.fLocalNSBinder.declarePrefix((String)var9_9, (String)var10_10);
                                this.fNSBinder.declarePrefix((String)var9_9, var12_12);
                                var9_9 = var8_8;
lbl200:
                                // 3 sources

                                var8_8 = var10_10;
                                var7_7 = var9_9;
                                if (var10_10 == null) {
                                    var8_8 = XMLSymbols.EMPTY_STRING;
                                    var7_7 = var9_9;
                                }
                                break block59;
                            }
                            var8_8 = this.fSymbolTable;
                            var9_9 = new StringBuffer();
                            var9_9.append("NS");
                            var9_9.append(var14_14);
                            var9_9 = var8_8.addSymbol(var9_9.toString());
                            ++var14_14;
                        }
                    }
                    var8_8 = var10_10;
                    var7_7 = var9_9;
                    if (var11_11.getLocalName() == null) {
                        var8_8 = var10_10;
                        var7_7 = var9_9;
                        if (this.fDOMErrorHandler != null) {
                            var8_8 = new StringBuffer();
                            var8_8.append("DOM Level 1 Node: ");
                            var8_8.append((String)var9_9);
                            this.modifyDOMError(var8_8.toString(), (short)1, var11_11);
                            if (this.fDOMErrorHandler.handleError(this.fDOMError)) {
                                var8_8 = var10_10;
                                var7_7 = var9_9;
                            } else {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    }
                }
                this.printAttribute((String)var7_7, (String)var8_8, var11_11.getSpecified());
            }
            ++var6_6;
            ** while (true)
        }
        var8_8 = (Attr)var4_4.item(var6_6);
        var10_10 = var8_8.getNamespaceURI();
        if (var10_10 != null && var10_10.equals(NamespaceContext.XMLNS_URI)) {
            var10_10 = var9_9 = var8_8.getNodeValue();
            if (var9_9 == null) {
                var10_10 = XMLSymbols.EMPTY_STRING;
            }
            if (var10_10.equals(NamespaceContext.XMLNS_URI)) {
                if (this.fDOMErrorHandler != null) {
                    this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, (Node)var8_8);
                    if (!this.fDOMErrorHandler.handleError(this.fDOMError)) {
                        throw new RuntimeException("Stopped at user request");
                    }
                }
            } else {
                var9_9 = var8_8.getPrefix();
                var9_9 = var9_9 != null && var9_9.length() != 0 ? this.fSymbolTable.addSymbol((String)var9_9) : XMLSymbols.EMPTY_STRING;
                var8_8 = this.fSymbolTable.addSymbol(var8_8.getLocalName());
                if (var9_9 == XMLSymbols.PREFIX_XMLNS) {
                    if ((var10_10 = this.fSymbolTable.addSymbol((String)var10_10)).length() != 0) {
                        this.fNSBinder.declarePrefix((String)var8_8, (String)var10_10);
                    }
                } else {
                    var10_10 = this.fSymbolTable.addSymbol((String)var10_10);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, (String)var10_10);
                }
            }
        }
        ++var6_6;
        ** while (true)
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", null, false);
        }
        super.setOutputFormat(outputFormat);
    }

    protected void startDocument(String string2) throws IOException {
        block12: {
            Object object;
            block14: {
                String string3;
                block13: {
                    string3 = this._printer.leaveDTD();
                    if (this._started) break block12;
                    if (!this._format.getOmitXMLDeclaration()) {
                        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                        object = this._format.getVersion() != null ? this._format.getVersion() : "1.0";
                        stringBuffer.append((String)object);
                        stringBuffer.append('\"');
                        object = this._format.getEncoding();
                        if (object != null) {
                            stringBuffer.append(" encoding=\"");
                            stringBuffer.append((String)object);
                            stringBuffer.append('\"');
                        }
                        if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                            stringBuffer.append(" standalone=\"yes\"");
                        }
                        stringBuffer.append("?>");
                        this._printer.printText(stringBuffer);
                        this._printer.breakLine();
                    }
                    if (this._format.getOmitDocumentType()) break block12;
                    if (this._docTypeSystemId == null) break block13;
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string2);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            for (int i = 0; i < string2.length() + 18; ++i) {
                                this._printer.printText(" ");
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                    } else {
                        this._printer.printText(" SYSTEM ");
                    }
                    this.printDoctypeURL(this._docTypeSystemId);
                    if (string3 != null && string3.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string3, true, true);
                        this._printer.printText(']');
                    }
                    object = this._printer;
                    string2 = ">";
                    break block14;
                }
                if (string3 == null || string3.length() <= 0) break block12;
                this._printer.printText("<!DOCTYPE ");
                this._printer.printText(string2);
                this._printer.printText(" [");
                this.printText(string3, true, true);
                object = this._printer;
                string2 = "]>";
            }
            ((Printer)object).printText(string2);
            this._printer.breakLine();
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String object, String object2, String object3, Attributes object4) throws SAXException {
        try {
            boolean bl;
            Object object5;
            Object object6;
            block33: {
                Attributes attributes;
                int n;
                boolean bl2;
                block34: {
                    block29: {
                        block32: {
                            block31: {
                                block30: {
                                    object6 = this._printer;
                                    if (object6 == null) break block29;
                                    object5 = this.getElementState();
                                    bl2 = this.isDocumentState();
                                    n = 0;
                                    if (bl2) {
                                        if (!this._started) {
                                            object6 = object2 != null && ((String)object2).length() != 0 ? object2 : object3;
                                            this.startDocument((String)object6);
                                        }
                                    } else {
                                        if (((ElementState)object5).empty) {
                                            this._printer.printText('>');
                                        }
                                        if (((ElementState)object5).inCData) {
                                            this._printer.printText("]]>");
                                            ((ElementState)object5).inCData = false;
                                        }
                                        if (this._indenting && !((ElementState)object5).preserveSpace && (((ElementState)object5).empty || ((ElementState)object5).afterElement || ((ElementState)object5).afterComment)) {
                                            this._printer.breakLine();
                                        }
                                    }
                                    bl2 = ((ElementState)object5).preserveSpace;
                                    attributes = this.extractNamespaces((Attributes)object4);
                                    if (object3 == null) break block30;
                                    object4 = object3;
                                    if (((String)object3).length() != 0) break block31;
                                }
                                if (object2 == null) break block32;
                                if (object != null && !((String)object).equals("") && (object3 = this.getPrefix((String)object)) != null && ((String)object3).length() > 0) {
                                    object4 = new StringBuffer();
                                    ((StringBuffer)object4).append((String)object3);
                                    ((StringBuffer)object4).append(":");
                                    ((StringBuffer)object4).append((String)object2);
                                    object4 = ((StringBuffer)object4).toString();
                                } else {
                                    object4 = object2;
                                }
                            }
                            this._printer.printText('<');
                            this._printer.printText((String)object4);
                            this._printer.indent();
                            bl = bl2;
                            if (attributes == null) break block33;
                            break block34;
                        }
                        object2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                        object = new SAXException((String)object2);
                        throw object;
                    }
                    object = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                    object2 = new IllegalStateException((String)object);
                    throw object2;
                }
                while (true) {
                    block35: {
                        block36: {
                            if (n >= attributes.getLength()) {
                                bl = bl2;
                                break;
                            }
                            this._printer.printSpace();
                            object3 = object6 = attributes.getQName(n);
                            if (object6 == null) break block35;
                            object3 = object6;
                            if (((String)object6).length() != 0) break block35;
                            object6 = attributes.getLocalName(n);
                            object5 = attributes.getURI(n);
                            object3 = object6;
                            if (object5 == null) break block35;
                            object3 = object6;
                            if (((String)object5).length() == 0) break block35;
                            if (object == null || ((String)object).length() == 0) break block36;
                            object3 = object6;
                            if (((String)object5).equals(object)) break block35;
                        }
                        object5 = this.getPrefix((String)object5);
                        object3 = object6;
                        if (object5 != null) {
                            object3 = object6;
                            if (((String)object5).length() > 0) {
                                object3 = new StringBuffer();
                                ((StringBuffer)object3).append((String)object5);
                                ((StringBuffer)object3).append(":");
                                ((StringBuffer)object3).append((String)object6);
                                object3 = ((StringBuffer)object3).toString();
                            }
                        }
                    }
                    object6 = object5 = attributes.getValue(n);
                    if (object5 == null) {
                        object6 = "";
                    }
                    this._printer.printText((String)object3);
                    this._printer.printText("=\"");
                    this.printEscaped((String)object6);
                    this._printer.printText('\"');
                    if (((String)object3).equals("xml:space")) {
                        bl2 = ((String)object6).equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object6 = this._prefixes.keys();
                while (object6.hasMoreElements()) {
                    this._printer.printSpace();
                    object3 = (String)object6.nextElement();
                    object5 = (String)this._prefixes.get(object3);
                    if (((String)object5).length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped((String)object3);
                        object3 = this._printer;
                    } else {
                        this._printer.printText("xmlns:");
                        this._printer.printText((String)object5);
                        this._printer.printText("=\"");
                        this.printEscaped((String)object3);
                        object3 = this._printer;
                    }
                    ((Printer)object3).printText('\"');
                }
            }
            object6 = this.enterElementState((String)object, (String)object2, (String)object4, bl);
            object3 = object4;
            if (object2 != null) {
                if (((String)object2).length() == 0) {
                    object3 = object4;
                } else {
                    object3 = new StringBuffer();
                    ((StringBuffer)object3).append((String)object);
                    ((StringBuffer)object3).append("^");
                    ((StringBuffer)object3).append((String)object2);
                    object3 = ((StringBuffer)object3).toString();
                }
            }
            ((ElementState)object6).doCData = this._format.isCDataElement((String)object3);
            ((ElementState)object6).unescaped = this._format.isNonEscapingElement((String)object3);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String object, AttributeList object2) throws SAXException {
        try {
            boolean bl;
            block14: {
                int n;
                boolean bl2;
                Object object3;
                block15: {
                    block13: {
                        if (this._printer == null) break block13;
                        object3 = this.getElementState();
                        bl2 = this.isDocumentState();
                        n = 0;
                        if (bl2) {
                            if (!this._started) {
                                this.startDocument((String)object);
                            }
                        } else {
                            if (((ElementState)object3).empty) {
                                this._printer.printText('>');
                            }
                            if (((ElementState)object3).inCData) {
                                this._printer.printText("]]>");
                                ((ElementState)object3).inCData = false;
                            }
                            if (this._indenting && !((ElementState)object3).preserveSpace && (((ElementState)object3).empty || ((ElementState)object3).afterElement || ((ElementState)object3).afterComment)) {
                                this._printer.breakLine();
                            }
                        }
                        bl2 = ((ElementState)object3).preserveSpace;
                        this._printer.printText('<');
                        this._printer.printText((String)object);
                        this._printer.indent();
                        bl = bl2;
                        if (object2 == null) break block14;
                        break block15;
                    }
                    object2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                    object = new IllegalStateException((String)object2);
                    throw object;
                }
                while (true) {
                    if (n >= object2.getLength()) {
                        bl = bl2;
                        break;
                    }
                    this._printer.printSpace();
                    object3 = object2.getName(n);
                    String string2 = object2.getValue(n);
                    if (string2 != null) {
                        this._printer.printText((String)object3);
                        this._printer.printText("=\"");
                        this.printEscaped(string2);
                        this._printer.printText('\"');
                    }
                    if (((String)object3).equals("xml:space")) {
                        bl2 = string2.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            object2 = this.enterElementState(null, null, (String)object, bl);
            ((ElementState)object2).doCData = this._format.isCDataElement((String)object);
            ((ElementState)object2).unescaped = this._format.isNonEscapingElement((String)object);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

