/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Cookie {
    public static String escape(String charSequence) {
        String string2 = ((String)charSequence).trim();
        int n = string2.length();
        charSequence = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= ' ' && c != '+' && c != '%' && c != '=' && c != ';') {
                ((StringBuilder)charSequence).append(c);
                continue;
            }
            ((StringBuilder)charSequence).append('%');
            ((StringBuilder)charSequence).append(Character.forDigit((char)(c >>> 4 & 0xF), 16));
            ((StringBuilder)charSequence).append(Character.forDigit((char)(c & 0xF), 16));
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject toJSONObject(String object) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONTokener jSONTokener = new JSONTokener((String)object);
        jSONObject.put("name", jSONTokener.nextTo('='));
        jSONTokener.next('=');
        jSONObject.put("value", jSONTokener.nextTo(';'));
        jSONTokener.next();
        while (jSONTokener.more()) {
            String string2 = Cookie.unescape(jSONTokener.nextTo("=;"));
            if (jSONTokener.next() != '=') {
                if (!string2.equals("secure")) throw jSONTokener.syntaxError("Missing '=' in cookie parameter.");
                object = Boolean.TRUE;
            } else {
                object = Cookie.unescape(jSONTokener.nextTo(';'));
                jSONTokener.next();
            }
            jSONObject.put(string2, object);
        }
        return jSONObject;
    }

    public static String toString(JSONObject jSONObject) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Cookie.escape(jSONObject.getString("name")));
        stringBuilder.append("=");
        stringBuilder.append(Cookie.escape(jSONObject.getString("value")));
        if (jSONObject.has("expires")) {
            stringBuilder.append(";expires=");
            stringBuilder.append(jSONObject.getString("expires"));
        }
        if (jSONObject.has("domain")) {
            stringBuilder.append(";domain=");
            stringBuilder.append(Cookie.escape(jSONObject.getString("domain")));
        }
        if (jSONObject.has("path")) {
            stringBuilder.append(";path=");
            stringBuilder.append(Cookie.escape(jSONObject.getString("path")));
        }
        if (jSONObject.optBoolean("secure")) {
            stringBuilder.append(";secure");
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5;
            int n6 = string2.charAt(n2);
            if (n6 == 43) {
                n5 = 32;
                n4 = n2;
                n3 = n5;
            } else {
                n4 = n2;
                n3 = n6;
                if (n6 == 37) {
                    n5 = n2 + 2;
                    n4 = n2;
                    n3 = n6;
                    if (n5 < n) {
                        int n7 = JSONTokener.dehexchar(string2.charAt(n2 + 1));
                        int n8 = JSONTokener.dehexchar(string2.charAt(n5));
                        n4 = n2;
                        n3 = n6;
                        if (n7 >= 0) {
                            n4 = n2;
                            n3 = n6;
                            if (n8 >= 0) {
                                n2 = (char)(n7 * 16 + n8);
                                n4 = n5;
                                n3 = n2;
                            }
                        }
                    }
                }
            }
            stringBuilder.append((char)n3);
            n2 = n4 + 1;
        }
        return stringBuilder.toString();
    }
}

