/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONArray
implements Iterable<Object> {
    private final ArrayList<Object> myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(Object object) throws JSONException {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.put(JSONObject.wrap(Array.get(object, i)));
            }
            return;
        }
        throw new JSONException("JSONArray initial value should be a string or collection or array.");
    }

    public JSONArray(String string2) throws JSONException {
        this(new JSONTokener(string2));
    }

    public JSONArray(Collection<Object> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.myArrayList.add(JSONObject.wrap(object.next()));
            }
        }
    }

    public JSONArray(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() == '[') {
            if (jSONTokener.nextClean() != ']') {
                jSONTokener.back();
                while (true) {
                    if (jSONTokener.nextClean() == ',') {
                        jSONTokener.back();
                        this.myArrayList.add(JSONObject.NULL);
                    } else {
                        jSONTokener.back();
                        this.myArrayList.add(jSONTokener.nextValue());
                    }
                    char c = jSONTokener.nextClean();
                    if (c != ',') {
                        if (c == ']') {
                            return;
                        }
                        throw jSONTokener.syntaxError("Expected a ',' or ']'");
                    }
                    if (jSONTokener.nextClean() == ']') {
                        return;
                    }
                    jSONTokener.back();
                }
            }
            return;
        }
        throw jSONTokener.syntaxError("A JSONArray text must start with '['");
    }

    public Object get(int n) throws JSONException {
        Object object = this.opt(n);
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONArray[");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("] not found.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public BigDecimal getBigDecimal(int n) throws JSONException {
        Object object = this.get(n);
        try {
            object = new BigDecimal(object.toString());
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONArray[");
            stringBuilder.append(n);
            stringBuilder.append("] could not convert to BigDecimal.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public BigInteger getBigInteger(int n) throws JSONException {
        Object object = this.get(n);
        try {
            object = new BigInteger(object.toString());
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONArray[");
            stringBuilder.append(n);
            stringBuilder.append("] could not convert to BigInteger.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public boolean getBoolean(int n) throws JSONException {
        boolean bl;
        Object object = this.get(n);
        if (!(object.equals(Boolean.FALSE) || (bl = object instanceof String) && ((String)object).equalsIgnoreCase("false"))) {
            if (!(object.equals(Boolean.TRUE) || bl && ((String)object).equalsIgnoreCase("true"))) {
                object = new StringBuilder();
                ((StringBuilder)object).append("JSONArray[");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("] is not a boolean.");
                throw new JSONException(((StringBuilder)object).toString());
            }
            return true;
        }
        return false;
    }

    public double getDouble(int n) throws JSONException {
        Object object = this.get(n);
        try {
            double d = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
            return d;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONArray[");
            stringBuilder.append(n);
            stringBuilder.append("] is not a number.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, int n) throws JSONException {
        Object object = this.optEnum(clazz, n);
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(JSONObject.quote(Integer.toString(n)));
        ((StringBuilder)object).append("] is not an enum of type ");
        ((StringBuilder)object).append(JSONObject.quote(clazz.getSimpleName()));
        ((StringBuilder)object).append(".");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public int getInt(int n) throws JSONException {
        block4: {
            int n2;
            Object object;
            block3: {
                object = this.get(n);
                try {
                    int n3;
                    if (!(object instanceof Number)) break block3;
                    n = n3 = ((Number)object).intValue();
                    break block4;
                }
                catch (Exception exception) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("JSONArray[");
                    stringBuilder.append(n);
                    stringBuilder.append("] is not a number.");
                    throw new JSONException(stringBuilder.toString());
                }
            }
            n = n2 = Integer.parseInt((String)object);
        }
        return n;
    }

    public JSONArray getJSONArray(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONArray[");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("] is not a JSONArray.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public JSONObject getJSONObject(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONArray[");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("] is not a JSONObject.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public long getLong(int n) throws JSONException {
        Object object = this.get(n);
        try {
            long l = object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
            return l;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONArray[");
            stringBuilder.append(n);
            stringBuilder.append("] is not a number.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public String getString(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONArray[");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("] not a string.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public boolean isNull(int n) {
        return JSONObject.NULL.equals(this.opt(n));
    }

    @Override
    public Iterator<Object> iterator() {
        return this.myArrayList.iterator();
    }

    public String join(String string2) throws JSONException {
        int n = this.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return stringBuilder.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int n) {
        Object object = n >= 0 && n < this.length() ? this.myArrayList.get(n) : null;
        return object;
    }

    public BigDecimal optBigDecimal(int n, BigDecimal bigDecimal) {
        try {
            BigDecimal bigDecimal2 = this.getBigDecimal(n);
            return bigDecimal2;
        }
        catch (Exception exception) {
            return bigDecimal;
        }
    }

    public BigInteger optBigInteger(int n, BigInteger bigInteger) {
        try {
            BigInteger bigInteger2 = this.getBigInteger(n);
            return bigInteger2;
        }
        catch (Exception exception) {
            return bigInteger;
        }
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            boolean bl2 = this.getBoolean(n);
            return bl2;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d) {
        try {
            double d2 = this.getDouble(n);
            return d2;
        }
        catch (Exception exception) {
            return d;
        }
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, int n) {
        return this.optEnum(clazz, n, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, int n, E e) {
        Object object;
        block4: {
            object = this.opt(n);
            if (!JSONObject.NULL.equals(object)) break block4;
            return e;
        }
        try {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (E)((Enum)object);
            }
            clazz = Enum.valueOf(clazz, object.toString());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return e;
        }
        return (E)clazz;
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            n = this.getInt(n);
            return n;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JSONArray optJSONArray(int n) {
        Object object = this.opt(n);
        object = object instanceof JSONArray ? (JSONArray)object : null;
        return object;
    }

    public JSONObject optJSONObject(int n) {
        Object object = this.opt(n);
        object = object instanceof JSONObject ? (JSONObject)object : null;
        return object;
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            long l2 = this.getLong(n);
            return l2;
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string2) {
        Object object = this.opt(n);
        if (!JSONObject.NULL.equals(object)) {
            string2 = object.toString();
        }
        return string2;
    }

    public JSONArray put(double d) throws JSONException {
        Double d2 = new Double(d);
        JSONObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JSONArray put(int n) {
        this.put(new Integer(n));
        return this;
    }

    public JSONArray put(int n, double d) throws JSONException {
        this.put(n, new Double(d));
        return this;
    }

    public JSONArray put(int n, int n2) throws JSONException {
        this.put(n, new Integer(n2));
        return this;
    }

    public JSONArray put(int n, long l) throws JSONException {
        this.put(n, new Long(l));
        return this;
    }

    public JSONArray put(int n, Object object) throws JSONException {
        JSONObject.testValidity(object);
        if (n >= 0) {
            if (n < this.length()) {
                this.myArrayList.set(n, object);
            } else {
                while (n != this.length()) {
                    this.put(JSONObject.NULL);
                }
                this.put(object);
            }
            return this;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONArray[");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("] not found.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public JSONArray put(int n, Collection<Object> collection) throws JSONException {
        this.put(n, new JSONArray(collection));
        return this;
    }

    public JSONArray put(int n, Map<String, Object> map) throws JSONException {
        this.put(n, new JSONObject(map));
        return this;
    }

    public JSONArray put(int n, boolean bl) throws JSONException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.put(n, bl2);
        return this;
    }

    public JSONArray put(long l) {
        this.put(new Long(l));
        return this;
    }

    public JSONArray put(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public JSONArray put(Collection<Object> collection) {
        this.put(new JSONArray(collection));
        return this;
    }

    public JSONArray put(Map<String, Object> map) {
        this.put(new JSONObject(map));
        return this;
    }

    public JSONArray put(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.put(bl2);
        return this;
    }

    public Object remove(int n) {
        Object object = n >= 0 && n < this.length() ? this.myArrayList.remove(n) : null;
        return object;
    }

    public boolean similar(Object object) {
        JSONArray jSONArray;
        if (!(object instanceof JSONArray)) {
            return false;
        }
        int n = this.length();
        if (n != (jSONArray = (JSONArray)object).length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            object = this.get(i);
            Object object2 = jSONArray.get(i);
            if (!(object instanceof JSONObject ? !((JSONObject)object).similar(object2) : (object instanceof JSONArray ? !((JSONArray)object).similar(object2) : !object.equals(object2)))) continue;
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) throws JSONException {
        if (jSONArray != null && jSONArray.length() != 0 && this.length() != 0) {
            JSONObject jSONObject = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONObject.put(jSONArray.getString(i), this.opt(i));
            }
            return jSONObject;
        }
        return null;
    }

    public String toString() {
        try {
            String string2 = this.toString(0);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString(int n) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            return this.write(stringWriter, n, 0).toString();
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Writer write(Writer writer, int n, int n2) throws JSONException {
        try {
            int n3 = this.length();
            writer.write(91);
            if (n3 == 1) {
                JSONObject.writeValue(writer, this.myArrayList.get(0), n, n2);
            } else if (n3 != 0) {
                int n4 = n2 + n;
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    if (bl) {
                        writer.write(44);
                    }
                    if (n > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n4);
                    JSONObject.writeValue(writer, this.myArrayList.get(i), n, n4);
                    bl = true;
                }
                if (n > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n2);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

