/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    public static final Object NULL = new Null();
    private final Map<String, Object> map = new HashMap<String, Object>();

    public JSONObject() {
    }

    public JSONObject(Object object) {
        this();
        this.populateMap(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject(Object object, String[] stringArray) {
        this();
        Class<?> clazz = object.getClass();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            try {
                this.putOpt(string2, clazz.getField(string2).get(object));
            }
            catch (Exception exception) {}
            ++n;
        }
        return;
    }

    public JSONObject(String string2) throws JSONException {
        this(new JSONTokener(string2));
    }

    public JSONObject(String object, Locale object2) throws JSONException {
        this();
        ResourceBundle resourceBundle = ResourceBundle.getBundle((String)object, (Locale)object2, Thread.currentThread().getContextClassLoader());
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object == null) continue;
            String string2 = object;
            String[] stringArray = string2.split("\\.");
            int n = stringArray.length - 1;
            object2 = this;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i];
                JSONObject jSONObject = ((JSONObject)object2).optJSONObject(string3);
                object = jSONObject;
                if (jSONObject == null) {
                    object = new JSONObject();
                    ((JSONObject)object2).put(string3, object);
                }
                object2 = object;
            }
            ((JSONObject)object2).put(stringArray[n], resourceBundle.getString(string2));
        }
    }

    public JSONObject(Map<String, Object> object) {
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                Object v = entry.getValue();
                if (v == null) continue;
                this.map.put((String)entry.getKey(), JSONObject.wrap(v));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject(JSONObject jSONObject, String[] stringArray) {
        this();
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.putOnce(stringArray[n], jSONObject.opt(stringArray[n]));
            }
            catch (Exception exception) {}
            ++n;
        }
        return;
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() == '{') {
            char c;
            while ((c = jSONTokener.nextClean()) != '\u0000') {
                if (c != '}') {
                    jSONTokener.back();
                    String string2 = jSONTokener.nextValue().toString();
                    if (jSONTokener.nextClean() == ':') {
                        this.putOnce(string2, jSONTokener.nextValue());
                        c = jSONTokener.nextClean();
                        if (c != ',' && c != ';') {
                            if (c == '}') {
                                return;
                            }
                            throw jSONTokener.syntaxError("Expected a ',' or '}'");
                        }
                        if (jSONTokener.nextClean() == '}') {
                            return;
                        }
                        jSONTokener.back();
                        continue;
                    }
                    throw jSONTokener.syntaxError("Expected a ':' after a key");
                }
                return;
            }
            throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
        }
        throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
    }

    public static String doubleToString(double d) {
        if (!Double.isInfinite(d) && !Double.isNaN(d)) {
            String string2;
            String string3 = string2 = Double.toString(d);
            if (string2.indexOf(46) > 0) {
                string3 = string2;
                if (string2.indexOf(101) < 0) {
                    string3 = string2;
                    if (string2.indexOf(69) < 0) {
                        while (string2.endsWith("0")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        string3 = string2;
                        if (string2.endsWith(".")) {
                            string3 = string2.substring(0, string2.length() - 1);
                        }
                    }
                }
            }
            return string3;
        }
        return "null";
    }

    public static String[] getNames(Object stringArray) {
        if (stringArray == null) {
            return null;
        }
        Field[] fieldArray = stringArray.getClass().getFields();
        int n = fieldArray.length;
        if (n == 0) {
            return null;
        }
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fieldArray[i].getName();
        }
        return stringArray;
    }

    public static String[] getNames(JSONObject object) {
        int n = ((JSONObject)object).length();
        if (n == 0) {
            return null;
        }
        object = ((JSONObject)object).keys();
        String[] stringArray = new String[n];
        n = 0;
        while (object.hasNext()) {
            stringArray[n] = (String)object.next();
            ++n;
        }
        return stringArray;
    }

    static final void indent(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
    }

    public static String numberToString(Number object) throws JSONException {
        if (object != null) {
            JSONObject.testValidity(object);
            String string2 = object.toString();
            object = string2;
            if (string2.indexOf(46) > 0) {
                object = string2;
                if (string2.indexOf(101) < 0) {
                    object = string2;
                    if (string2.indexOf(69) < 0) {
                        while (string2.endsWith("0")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        object = string2;
                        if (string2.endsWith(".")) {
                            object = string2.substring(0, string2.length() - 1);
                        }
                    }
                }
            }
            return object;
        }
        throw new JSONException("Null pointer");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateMap(Object object) {
        Object object2 = object.getClass();
        int n = ((Class)object2).getClassLoader() != null ? 1 : 0;
        Method[] methodArray = n != 0 ? ((Class)object2).getMethods() : ((Class)object2).getDeclaredMethods();
        n = 0;
        while (true) {
            block12: {
                if (n >= methodArray.length) {
                    return;
                }
                Method method = methodArray[n];
                try {
                    if (!Modifier.isPublic(method.getModifiers())) break block12;
                    String string2 = method.getName();
                    boolean bl = string2.startsWith("get");
                    Object object3 = "";
                    if (bl) {
                        object2 = object3;
                        if (!"getClass".equals(string2)) {
                            object2 = "getDeclaringClass".equals(string2) ? object3 : string2.substring(3);
                        }
                    } else {
                        object2 = object3;
                        if (string2.startsWith("is")) {
                            object2 = string2.substring(2);
                        }
                    }
                    if (((String)object2).length() <= 0 || !Character.isUpperCase(((String)object2).charAt(0)) || method.getParameterTypes().length != 0) break block12;
                    if (((String)object2).length() == 1) {
                        object3 = ((String)object2).toLowerCase();
                    } else {
                        object3 = object2;
                        if (!Character.isUpperCase(((String)object2).charAt(1))) {
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append(((String)object2).substring(0, 1).toLowerCase());
                            ((StringBuilder)object3).append(((String)object2).substring(1));
                            object3 = ((StringBuilder)object3).toString();
                        }
                    }
                    object2 = null;
                    object2 = method.invoke(object, null);
                    if (object2 != null) {
                        this.map.put((String)object3, JSONObject.wrap(object2));
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    public static Writer quote(String string2, Writer writer) throws IOException {
        block8: {
            if (string2 == null || string2.length() == 0) break block8;
            int n = string2.length();
            writer.write(34);
            char c = '\u0000';
            for (int i = 0; i < n; ++i) {
                char c2;
                block13: {
                    block9: {
                        block10: {
                            block11: {
                                block12: {
                                    c2 = string2.charAt(i);
                                    if (c2 == '\f') break block9;
                                    if (c2 == '\r') break block10;
                                    if (c2 == '\"') break block11;
                                    if (c2 == '/') break block12;
                                    if (c2 == '\\') break block11;
                                    switch (c2) {
                                        default: {
                                            if (!(c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100')) {
                                                writer.write(c2);
                                                break;
                                            }
                                            writer.write("\\u");
                                            String string3 = Integer.toHexString(c2);
                                            writer.write("0000", 0, 4 - string3.length());
                                            writer.write(string3);
                                            break;
                                        }
                                        case '\n': {
                                            writer.write("\\n");
                                            break;
                                        }
                                        case '\t': {
                                            writer.write("\\t");
                                            break;
                                        }
                                        case '\b': {
                                            writer.write("\\b");
                                            break;
                                        }
                                    }
                                    break block13;
                                }
                                if (c == '<') {
                                    writer.write(92);
                                }
                                writer.write(c2);
                                break block13;
                            }
                            writer.write(92);
                            writer.write(c2);
                            break block13;
                        }
                        writer.write("\\r");
                        break block13;
                    }
                    writer.write("\\f");
                }
                c = c2;
            }
            writer.write(34);
            return writer;
        }
        writer.write("\"\"");
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String quote(String string2) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            try {
                try {
                    return JSONObject.quote(string2, stringWriter).toString();
                }
                catch (IOException iOException) {
                    return "";
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object stringToValue(String string2) {
        if (string2.equals("")) {
            return string2;
        }
        if (string2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string2.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c = string2.charAt(0);
        if (c < '0' || c > '9') {
            if (c != '-') return string2;
        }
        try {
            if (string2.indexOf(46) <= -1 && string2.indexOf(101) <= -1 && string2.indexOf(69) <= -1) {
                Long l = new Long(string2);
                if (!string2.equals(l.toString())) return string2;
                if (l != (long)l.intValue()) return l;
                return l.intValue();
            }
            Double d = Double.valueOf(string2);
            if (d.isInfinite()) return string2;
            boolean bl = d.isNaN();
            if (bl) return string2;
            return d;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static void testValidity(Object object) throws JSONException {
        if (object != null) {
            if (object instanceof Double) {
                if (((Double)(object = (Double)object)).isInfinite() || ((Double)object).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers.");
                }
            } else if (object instanceof Float && (((Float)(object = (Float)object)).isInfinite() || ((Float)object).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public static String valueToString(Object object) throws JSONException {
        if (object != null && !object.equals(null)) {
            if (object instanceof JSONString) {
                try {
                    object = ((JSONString)object).toJSONString();
                }
                catch (Exception exception) {
                    throw new JSONException(exception);
                }
                if (object instanceof String) {
                    String string2 = (String)object;
                    return object;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Bad value from toJSONString: ");
                stringBuilder.append(object);
                throw new JSONException(stringBuilder.toString());
            }
            if (object instanceof Number) {
                return JSONObject.numberToString((Number)object);
            }
            if (!(object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray)) {
                if (object instanceof Map) {
                    return new JSONObject((Map)object).toString();
                }
                if (object instanceof Collection) {
                    return new JSONArray((Collection)object).toString();
                }
                if (object.getClass().isArray()) {
                    return new JSONArray(object).toString();
                }
                return JSONObject.quote(object.toString());
            }
            return object.toString();
        }
        return "null";
    }

    public static Object wrap(Object object) {
        Object object2;
        block24: {
            block27: {
                block26: {
                    block25: {
                        if (object == null) {
                            return NULL;
                        }
                        object2 = object;
                        try {
                            if (object instanceof JSONObject) break block24;
                            object2 = object;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        if (object instanceof JSONArray) break block24;
                        object2 = object;
                        if (NULL.equals(object)) break block24;
                        object2 = object;
                        if (object instanceof JSONString) break block24;
                        object2 = object;
                        if (object instanceof Byte) break block24;
                        object2 = object;
                        if (object instanceof Character) break block24;
                        object2 = object;
                        if (object instanceof Short) break block24;
                        object2 = object;
                        if (object instanceof Integer) break block24;
                        object2 = object;
                        if (object instanceof Long) break block24;
                        object2 = object;
                        if (object instanceof Boolean) break block24;
                        object2 = object;
                        if (object instanceof Float) break block24;
                        object2 = object;
                        if (object instanceof Double) break block24;
                        object2 = object;
                        if (object instanceof String) break block24;
                        object2 = object;
                        if (object instanceof BigInteger) break block24;
                        if (!(object instanceof BigDecimal)) break block25;
                        object2 = object;
                        break block24;
                    }
                    if (object instanceof Collection) {
                        return new JSONArray((Collection)object);
                    }
                    if (object.getClass().isArray()) {
                        return new JSONArray(object);
                    }
                    if (object instanceof Map) {
                        return new JSONObject((Map)object);
                    }
                    object2 = object.getClass().getPackage();
                    if (object2 == null) break block26;
                    object2 = ((Package)object2).getName();
                    break block27;
                }
                object2 = "";
            }
            if (!((String)object2).startsWith("java.") && !((String)object2).startsWith("javax.") && object.getClass().getClassLoader() != null) {
                return new JSONObject(object);
            }
            object2 = object.toString();
        }
        return object2;
    }

    static final Writer writeValue(Writer writer, Object object, int n, int n2) throws JSONException, IOException {
        block4: {
            block2: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                if (object == null || object.equals(null)) break block2;
                                                if (!(object instanceof JSONObject)) break block3;
                                                ((JSONObject)object).write(writer, n, n2);
                                                break block4;
                                            }
                                            if (!(object instanceof JSONArray)) break block5;
                                            ((JSONArray)object).write(writer, n, n2);
                                            break block4;
                                        }
                                        if (!(object instanceof Map)) break block6;
                                        new JSONObject((Map)object).write(writer, n, n2);
                                        break block4;
                                    }
                                    if (!(object instanceof Collection)) break block7;
                                    new JSONArray((Collection)object).write(writer, n, n2);
                                    break block4;
                                }
                                if (!object.getClass().isArray()) break block8;
                                new JSONArray(object).write(writer, n, n2);
                                break block4;
                            }
                            if (!(object instanceof Number)) break block9;
                            writer.write(JSONObject.numberToString((Number)object));
                            break block4;
                        }
                        if (!(object instanceof Boolean)) break block10;
                        writer.write(object.toString());
                        break block4;
                    }
                    if (!(object instanceof JSONString)) break block11;
                    try {
                        String string2 = ((JSONString)object).toJSONString();
                        object = string2 != null ? string2.toString() : JSONObject.quote(object.toString());
                    }
                    catch (Exception exception) {
                        throw new JSONException(exception);
                    }
                    writer.write((String)object);
                    break block4;
                }
                JSONObject.quote(object.toString(), writer);
                break block4;
            }
            writer.write("null");
        }
        return writer;
    }

    public JSONObject accumulate(String string2, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string2);
        if (object2 == null) {
            object2 = object;
            if (object instanceof JSONArray) {
                object2 = new JSONArray().put(object);
            }
            this.put(string2, object2);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string2, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string2, Object object) throws JSONException {
        block4: {
            block3: {
                Object object2;
                block2: {
                    JSONObject.testValidity(object);
                    object2 = this.opt(string2);
                    if (object2 != null) break block2;
                    this.put(string2, new JSONArray().put(object));
                    break block3;
                }
                if (!(object2 instanceof JSONArray)) break block4;
                this.put(string2, ((JSONArray)object2).put(object));
            }
            return this;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("] is not a JSONArray.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public Object get(String string2) throws JSONException {
        if (string2 != null) {
            Object object = this.opt(string2);
            if (object != null) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("JSONObject[");
            ((StringBuilder)object).append(JSONObject.quote(string2));
            ((StringBuilder)object).append("] not found.");
            throw new JSONException(((StringBuilder)object).toString());
        }
        throw new JSONException("Null key.");
    }

    public BigDecimal getBigDecimal(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            object = new BigDecimal(object.toString());
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONObject[");
            stringBuilder.append(JSONObject.quote(string2));
            stringBuilder.append("] could not be converted to BigDecimal.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public BigInteger getBigInteger(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            object = new BigInteger(object.toString());
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONObject[");
            stringBuilder.append(JSONObject.quote(string2));
            stringBuilder.append("] could not be converted to BigInteger.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public boolean getBoolean(String string2) throws JSONException {
        boolean bl;
        Object object = this.get(string2);
        if (!(object.equals(Boolean.FALSE) || (bl = object instanceof String) && ((String)object).equalsIgnoreCase("false"))) {
            if (!(object.equals(Boolean.TRUE) || bl && ((String)object).equalsIgnoreCase("true"))) {
                object = new StringBuilder();
                ((StringBuilder)object).append("JSONObject[");
                ((StringBuilder)object).append(JSONObject.quote(string2));
                ((StringBuilder)object).append("] is not a Boolean.");
                throw new JSONException(((StringBuilder)object).toString());
            }
            return true;
        }
        return false;
    }

    public double getDouble(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            double d = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
            return d;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONObject[");
            stringBuilder.append(JSONObject.quote(string2));
            stringBuilder.append("] is not a number.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String string2) throws JSONException {
        Object object = this.optEnum(clazz, string2);
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(JSONObject.quote(string2));
        ((StringBuilder)object).append("] is not an enum of type ");
        ((StringBuilder)object).append(JSONObject.quote(clazz.getSimpleName()));
        ((StringBuilder)object).append(".");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public int getInt(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            int n = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
            return n;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONObject[");
            stringBuilder.append(JSONObject.quote(string2));
            stringBuilder.append("] is not an int.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public JSONArray getJSONArray(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(JSONObject.quote(string2));
        ((StringBuilder)object).append("] is not a JSONArray.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public JSONObject getJSONObject(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(JSONObject.quote(string2));
        ((StringBuilder)object).append("] is not a JSONObject.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public long getLong(String string2) throws JSONException {
        Object object = this.get(string2);
        try {
            long l = object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
            return l;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSONObject[");
            stringBuilder.append(JSONObject.quote(string2));
            stringBuilder.append("] is not a long.");
            throw new JSONException(stringBuilder.toString());
        }
    }

    public String getString(String string2) throws JSONException {
        Object object = this.get(string2);
        if (object instanceof String) {
            return (String)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("JSONObject[");
        ((StringBuilder)object).append(JSONObject.quote(string2));
        ((StringBuilder)object).append("] not a string.");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public boolean has(String string2) {
        return this.map.containsKey(string2);
    }

    public JSONObject increment(String string2) throws JSONException {
        Object object;
        block9: {
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        object = this.opt(string2);
                                        if (object != null) break block2;
                                        this.put(string2, 1);
                                        break block3;
                                    }
                                    if (!(object instanceof BigInteger)) break block4;
                                    this.put(string2, ((BigInteger)object).add(BigInteger.ONE));
                                    break block3;
                                }
                                if (!(object instanceof BigDecimal)) break block5;
                                this.put(string2, ((BigDecimal)object).add(BigDecimal.ONE));
                                break block3;
                            }
                            if (!(object instanceof Integer)) break block6;
                            this.put(string2, (Integer)object + 1);
                            break block3;
                        }
                        if (!(object instanceof Long)) break block7;
                        this.put(string2, (Long)object + 1L);
                        break block3;
                    }
                    if (!(object instanceof Double)) break block8;
                    this.put(string2, (Double)object + 1.0);
                    break block3;
                }
                if (!(object instanceof Float)) break block9;
                this.put(string2, ((Float)object).floatValue() + 1.0f);
            }
            return this;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unable to increment [");
        ((StringBuilder)object).append(JSONObject.quote(string2));
        ((StringBuilder)object).append("].");
        throw new JSONException(((StringBuilder)object).toString());
    }

    public boolean isNull(String string2) {
        return NULL.equals(this.opt(string2));
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Object object = this.keys();
        while (object.hasNext()) {
            jSONArray.put(object.next());
        }
        object = jSONArray;
        if (jSONArray.length() == 0) {
            object = null;
        }
        return object;
    }

    public Object opt(String object) {
        object = object == null ? null : this.map.get(object);
        return object;
    }

    public BigDecimal optBigDecimal(String object, BigDecimal bigDecimal) {
        try {
            object = this.getBigDecimal((String)object);
            return object;
        }
        catch (Exception exception) {
            return bigDecimal;
        }
    }

    public BigInteger optBigInteger(String object, BigInteger bigInteger) {
        try {
            object = this.getBigInteger((String)object);
            return object;
        }
        catch (Exception exception) {
            return bigInteger;
        }
    }

    public boolean optBoolean(String string2) {
        return this.optBoolean(string2, false);
    }

    public boolean optBoolean(String string2, boolean bl) {
        try {
            boolean bl2 = this.getBoolean(string2);
            return bl2;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(String string2) {
        return this.optDouble(string2, Double.NaN);
    }

    public double optDouble(String string2, double d) {
        try {
            double d2 = this.getDouble(string2);
            return d2;
        }
        catch (Exception exception) {
            return d;
        }
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String string2) {
        return this.optEnum(clazz, string2, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String object, E e) {
        block4: {
            object = this.opt((String)object);
            if (!NULL.equals(object)) break block4;
            return e;
        }
        try {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (E)((Enum)object);
            }
            clazz = Enum.valueOf(clazz, object.toString());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return e;
        }
        return (E)clazz;
    }

    public int optInt(String string2) {
        return this.optInt(string2, 0);
    }

    public int optInt(String string2, int n) {
        try {
            int n2 = this.getInt(string2);
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JSONArray optJSONArray(String object) {
        object = (object = this.opt((String)object)) instanceof JSONArray ? (JSONArray)object : null;
        return object;
    }

    public JSONObject optJSONObject(String object) {
        object = (object = this.opt((String)object)) instanceof JSONObject ? (JSONObject)object : null;
        return object;
    }

    public long optLong(String string2) {
        return this.optLong(string2, 0L);
    }

    public long optLong(String string2, long l) {
        try {
            long l2 = this.getLong(string2);
            return l2;
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string2) {
        return this.optString(string2, "");
    }

    public String optString(String object, String string2) {
        if (!NULL.equals(object = this.opt((String)object))) {
            string2 = object.toString();
        }
        return string2;
    }

    public JSONObject put(String string2, double d) throws JSONException {
        this.put(string2, new Double(d));
        return this;
    }

    public JSONObject put(String string2, int n) throws JSONException {
        this.put(string2, new Integer(n));
        return this;
    }

    public JSONObject put(String string2, long l) throws JSONException {
        this.put(string2, new Long(l));
        return this;
    }

    public JSONObject put(String string2, Object object) throws JSONException {
        Objects.requireNonNull(string2, "Null key.");
        if (object != null) {
            JSONObject.testValidity(object);
            this.map.put(string2, object);
        } else {
            this.remove(string2);
        }
        return this;
    }

    public JSONObject put(String string2, Collection<Object> collection) throws JSONException {
        this.put(string2, new JSONArray(collection));
        return this;
    }

    public JSONObject put(String string2, Map<String, Object> map) throws JSONException {
        this.put(string2, new JSONObject(map));
        return this;
    }

    public JSONObject put(String string2, boolean bl) throws JSONException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.put(string2, bl2);
        return this;
    }

    public JSONObject putOnce(String string2, Object object) throws JSONException {
        if (string2 != null && object != null) {
            if (this.opt(string2) == null) {
                this.put(string2, object);
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("Duplicate key \"");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("\"");
                throw new JSONException(((StringBuilder)object).toString());
            }
        }
        return this;
    }

    public JSONObject putOpt(String string2, Object object) throws JSONException {
        if (string2 != null && object != null) {
            this.put(string2, object);
        }
        return this;
    }

    public Object remove(String string2) {
        return this.map.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean similar(Object object) {
        try {
            boolean bl;
            Object object2;
            Object object3;
            if (!(object instanceof JSONObject)) {
                return false;
            }
            Set<String> set = this.keySet();
            if (!set.equals(((JSONObject)object).keySet())) {
                return false;
            }
            set = set.iterator();
            do {
                if (!set.hasNext()) {
                    return true;
                }
                object2 = (String)set.next();
                object3 = this.get((String)object2);
                object2 = ((JSONObject)object).get((String)object2);
            } while (!(object3 instanceof JSONObject ? !((JSONObject)object3).similar(object2) : (object3 instanceof JSONArray ? !((JSONArray)object3).similar(object2) : !(bl = object3.equals(object2)))));
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        if (jSONArray != null && jSONArray.length() != 0) {
            JSONArray jSONArray2 = new JSONArray();
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONArray2.put(this.opt(jSONArray.getString(i)));
            }
            return jSONArray2;
        }
        return null;
    }

    public String toString() {
        try {
            String string2 = this.toString(0);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString(int n) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            return this.write(stringWriter, n, 0).toString();
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Writer write(Writer writer, int n, int n2) throws JSONException {
        boolean bl = false;
        try {
            int n3 = this.length();
            Object object = this.keys();
            writer.write(123);
            if (n3 == 1) {
                object = object.next();
                writer.write(JSONObject.quote(object.toString()));
                writer.write(58);
                if (n > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue(writer, this.map.get(object), n, n2);
            } else if (n3 != 0) {
                n3 = n2 + n;
                while (object.hasNext()) {
                    Object e = object.next();
                    if (bl) {
                        writer.write(44);
                    }
                    if (n > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n3);
                    writer.write(JSONObject.quote(e.toString()));
                    writer.write(58);
                    if (n > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue(writer, this.map.get(e), n, n3);
                    bl = true;
                }
                if (n > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n2);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            boolean bl = object == null || object == this;
            return bl;
        }

        public String toString() {
            return "null";
        }
    }
}

