/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    private long character;
    private boolean eof;
    private long index;
    private long line;
    private char previous;
    private Reader reader;
    private boolean usePrevious;

    public JSONTokener(InputStream inputStream) throws JSONException {
        this(new InputStreamReader(inputStream));
    }

    public JSONTokener(Reader reader) {
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.eof = false;
        this.usePrevious = false;
        this.previous = (char)0;
        this.index = 0L;
        this.character = 1L;
        this.line = 1L;
    }

    public JSONTokener(String string2) {
        this(new StringReader(string2));
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public void back() throws JSONException {
        long l;
        if (!this.usePrevious && (l = this.index) > 0L) {
            this.index = l - 1L;
            --this.character;
            this.usePrevious = true;
            this.eof = false;
            return;
        }
        throw new JSONException("Stepping back two steps is not supported");
    }

    public boolean end() {
        boolean bl = this.eof && !this.usePrevious;
        return bl;
    }

    public boolean more() throws JSONException {
        this.next();
        if (this.end()) {
            return false;
        }
        this.back();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char next() throws JSONException {
        char c;
        int n;
        boolean bl = this.usePrevious;
        int n2 = 0;
        if (bl) {
            this.usePrevious = false;
            n = this.previous;
        } else {
            try {
                n = this.reader.read();
                if (n <= 0) {
                    this.eof = true;
                    n = n2;
                }
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
        }
        long l = this.index;
        long l2 = 1L;
        this.index = l + 1L;
        if (this.previous == '\r') {
            ++this.line;
            if (n == 10) {
                l2 = 0L;
            }
            this.character = l2;
        } else if (n == 10) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        this.previous = c = (char)n;
        return c;
    }

    public char next(char c) throws JSONException {
        char c2 = this.next();
        if (c2 == c) {
            return c2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected '");
        stringBuilder.append(c);
        stringBuilder.append("' and instead saw '");
        stringBuilder.append(c2);
        stringBuilder.append("'");
        throw this.syntaxError(stringBuilder.toString());
    }

    public String next(int n) throws JSONException {
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.next();
            if (!this.end()) {
                continue;
            }
            throw this.syntaxError("Substring bounds error");
        }
        return new String(cArray);
    }

    public char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String nextString(char c) throws JSONException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((c2 = this.next()) != '\u0000' && c2 != '\n' && c2 != '\r') {
            if (c2 != '\\') {
                if (c2 == c) {
                    return stringBuilder.toString();
                }
                stringBuilder.append(c2);
                continue;
            }
            c2 = this.next();
            if (c2 != '\"' && c2 != '\'' && c2 != '/' && c2 != '\\') {
                if (c2 != 'b') {
                    if (c2 != 'f') {
                        if (c2 != 'n') {
                            if (c2 != 'r') {
                                if (c2 != 't') {
                                    if (c2 == 'u') {
                                        stringBuilder.append((char)Integer.parseInt(this.next(4), 16));
                                        continue;
                                    }
                                    throw this.syntaxError("Illegal escape.");
                                }
                                stringBuilder.append('\t');
                                continue;
                            }
                            stringBuilder.append('\r');
                            continue;
                        }
                        stringBuilder.append('\n');
                        continue;
                    }
                    stringBuilder.append('\f');
                    continue;
                }
                stringBuilder.append('\b');
                continue;
            }
            stringBuilder.append(c2);
        }
        throw this.syntaxError("Unterminated string");
    }

    public String nextTo(char c) throws JSONException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((c2 = this.next()) != c && c2 != '\u0000' && c2 != '\n' && c2 != '\r') {
            stringBuilder.append(c2);
        }
        if (c2 != '\u0000') {
            this.back();
        }
        return stringBuilder.toString().trim();
    }

    public String nextTo(String string2) throws JSONException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (string2.indexOf(c = this.next()) < 0 && c != '\u0000' && c != '\n' && c != '\r') {
            stringBuilder.append(c);
        }
        if (c != '\u0000') {
            this.back();
        }
        return stringBuilder.toString().trim();
    }

    public Object nextValue() throws JSONException {
        char c = this.nextClean();
        if (c != '\"' && c != '\'') {
            if (c != '[') {
                if (c != '{') {
                    CharSequence charSequence = new StringBuilder();
                    while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                        char c2;
                        charSequence.append(c);
                        c = c2 = this.next();
                    }
                    this.back();
                    charSequence = charSequence.toString().trim();
                    if (!"".equals(charSequence)) {
                        return JSONObject.stringToValue((String)charSequence);
                    }
                    throw this.syntaxError("Missing value");
                }
                this.back();
                return new JSONObject(this);
            }
            this.back();
            return new JSONArray(this);
        }
        return this.nextString(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char skipTo(char c) throws JSONException {
        try {
            char c2;
            long l = this.index;
            long l2 = this.character;
            long l3 = this.line;
            this.reader.mark(1000000);
            do {
                if ((c2 = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = l;
                this.character = l2;
                this.line = l3;
                return c2;
            } while (c2 != c);
            this.back();
            return c2;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    public JSONException syntaxError(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(this.toString());
        return new JSONException(stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" at ");
        stringBuilder.append(this.index);
        stringBuilder.append(" [character ");
        stringBuilder.append(this.character);
        stringBuilder.append(" line ");
        stringBuilder.append(this.line);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

